# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::self::join;
use base 'AXP::Command::self';

use Arch::Util qw(load_file save_file);

sub infoline {
	"embed all Arch classes in the single executable"
}

sub optusage {
	"[options] [script]"
}

sub options {
	(
		output  => { sh => 'o', type => "=s", arg => 'FILE', desc => "write to FILE rather than stdout" },
		verbose => { sh => 'v', desc => "be more verbose" },
		quiet   => { sh => 'q', desc => "be quiet" },
	)
}

sub helptext {
	q{
		Embeds all Arch classes (and AXP, ArchZoom, ArchWay classes
		too, depending on whether the script uses one of them.

		The produced executable has the properties of being equal to
		the original one, but no external modules are required. Such
		script may be simply placed somewhere in $PATH and executed.

		Example:
			axp self join >axp-joined
			axp self join -o ~/bin/archmag ../archway/bin/archmag
	}
}

sub execute {
	my $self = shift;
	my %opt = %{$self->{options}};

	die "Not implemented yet\n";
}

1;
