#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Test archive mirror creation
# Copyright © 2003 Colin Walters <walters@verbum.org>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_empty_archives

test_class "Archive mirror creation"

begin_test "Archive mirror creation 1"
tla make-archive --mirror jane@example.com--2003 $(pwd)/jane-archive-mirror
test "$(tla whereis-archive jane@example.com--2003-MIRROR)" = $(pwd)/jane-archive-mirror
test -f jane-archive-mirror/=meta-info/mirror
test $(cat jane-archive-mirror/=meta-info/mirror) = "jane@example.com--2003"
end_test

begin_test "Archive mirror creation 2 (with listing)"
tla make-archive --listing --mirror foo@example.org--2003 $(pwd)/foo-archive-mirror
test "$(tla whereis-archive foo@example.org--2003-MIRROR)" = $(pwd)/foo-archive-mirror
test -f foo-archive-mirror/=meta-info/mirror
test $(cat foo-archive-mirror/=meta-info/mirror) = "foo@example.org--2003"
end_test 

clean_workdir

# tag: Colin Walters Tue, 16 Sep 2003 23:03:55 -0400 (test-mirror-creation.sh)
#
