/*
 * sequencer handler
 *
 * Copyright (C) 1996-1998 Takashi Iwai
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef SEQ_H_DEF
#define SEQ_H_DEF

extern void seqbuf_dump();

/* open / close sequencer device */
int seq_init(int do_echoback);
void seq_end(void);
int seq_opened(void);

void seq_blocking_mode(int mode);
int seq_pending(void);
void seq_check_pending(void);

/* timer controls */
int seq_system_ticks(void);
void seq_clear(int csec);
int seq_timer_started(void);
int seq_lasttime(void);
int seq_curtime(void);
void seq_wait(int time);
void seq_echo(int csec);
int seq_sleep(int csec);
int seq_wait_time(int csec);
int seq_mem_avail(void);

/* immediately reset voices */
void seq_terminate_all(void);

/* send seq events */
void seq_set_bank(int v, int bank);
void seq_set_program(int v, int pgm);
void seq_start_note(int v, int note, int vel);
void seq_stop_note(int v, int note, int vel);
void seq_control(int v, int type, int val);
void seq_aftertouch(int v, int note, int vel);
void seq_chan_pressure(int v, int val);
void seq_pitchsense(int v, int val);
void seq_pitchbend(int v, int val);
void seq_send_effect(int v, int type, int val);
void seq_add_effect(int v, int type, int val);
void seq_soft_pedal(int v, int val);
void seq_note_off_all(void);
void seq_sound_off_all(void);

/* send status as buffered */
void seq_reset_channel(int v);
void seq_reset_control(int v);
void seq_set_drumchannels(int channels);
void seq_channel_priority(int mode);
void seq_detune(int v, int coarse, int fine);
void seq_set_realtime_pan(int mode);
void seq_set_def_drum(int val);
void seq_new_volume_mode(int mode);

/* immediately change status */
void seq_set_chorus(int mode);
void seq_set_reverb(int mode);
void seq_change_volume(int vol);
void seq_equalizer(int bass, int treble);
void seq_clear_samples(void);
void seq_remove_samples(void);

#endif
