/*  -*- Mode: Asm -*-  */
/*
    sin.S is part of     FPlib V 0.3.0       ported to avr-as
    for copyright and details see readme.fplib

 *----------------------------------------------------------------------------------------
 *
 *	A = sin(A) = cos(A-PI/2)
 */

#include "gasava.inc"
#include "fplib.inc"

          TEXT_SEG(fplib, sin)
          FUNCTION(sin)

GLOBAL(sin)
       PUSH   rA3
       ANDI   rA3,0x7F
       CPI    rA3,0x39
       BRCS   _sin_00		; |A| < 0x38FFFFFF -> sin(A) = A

       LDI    rB3,0x40
       LDI    rB2,0xC9
       LDI    rB1,0x0F
       LDI    rB0,0xDB		; load 2*PI
       RCALL  _U(fmod)		; X = remainder X/2PI

       LDI    rB3,0xBF
       LDI    rB2,0xC9
       LDI    rB1,0x0F
       LDI    rB0,0xDB		; load -PI/2
       RCALL  _U(__addsf3)	; A - PI/2
       RCALL  _U(fp_cosinus)
 _sin_00:
       POP    rB3
       ANDI   rB3,0x80
       EOR    rA3,rB3		; invert sign, if
       RET

          ENDFUNC


