/*  -*- Mode: Asm -*-  */
/*
    fmod.S is part of     FPlib V 0.3.0       ported to avr-as
    for copyright and details see readme.fplib

 *----------------------------------------------------------------------------------------
 * A = remainder( A/B )
 */

#include "gasava.inc"
#include "fplib.inc"

          TEXT_SEG(fplib, fmod)
          FUNCTION(fmod)

GLOBAL(fmod)
	/* fmod = x % y = x - (floor)(x/y)*y ??
	 *
	 * fmod   x  10.5     -10.5
	 * y   PI    1.075..  -1.075..
	 *    -PI    1.075..  -1.075..
	 */
    ANDI    rB3,0x7F	; fmod(x,y) = sgn(x) * fmod(|x|,|y|)
    TST     rB3		; -0 ?
    BRNE    _fmod_01
    TST     rB2
    BRMI    _fmod_01
    RJMP    _U(__fp_nanERANGE)
 _fmod_01:
    PUSH    rB0
    PUSH    rB1
    PUSH    rB2
    PUSH    rB3
    RCALL   _U(__divsf3)	; A = x/y
    CLR     rP4
    CLR     rP5			; point to NUL
    RCALL   _U(modf)		; A = fraction( x/y )
    POP     rB3
    POP     rB2
    POP     rB1
    POP     rB0			; B = y
    RJMP    _U(__mulsf3)	; A = y * fraction( x/y )

          ENDFUNC


