/*
   iotn28.h - internal register definitions for ATtiny28

   Contributors:
     Created by Marek Michalkiewicz <marekm@linux.org.pl>

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   Based on preliminary Atmel datasheet Rev. 1062B-10/99.
 */

#ifndef __IOTN28
#define __IOTN28

#ifndef __ASSEMBLER__
#  warning "MCU not supported by the C compiler"
#endif

/* I/O space addresses */

#define OSCCAL	0x00

#define WDTCR	0x01

#define MODCR	0x02

#define TCNT0	0x03
#define TCCR0	0x04

#define IFR	0x05
#define ICR	0x06

#define MCUCS	0x07

#define ACSR	0x08

/* 0x09..0x0F reserved */

#define PIND	0x10
#define DDRD	0x11
#define PORTD	0x12

/* 0x13..0x15 reserved */

#define PINB	0x16

/* 0x17..0x18 reserved */

#define PINA	0x19
#define PACR	0x1A
#define PORTA	0x1B

/* 0x1C..0x3E reserved */

#define SREG	0x3F

/* Interrupt vectors (byte addresses) */

#define SIG_INTERRUPT0		_vector_1
#define SIG_INTERRUPT1		_vector_2
#define SIG_PIN			_vector_3
#define SIG_OVERFLOW0		_vector_4
#define SIG_COMPARATOR		_vector_5

#define END_VECTOR		(5)
#define INT_VECT_SIZE (0x0c)

/* Bit numbers */

/* ICR */
#define INT1	7
#define INT0	6
#define LLIE	5
#define TOIE0	4
#define ISC11	3
#define ISC10	2
#define ISC01	1
#define ISC00

/* IFR */
#define INTF1	7
#define INTF0	6
#define TOV0	4

/* MCUCS */
#define PLUPB	7
#define SE	5
#define SM	4
#define WDRF	3
#define EXTRF	1
#define PORF	0

/* TCCR0 */
#define FOV0	7
#define OOM01	4
#define OOM00	3
#define CS02	2
#define CS01	1
#define CS00	0

/* MODCR */
#define ONTIM4	7
#define ONTIM3	6
#define ONTIM2	5
#define ONTIM1	4
#define ONTIM0	3
#define MCONF2	2
#define MCONF1	1
#define MCONF0	0

/* WDTCR */
#define WDTOE	4
#define WDE	3
#define WDP2	2
#define WDP1	1
#define WDP0	0

/* EECR */
#define EERIE	3
#define EEMWE	2
#define EEWE	1
#define EERE	0

/*
   PA2 = IR
 */

/* PORTA */
#define PA3	3
#define PA2	2
#define PA1	1
#define PA0	0

/* PACR */
#define DDA3	3
#define PA2HC	2
#define DDA1	1
#define DDA0	0

/* PINA */
#define PINA3	3
#define PINA1	1
#define PINA0	0

/*
   PB4 = INT1
   PB3 = INT0
   PB2 = T0
   PB1 = AIN1
   PB0 = AIN0
 */

/* PINB */
#define PINB7	7
#define PINB6	6
#define PINB5	5
#define PINB4	4
#define PINB3	3
#define PINB2	2
#define PINB1	1
#define PINB0	0

/* PORTD */
#define PD7	7
#define PD6	6
#define PD5	5
#define PD4	4
#define PD3	3
#define PD2	2
#define PD1	1
#define PD0	0

/* DDRD */
#define DDD7	7
#define DDD6	6
#define DDD5	5
#define DDD4	4
#define DDD3	3
#define DDD2	2
#define DDD1	1
#define DDD0	0

/* PIND */
#define PIND7	7
#define PIND6	6
#define PIND5	5
#define PIND4	4
#define PIND3	3
#define PIND2	2
#define PIND1	1
#define PIND0	0

/* ACSR */
#define ACD	7
#define ACO	5
#define ACI	4
#define ACIE	3
#define ACIS1	1
#define ACIS0	0

#define ZL r30
#define ZH r31

/* Last memory addresses */
#define RAMEND		0x1F
#define XRAMEND		0x0
#define E2END		0x0
#define FLASHEND	0x7FF

#endif  /* __IOTN28 */
