/* Argument 'width' test.
   $Id: dtostrf-width.c,v 1.1 2007/02/06 12:36:58 dmix Exp $
 */
#include <stdlib.h>
#include <string.h>
#include "progmem.h"

#define PATTERN_SIZE	20
#include "dtostrf.h"

PROGMEM static const struct dtostrf_s t[] = {

    { { .fl = .123 }, 0, 3,	"0.123" },
    { { .fl = .123 }, 1, 3,	"0.123" },
    { { .fl = .123 }, 5, 3,	"0.123" },
    { { .fl = .123 }, 6, 3,	" 0.123" },
    { { .fl = .123 }, 10, 3,	"     0.123" },
    { { .fl = -.123 }, 10, 3,	"    -0.123" },
    
    { { .fl = 123.45 }, 0, 2,	"123.45" },
    { { .fl = 123.45 }, 1, 2,	"123.45" },
    { { .fl = 123.45 }, 6, 2,	"123.45" },
    { { .fl = 123.45 }, 7, 2,	" 123.45" },
    { { .fl = 123.45 }, 10, 2,	"    123.45" },
    { { .fl = -123.45 }, 10, 2,	"   -123.45" },

    { { .fl = 10. }, 0, 0,	"10" },
    { { .fl = 10. }, 1, 0,	"10" },
    { { .fl = 10. }, 2, 0,	"10" },
    { { .fl = 10. }, 3, 0,	" 10" },
    { { .fl = 10. }, 10, 0,	"        10" },
    { { .fl = -10. }, 10, 0,	"       -10" },

    { { .fl = .123 }, -1, 3,	"0.123" },
    { { .fl = 123.45 }, -1, 2,	"123.45" },
    { { .fl = 10. }, -1, 0,	"10" },

    { { .fl = .123 }, -10, 3,	"0.123     " },
    { { .fl = -.123 }, -10, 3,	"-0.123    " },
    { { .fl = 123.45 }, -10, 2,	"123.45    " },
    { { .fl = -123.45 }, -10, 2,"-123.45   " },
    { { .fl = 10. }, -10, 0,	"10        " },
    { { .fl = -10. }, -10, 0,	"-10       " },
};

int main ()
{
    int i;
    for (i= 0; (size_t)i != sizeof(t)/sizeof(t[0]); i++)
	run_dtostrf (t+i, i+1);
    return 0;
}
