/* Test of division.  Random cases.
   $Id: div-500.c,v 1.1 2007/02/05 21:35:58 dmix Exp $
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases:  x / y = z	*/
    long x, y, z;
} t[] = {

    { 0x408a3b06, 0xbfeb7476, 0xc0164ac9 },  /*   1:  4.3197050e+00 -1.8394916e+00 -2.3483146e+00 */
    { 0xbfabe82e, 0xbca4bf35, 0x42859020 },  /*   2: -1.3430231e+00 -2.0110706e-02  6.6781498e+01 */
    { 0xbfedcca8, 0xbd99dd8e, 0x41c5d307 },  /*   3: -1.8578081e+00 -7.5129613e-02  2.4728040e+01 */
    { 0xc0fd8728, 0xbf0e220a, 0x41645186 },  /*   4: -7.9227486e+00 -5.5520689e-01  1.4269903e+01 */
    { 0x3f091196, 0x41006d52, 0x3d889ce9 },  /*   5:  5.3542459e-01  8.0266895e+00  6.6705531e-02 */
    { 0xbdd55979, 0xc12fceab, 0x3c1b5556 },  /*   6: -1.0417456e-01 -1.0987956e+01  9.4807953e-03 */
    { 0xbf300b97, 0xbe7a543f, 0x4034088b },  /*   7: -6.8767685e-01 -2.4446200e-01  2.8130215e+00 */
    { 0x40ecac54, 0x3fd6a26d, 0x408d249f },  /*   8:  7.3960361e+00  1.6768318e+00  4.4107202e+00 */
    { 0xfc179ac1, 0xbe147f11, 0x7d82addd },  /*   9: -3.1487024e+36 -1.4501597e-01  2.1712798e+37 */
    { 0xc180f271, 0xc140846b, 0x3fab77aa },  /*  10: -1.6118380e+01 -1.2032329e+01  1.3395894e+00 */
    { 0x483cda35, 0x3e90252c, 0x4927b31e },  /*  11:  1.9338483e+05  2.8153360e-01  6.8689787e+05 */
    { 0x3d9c8996, 0x3f1559b1, 0x3e0628df },  /*  12:  7.6434299e-02  5.8339983e-01  1.3101529e-01 */
    { 0x53466e7d, 0xbdf1f30b, 0xd4d1f47c },  /*  13:  8.5225721e+11 -1.1813935e-01 -7.2139996e+12 */
    { 0xbf438757, 0x41d75c27, 0xbce86d28 },  /*  14: -7.6378387e-01  2.6919996e+01 -2.8372362e-02 */
    { 0xbfe761cc, 0x3f2e8b09, 0xc029aeb4 },  /*  15: -1.8076720e+00  6.8180901e-01 -2.6512880e+00 */
    { 0xbdd5c193, 0x3c7286ba, 0xc0e1a1ac },  /*  16: -1.0437312e-01  1.4802629e-02 -7.0509853e+00 */
    { 0x3ddcad8b, 0x3d7c0bb8, 0x3fe023d8 },  /*  17:  1.0775288e-01  6.1534613e-02  1.7510938e+00 */
    { 0x3e440316, 0x416dafac, 0x3c531d66 },  /*  18:  1.9141802e-01  1.4855389e+01  1.2885427e-02 */
    { 0xc3546147, 0xbce1e5d7, 0x45f0ae4c },  /*  19: -2.1237999e+02 -2.7575416e-02  7.7017872e+03 */
    { 0x425650dd, 0x3d9f6d44, 0x442c11b2 },  /*  20:  5.3578968e+01  7.7845126e-02  6.8827646e+02 */
    { 0x3fdbc397, 0xbe96f802, 0xc0ba541c },  /*  21:  1.7169064e+00 -2.9486090e-01 -5.8227674e+00 */
    { 0x3f3a0338, 0xbfcbc428, 0xbee9b202 },  /*  22:  7.2661161e-01 -1.5919237e+00 -4.5643620e-01 */
    { 0xc193b7ed, 0x4251e110, 0xbeb42df5 },  /*  23: -1.8464808e+01  5.2469788e+01 -3.5191314e-01 */
    { 0x3f14b360, 0x36f0721f, 0x479e51eb },  /*  24:  5.8086205e-01  7.1658428e-06  8.1059836e+04 */
    { 0x3fd03d47, 0x3dd8cfc3, 0x4175e0dd },  /*  25:  1.6268700e+00  1.0586502e-01  1.5367399e+01 */
    { 0x3d24fd30, 0xc18c9390, 0xbb163a83 },  /*  26:  4.0280521e-02 -1.7572052e+01 -2.2923060e-03 */
    { 0xbf42c69e, 0x00000000, 0xff800000 },  /*  27: -7.6084316e-01  0.0000000e+00 -inf */
    { 0x3ff2d878, 0xc343e1a6, 0xbc1eb064 },  /*  28:  1.8972311e+00 -1.9588144e+02 -9.6856094e-03 */
    { 0xc1df7b1f, 0xbfdef74b, 0x41804bae },  /*  29: -2.7935118e+01 -1.7419218e+00  1.6036953e+01 */
    { 0xbfdc4cbd, 0xbbfa3694, 0x4361650e },  /*  30: -1.7210919e+00 -7.6359008e-03  2.2539474e+02 */
    { 0x3dad9dc5, 0xbe02b499, 0xbf2a05ca },  /*  31:  8.4773578e-02 -1.2764205e-01 -6.6415086e-01 */
    { 0x4568b601, 0x407927eb, 0x446f1a72 },  /*  32:  3.7233752e+03  3.8930614e+00  9.5641318e+02 */
    { 0x3db6b844, 0xd00e2234, 0xad248ce3 },  /*  33:  8.9218646e-02 -9.5384248e+09 -9.3536038e-12 */
    { 0xb5fdb9e1, 0xbf12c4ab, 0x365d47cb },  /*  34: -1.8904067e-06 -5.7331342e-01  3.2973355e-06 */
    { 0xbf1ea6eb, 0x3e6b94c3, 0xc02c6733 },  /*  35: -6.1973447e-01  2.3005967e-01 -2.6937988e+00 */
    { 0x3f0892ec, 0x3fda4350, 0x3ea02fea },  /*  36:  5.3349185e-01  1.7051792e+00  3.1286556e-01 */
    { 0xbf0147b4, 0xc2f8ea99, 0x3b84f588 },  /*  37: -5.0500035e-01 -1.2445820e+02  4.0575901e-03 */
    { 0x3e3ba48e, 0xb7052e3e, 0xc6b457f7 },  /*  38:  1.8324491e-01 -7.9381844e-06 -2.3083983e+04 */
    { 0xc2152a09, 0xbd0169d2, 0x449388ff },  /*  39: -3.7291050e+01 -3.1595059e-02  1.1802811e+03 */
    { 0xc0a8217c, 0x3f0e7c2f, 0xc11709df },  /*  40: -5.2540874e+00  5.5658239e-01 -9.4399096e+00 */
    { 0xc1f5999c, 0x379ddd43, 0xc9c7235e },  /*  41: -3.0700005e+01  1.8818891e-05 -1.6313397e+06 */
    { 0xbc8702e5, 0xbfdb490d, 0x3c1d9db6 },  /*  42: -1.6480872e-02 -1.7131668e+00  9.6201211e-03 */
    { 0x3f1701c3, 0xbe54a230, 0xc035cdfc },  /*  43:  5.8987063e-01 -2.0764995e-01 -2.8406973e+00 */
    { 0xc2e39659, 0x80000000, 0x7f800000 },  /*  44: -1.1379365e+02 -0.0000000e+00  inf */
    { 0xc55e9194, 0x3f254bbb, 0xc5ac59af },  /*  45: -3.5610986e+03  6.4568681e-01 -5.5152105e+03 */
    { 0x40150bd1, 0x47cba94a, 0x37bb5971 },  /*  46:  2.3288462e+00  1.0427458e+05  2.2333787e-05 */
    { 0x462dbd20, 0xbf13f49a, 0xc6964e47 },  /*  47:  1.1119281e+04 -5.7795107e-01 -1.9239139e+04 */
    { 0x00000000, 0x765e64ec, 0x00000000 },  /*  48:  0.0000000e+00  1.1276727e+33  0.0000000e+00 */
    { 0xc0e25a70, 0xc19ee2e2, 0x3eb65a19 },  /*  49: -7.0735397e+00 -1.9860783e+01  3.5615614e-01 */
    { 0xba56dcb8, 0x7d5fab76, 0x80007af6 },  /*  50: -8.1963418e-04  1.8581757e+37 -4.4109616e-41 */
    { 0xbd8a7f5e, 0x37a15eb5, 0xc55bb6fe },  /*  51: -6.7625746e-02  1.9236797e-05 -3.5154369e+03 */
    { 0x31f62fcc, 0x3a3b1999, 0x37286c3b },  /*  52:  7.1649762e-09  7.1372982e-04  1.0038779e-05 */
    { 0xbffb4c64, 0x51df5928, 0xad9004a3 },  /*  53: -1.9632688e+00  1.1990919e+11 -1.6372964e-11 */
    { 0xc3a229a5, 0x3f19f953, 0xc406ceb1 },  /*  54: -3.2432535e+02  6.0146064e-01 -5.3922955e+02 */
    { 0xbe0604c9, 0x3f44de35, 0xbe2e45e6 },  /*  55: -1.3087763e-01  7.6901561e-01 -1.7018852e-01 */
    { 0xbd1adee2, 0xc1624339, 0x3b2f39a0 },  /*  56: -3.7810214e-02 -1.4141412e+01  2.6737227e-03 */
    { 0x4966917d, 0x80000000, 0xff800000 },  /*  57:  9.4440781e+05 -0.0000000e+00 -inf */
    { 0x3dde5533, 0xc0c9e9f1, 0xbc8cf1bc },  /*  58:  1.0856094e-01 -6.3098073e+00 -1.7205112e-02 */
    { 0xbe7d3198, 0x3fc46ae1, 0xbe24ffe2 },  /*  59: -2.4725950e-01  1.5345117e+00 -1.6113237e-01 */
    { 0xbbe80025, 0xbd96a645, 0x3dc51ecc },  /*  60: -7.0800954e-03 -7.3559321e-02  9.6250145e-02 */
    { 0xbfa48617, 0x40045e90, 0xbf1f17d0 },  /*  61: -1.2853421e+00  2.0682716e+00 -6.2145710e-01 */
    { 0x3f6dcca2, 0xbdc175ef, 0xc11d5600 },  /*  62:  9.2890370e-01 -9.4463222e-02 -9.8334959e+00 */
    { 0xc0014e9b, 0x3f4954d4, 0xc0246b25 },  /*  63: -2.0204227e+00  7.8645062e-01 -2.5690395e+00 */
    { 0x47afa71d, 0x3aa2f2ca, 0x4c89fac8 },  /*  64:  8.9934227e+04  1.2431976e-03  7.2341056e+07 */
    { 0xc0b04db5, 0xc2b08e6d, 0x3d7fa229 },  /*  65: -5.5094857e+00 -8.8278175e+01  6.2410507e-02 */
    { 0xbbcef5db, 0xbf25bb9b, 0x3c1fd756 },  /*  66: -6.3159293e-03 -6.4739388e-01  9.7559299e-03 */
    { 0x3e1b6d6c, 0xbfe6bb25, 0xbdac730a },  /*  67:  1.5178460e-01 -1.8025862e+00 -8.4203795e-02 */
    { 0x38f2de75, 0x3ff3fbfd, 0x387ed468 },  /*  68:  1.1580895e-04  1.9061276e+00  6.0756139e-05 */
    { 0x3fe24256, 0x3fbcf6a1, 0x3f99436d },  /*  69:  1.7676494e+00  1.4762765e+00  1.1973701e+00 */
    { 0x47bcd551, 0x3f33adb6, 0x4806858c },  /*  70:  9.6682633e+04  7.0186937e-01  1.3775018e+05 */
    { 0x3ff4150c, 0x3f082373, 0x40657da3 },  /*  71:  1.9068923e+00  5.3179091e-01  3.5857933e+00 */
    { 0x3b9ea620, 0xf581a340, 0x859ca50d },  /*  72:  4.8415810e-03 -3.2867060e+32 -1.4730800e-35 */
    { 0x512375ec, 0xbfcb3754, 0xd0cdeb17 },  /*  73:  4.3878629e+10 -1.5876260e+00 -2.7637888e+10 */
    { 0xbda699a8, 0xbef69d20, 0x3e2cf0ec },  /*  74: -8.1347764e-02 -4.8166752e-01  1.6888779e-01 */
    { 0x31832342, 0xbff30e99, 0xb10a1ef4 },  /*  75:  3.8166101e-09 -1.8988830e+00 -2.0099238e-09 */
    { 0x3eee1f89, 0xc15a2300, 0xbd0bba52 },  /*  76:  4.6508434e-01 -1.3633545e+01 -3.4113237e-02 */
    { 0x3be6c67a, 0x3fe49d5d, 0x3b8135af },  /*  77:  7.0427032e-03  1.7860523e+00  3.9431673e-03 */
    { 0x3ff3e56b, 0x42256aa6, 0x3d3cba51 },  /*  78:  1.9054388e+00  4.1354149e+01  4.6076121e-02 */
    { 0x3d39e2a0, 0xbec4541a, 0xbdf261f5 },  /*  79:  4.5382142e-02 -3.8345414e-01 -1.1835090e-01 */
    { 0x3cf2e42d, 0xbffbf2fa, 0xbc76cbeb },  /*  80:  2.9649818e-02 -1.9683526e+00 -1.5063266e-02 */
    { 0xbcafb229, 0xc0d5b88a, 0x3b5273ed },  /*  81: -2.1447258e-02 -6.6787767e+00  3.2112554e-03 */
    { 0x4089cceb, 0x400a5713, 0x3fff0057 },  /*  82:  4.3062644e+00  2.1615646e+00  1.9921979e+00 */
    { 0x3e244215, 0xbdc2ff66, 0xbfd7a4e0 },  /*  83:  1.6040833e-01 -9.5213696e-02 -1.6847191e+00 */
    { 0xbf58168d, 0x3fc70d17, 0xbf0af4a4 },  /*  84: -8.4409410e-01  1.5550870e+00 -5.4279543e-01 */
    { 0x3e57fd89, 0x3f192118, 0x3eb48b98 },  /*  85:  2.1092810e-01  5.9816122e-01  3.5262750e-01 */
    { 0xba635b1c, 0x00000000, 0xff800000 },  /*  86: -8.6729391e-04  0.0000000e+00 -inf */
    { 0xc06631be, 0xc0e2e826, 0x3f01dac0 },  /*  87: -3.5967860e+00 -7.0908384e+00  5.0724411e-01 */
    { 0xc197c144, 0x3da96e3f, 0xc3654b04 },  /*  88: -1.8969368e+01  8.2729809e-02 -2.2929302e+02 */
    { 0xbf2b7ad7, 0xbf520e12, 0x3f50fcc6 },  /*  89: -6.6984314e-01 -8.2052720e-01  8.1635702e-01 */
    { 0x3f25588b, 0x3f3f6f4b, 0x3f5d1cb5 },  /*  90:  6.4588231e-01  7.4779195e-01  8.6371926e-01 */
    { 0x3fdc3ed5, 0x42dd573f, 0x3c7ebbad },  /*  91:  1.7206675e+00  1.1067040e+02  1.5547675e-02 */
    { 0xbff6f794, 0x3fed9c7d, 0xbf850a39 },  /*  92: -1.9294305e+00  1.8563381e+00 -1.0393745e+00 */
    { 0xbfebcfa8, 0x3fe4469c, 0xbf8439aa },  /*  93: -1.8422747e+00  1.7834048e+00 -1.0330098e+00 */
    { 0x3afa3724, 0x47aefb8c, 0x32b7086b },  /*  94:  1.9089920e-03  8.9591094e+04  2.1307832e-08 */
    { 0x3f09c5d5, 0x39f3d091, 0x4490a889 },  /*  95:  5.3817493e-01  4.6503966e-04  1.1572667e+03 */
    { 0xb3d5dbf0, 0xbe5a2885, 0x34faf483 },  /*  96: -9.9585918e-08 -2.1304519e-01  4.6744034e-07 */
    { 0xc0d9ca85, 0x3dfbbae5, 0xc25d7c40 },  /*  97: -6.8059716e+00  1.2291507e-01 -5.5371337e+01 */
    { 0x3dd5a681, 0xc266ff21, 0xbaecc6b7 },  /*  98:  1.0432149e-01 -5.7749149e+01 -1.8064593e-03 */
    { 0x40cc6019, 0x3f0bc1bc, 0x413b2ec5 },  /*  99:  6.3867307e+00  5.4592490e-01  1.1698918e+01 */
    { 0x4061b544, 0x3d002ef4, 0x42e16297 },  /* 100:  3.5266886e+00  3.1294778e-02  1.1269256e+02 */
    { 0x3e347933, 0xbf3f930a, 0xbe712a76 },  /* 101:  1.7624359e-01 -7.4833739e-01 -2.3551354e-01 */
    { 0x2e44580d, 0xbddbac84, 0xafe4cfe8 },  /* 102:  4.4643445e-11 -1.0726264e-01 -4.1620684e-10 */
    { 0xbd61e223, 0xbfb321a0, 0x3d216837 },  /* 103: -5.5147301e-02 -1.3994637e+00  3.9406026e-02 */
    { 0xc102be00, 0xc6a73bb3, 0x39c823c2 },  /* 104: -8.1713867e+00 -2.1405850e+04  3.8173615e-04 */
    { 0x3d28872a, 0x47917cfb, 0x35144533 },  /* 105:  4.1144527e-02  7.4489961e+04  5.5234997e-07 */
    { 0x3fc0a2b7, 0x3ff04067, 0x3f4d4348 },  /* 106:  1.5049657e+00  1.8769654e+00  8.0180789e-01 */
    { 0x35abde61, 0xbab70bbc, 0xba705e3b },  /* 107:  1.2805214e-06 -1.3965289e-03 -9.1693151e-04 */
    { 0x44b47ad4, 0x4193e51a, 0x429c3397 },  /* 108:  1.4438384e+03  1.8486866e+01  7.8100765e+01 */
    { 0xbdf7ff83, 0x40c8d99d, 0xbc9e0c0b },  /* 109: -1.2109282e-01  6.2765641e+00 -1.9292851e-02 */
    { 0xbff36556, 0x4c5aaa17, 0xb30e7a22 },  /* 110: -1.9015300e+00  5.7321564e+07 -3.3173031e-08 */
    { 0xbf3812c2, 0xbfdc33fa, 0x3ed5ff32 },  /* 111: -7.1903622e-01 -1.7203362e+00  4.1796262e-01 */
    { 0x3fa86ec1, 0x3fc40304, 0x3f5bfafd },  /* 112:  1.3158799e+00  1.5313420e+00  8.5929852e-01 */
    { 0xbf3ab6c1, 0xbfc2be01, 0x3ef57241 },  /* 113: -7.2935110e-01 -1.5214235e+00  4.7938731e-01 */
    { 0xf25ff0e7, 0x3fc6c3cd, 0xf210367f },  /* 114: -4.4356090e+30  1.5528504e+00 -2.8564304e+30 */
    { 0xbdd149d9, 0xbf592ef7, 0x3df6b1a8 },  /* 115: -1.0219163e-01 -8.4837288e-01  1.2045604e-01 */
    { 0x3bd12ecb, 0x3f14dc0c, 0x3c33dec5 },  /* 116:  6.3837520e-03  5.8148265e-01  1.0978405e-02 */
    { 0x3fdfd4b9, 0xc0838462, 0xbed9d859 },  /* 117:  1.7486793e+00 -4.1099100e+00 -4.2547873e-01 */
    { 0x3d77f380, 0xf7612486, 0x858cf7a0 },  /* 118:  6.0534954e-02 -4.5664358e+33 -1.3256499e-35 */
    { 0xc0cf5e71, 0x3ff7f306, 0xc0561a1c },  /* 119: -6.4802785e+00  1.9371040e+00 -3.3453436e+00 */
    { 0xc1bd483f, 0xb9a0f430, 0x47968744 },  /* 120: -2.3660276e+01 -3.0699512e-04  7.7070529e+04 */
    { 0x32bdef04, 0x3b9c20ba, 0x369bb724 },  /* 121:  2.2111188e-08  4.7646435e-03  4.6406804e-06 */
    { 0x3fed4343, 0x40adf1ce, 0x3eae9800 },  /* 122:  1.8536152e+00  5.4357672e+00  3.4100341e-01 */
    { 0x3e26bfdf, 0x3e54c50d, 0x3f48a123 },  /* 123:  1.6284131e-01  2.0778294e-01  7.8370874e-01 */
    { 0xbfb2b95a, 0x3f198023, 0xc0150880 },  /* 124: -1.3962815e+00  5.9961146e-01 -2.3286437e+00 */
    { 0x315e4c1d, 0x3c726712, 0x346ac454 },  /* 125:  3.2348517e-09  1.4795082e-02  2.1864372e-07 */
    { 0xc0ac3c1d, 0x3a75d465, 0xc5b35c45 },  /* 126: -5.3823380e+00  9.3776576e-04 -5.7395336e+03 */
    { 0x3f3863de, 0xbf1bc683, 0xbf978336 },  /* 127:  7.2027385e-01 -6.0849780e-01 -1.1836918e+00 */
    { 0xbc753642, 0xbf61186f, 0x3c8b7070 },  /* 128: -1.4966549e-02 -8.7927908e-01  1.7021387e-02 */
    { 0xb875aea6, 0x4b3b8cba, 0xaca7acb3 },  /* 129: -5.8575206e-05  1.2291258e+07 -4.7655989e-12 */
    { 0x3f8d5764, 0xbf2718c1, 0xbfd88aa8 },  /* 130:  1.1042295e+00 -6.5272146e-01 -1.6917315e+00 */
    { 0xc0edcd60, 0xf853c594, 0x080fbbc3 },  /* 131: -7.4313202e+00 -1.7180969e+34  4.3253208e-34 */
    { 0xc3129e13, 0x3f403075, 0xc3434c25 },  /* 132: -1.4661748e+02  7.5073940e-01 -1.9529743e+02 */
    { 0x412b6ca8, 0xb196fa2a, 0xcf1155db },  /* 133:  1.0714027e+01 -4.3940149e-09 -2.4383229e+09 */
    { 0x101b41fc, 0x416f6a86, 0x0e26031d },  /* 134:  3.0619193e-29  1.4963507e+01  2.0462578e-30 */
    { 0x40e4bc19, 0xc2661f07, 0xbdfe7528 },  /* 135:  7.1479611e+00 -5.7530300e+01 -1.2424689e-01 */
    { 0xbf07f708, 0x434a6c68, 0xbb2bf39a },  /* 136: -5.3111315e-01  2.0242346e+02 -2.6237727e-03 */
    { 0xc2d014c4, 0x3b218657, 0xc724e4bc },  /* 137: -1.0404056e+02  2.4646723e-03 -4.2212734e+04 */
    { 0x411b364f, 0xc0d98d30, 0xbfb6a4aa },  /* 138:  9.7007589e+00 -6.7984848e+00 -1.4269001e+00 */
    { 0xbfc8b83b, 0xc009e62e, 0x3f3a4f98 },  /* 139: -1.5681223e+00 -2.1546741e+00  7.2777702e-01 */
    { 0x4831dd91, 0x40ba3f0f, 0x46f47af8 },  /* 140:  1.8213427e+05  5.8201976e+00  3.1293485e+04 */
    { 0x390875e3, 0xc27934d4, 0xb60c2e39 },  /* 141:  1.3013887e-04 -6.2301590e+01 -2.0888531e-06 */
    { 0x3dacc8e2, 0x3fe5332b, 0x3d40fcfe },  /* 142:  8.4367529e-02  1.7906240e+00  4.7116272e-02 */
    { 0x3fee63a8, 0xbf0f2801, 0xc0552687 },  /* 143:  1.8624163e+00 -5.5920416e-01 -3.3304764e+00 */
    { 0x3b4249d0, 0x41cac2b6, 0x38f54d9c },  /* 144:  2.9646046e-03  2.5345074e+01  1.1696966e-04 */
    { 0x4c735795, 0x3dc6506a, 0x4e1d101a },  /* 145:  6.3790676e+07  9.6833065e-02  6.5876956e+08 */
    { 0x3f1aed07, 0xbfdaa013, 0xbeb56936 },  /* 146:  6.0517925e-01 -1.7080101e+00 -3.5431831e-01 */
    { 0xc1120253, 0xca417cee, 0x36412e7e },  /* 147: -9.1255674e+00 -3.1701075e+06  2.8786303e-06 */
    { 0x453b4362, 0xc8b23e6c, 0xbc067a1b },  /* 148:  2.9962114e+03 -3.6504338e+05 -8.2078230e-03 */
    { 0xc08b4b27, 0xbff0f43d, 0x4013fdd3 },  /* 149: -4.3529239e+00 -1.8824536e+00  2.3123672e+00 */
    { 0xc87d4980, 0xc15350b4, 0x46996c72 },  /* 150: -2.5936600e+05 -1.3207203e+01  1.9638223e+04 */
    { 0xbfd41320, 0xc877fa68, 0x36daef64 },  /* 151: -1.6568336e+00 -2.5392962e+05  6.5247749e-06 */
    { 0xbfcd1e9f, 0x41f93307, 0xbd52b7a4 },  /* 152: -1.6024970e+00  3.1149916e+01 -5.1444665e-02 */
    { 0xc7ce0140, 0x3c2d333e, 0xcb183e60 },  /* 153: -1.0547450e+05  1.0571299e-02 -9.9774397e+06 */
    { 0xc3ee5d70, 0x3fed4591, 0xc38096fb },  /* 154: -4.7672998e+02  1.8536855e+00 -2.5717954e+02 */
    { 0xbd84a2a3, 0x434c5737, 0xb9a62ab3 },  /* 155: -6.4763330e-02  2.0434068e+02 -3.1693801e-04 */
    { 0xeb9debda, 0x41909c76, 0xe98bc7fe },  /* 156: -3.8183026e+26  1.8076397e+01 -2.1123140e+25 */
    { 0x3e5e0350, 0xc2b05464, 0xbb21297f },  /* 157:  2.1680951e-01 -8.8164825e+01 -2.4591384e-03 */
    { 0xbfcb5292, 0x3d22b7f3, 0xc21ff0c4 },  /* 158: -1.5884573e+00  3.9726209e-02 -3.9985123e+01 */
    { 0xbd85815a, 0x423ccb2e, 0xbab507ba },  /* 159: -6.5188125e-02  4.7198418e+01 -1.3811506e-03 */
    { 0x3df9b3f8, 0xbffdd7d2, 0xbd7bd325 },  /* 160:  1.2192529e-01 -1.9831488e+00 -6.1480658e-02 */
    { 0xbdad53f4, 0xbe3ca064, 0x3eeb3cb1 },  /* 161: -8.4632784e-02 -1.8420559e-01  4.5944742e-01 */
    { 0xc0d1d474, 0x408ddc50, 0xbfbd540c },  /* 162: -6.5571842e+00  4.4331436e+00 -1.4791274e+00 */
    { 0xc23a7701, 0x4273f22b, 0xbf43adb8 },  /* 163: -4.6616215e+01  6.0986492e+01 -7.6436950e-01 */
    { 0xc12f5489, 0xc00c9808, 0x409f9ff2 },  /* 164: -1.0958138e+01 -2.1967793e+00  4.9882747e+00 */
    { 0xbfefd717, 0xc1343019, 0x3e2a600d },  /* 165: -1.8737515e+00 -1.1261743e+01  1.6638202e-01 */
    { 0xc167e088, 0xc11f1827, 0x3fba8ec2 },  /* 166: -1.4492317e+01 -9.9433966e+00  1.4574816e+00 */
    { 0xc112ed14, 0x3d45fe4a, 0xc33df8b1 },  /* 167: -9.1828804e+00  4.8338212e-02 -1.8997145e+02 */
    { 0xbd65fb86, 0x410a276e, 0xbbd5144d },  /* 168: -5.6148075e-02  8.6346264e+00 -6.5026640e-03 */
    { 0xc1588e8f, 0x3df73003, 0xc2e046fe },  /* 169: -1.3534804e+01  1.2069704e-01 -1.1213866e+02 */
    { 0xbea2cae3, 0xbfe2ae57, 0x3e37d921 },  /* 170: -3.1795415e-01 -1.7709454e+00  1.7953922e-01 */
    { 0x417e2adb, 0x45e87cf6, 0x3b0bef95 },  /* 171:  1.5885463e+01  7.4396201e+03  2.1352519e-03 */
    { 0x4bf048ca, 0x440f8ca2, 0x475641b0 },  /* 172:  3.1494548e+07  5.7419739e+02  5.4849689e+04 */
    { 0x41b28338, 0xbdd14bb4, 0xc35a58fd },  /* 173:  2.2314072e+01 -1.0219517e-01 -2.1834761e+02 */
    { 0xbe68549b, 0xbfd1c183, 0x3e0dc698 },  /* 174: -2.2688524e-01 -1.6387180e+00  1.3845289e-01 */
    { 0xb53d1d2a, 0x462b9cc3, 0xae8d0dc9 },  /* 175: -7.0450426e-07  1.0983190e+04 -6.4143863e-11 */
    { 0x3c7c453a, 0x3feb9b8e, 0x3c090d70 },  /* 176:  1.5397364e-02  1.8406847e+00  8.3650202e-03 */
    { 0x421e498f, 0xbd79ea99, 0xc42223f5 },  /* 177:  3.9571835e+01 -6.1014745e-02 -6.4856182e+02 */
    { 0xbb7530cd, 0xc309bfc6, 0x37e3d660 },  /* 178: -3.7413121e-03 -1.3774911e+02  2.7160335e-05 */
    { 0xbe8c9170, 0xbf0156c3, 0x3f0b1ceb },  /* 179: -2.7454710e-01 -5.0523013e-01  5.4340999e-01 */
    { 0xc0b6d789, 0xbff723e4, 0x403d658d },  /* 180: -5.7138104e+00 -1.9307828e+00  2.9593233e+00 */
    { 0xbdc9bb1a, 0x438a1670, 0xb9bafe72 },  /* 181: -9.8501399e-02  2.7617529e+02 -3.5666260e-04 */
    { 0xc151f1c4, 0xbfb069d6, 0x4118543a },  /* 182: -1.3121525e+01 -1.3782299e+00  9.5205635e+00 */
    { 0x3e1b9d6b, 0xc59c3364, 0xb7ff0a35 },  /* 183:  1.5196769e-01 -4.9984238e+03 -3.0403122e-05 */
    { 0xbfe1689d, 0x3b39c9f2, 0xc41b4bd5 },  /* 184: -1.7610050e+00  2.8349129e-03 -6.2118489e+02 */
    { 0x419920be, 0x411022cf, 0x4007fc3c },  /* 185:  1.9140987e+01  9.0084982e+00  2.1247701e+00 */
    { 0xc21538d9, 0xbc8ce2a0, 0x45079307 },  /* 186: -3.7305515e+01 -1.7197907e-02  2.1691893e+03 */
    { 0x4b1285f8, 0x43540671, 0x4730e9ae },  /* 187:  9.6025520e+06  2.1202516e+02  4.5289681e+04 */
    { 0xbf077b1a, 0xbe2290af, 0x40555952 },  /* 188: -5.2922213e-01 -1.5875505e-01  3.3335767e+00 */
    { 0x42e23f3d, 0x3ca3b862, 0x45b0e281 },  /* 189:  1.1312351e+02  1.9985382e-02  5.6603129e+03 */
    { 0xc1fe37e9, 0x4190524b, 0xbfe177f5 },  /* 190: -3.1777300e+01  1.8040182e+01 -1.7614733e+00 */
    { 0xe047bb14, 0x3e3768db, 0xe18b63f2 },  /* 191: -5.7568476e+19  1.7911093e-01 -3.2141241e+20 */
    { 0x3caebf60, 0x3f40ce22, 0x3ce80610 },  /* 192:  2.1331489e-02  7.5314534e-01  2.8323204e-02 */
    { 0x3fe1871f, 0x00000000, 0x7f800000 },  /* 193:  1.7619361e+00  0.0000000e+00  inf */
    { 0xbf116a63, 0x42ddc7a0, 0xbba7da5a },  /* 194: -5.6802958e-01  1.1088989e+02 -5.1224649e-03 */
    { 0x39fcc4aa, 0xbcc62bb7, 0xbca343d1 },  /* 195:  4.8211712e-04 -2.4190767e-02 -1.9929799e-02 */
    { 0xc1bbc94c, 0xc329533b, 0x3e0df4a2 },  /* 196: -2.3473289e+01 -1.6932512e+02  1.3862851e-01 */
    { 0x3db7c21d, 0xbf264be7, 0xbe0d70c4 },  /* 197:  8.9725710e-02 -6.4959568e-01 -1.3812547e-01 */
    { 0xc11914b2, 0xb7d9e58b, 0x48b3d994 },  /* 198: -9.5675526e+00 -2.5975305e-05  3.6833263e+05 */
    { 0x3e472531, 0x3f13c136, 0x3eac8508 },  /* 199:  1.9447781e-01  5.7716691e-01  3.3695246e-01 */
    { 0xbbf28543, 0x3f29a046, 0xbc37019a },  /* 200: -7.4011399e-03  6.6260183e-01 -1.1169815e-02 */
    { 0x406f327b, 0xc11d1ef9, 0xbec2dd36 },  /* 201:  3.7374561e+00 -9.8200617e+00 -3.8059395e-01 */
    { 0xbdc7105b, 0xbff47b77, 0x3d507121 },  /* 202: -9.7199164e-02 -1.9100178e+00  5.0889139e-02 */
    { 0xbcdba61f, 0xc3d676f3, 0x3883181a },  /* 203: -2.6812611e-02 -4.2892929e+02  6.2510562e-05 */
    { 0xc12034b9, 0xb9db96fb, 0x46bac50d },  /* 204: -1.0012872e+01 -4.1883424e-04  2.3906526e+04 */
    { 0x3f150f26, 0x40cd7bb3, 0x3db9b458 },  /* 205:  5.8226240e-01  6.4213500e+00  9.0676010e-02 */
    { 0xc0bd78e5, 0xbf26563e, 0x4111cd9d },  /* 206: -5.9210076e+00 -6.4975345e-01  9.1126990e+00 */
    { 0x4758724d, 0x40e1927f, 0x45f5a4ac },  /* 207:  5.5410301e+04  7.0491328e+00  7.8605840e+03 */
    { 0xbf372de4, 0xc222a871, 0x3c902615 },  /* 208: -7.1554399e-01 -4.0664494e+01  1.7596284e-02 */
    { 0x38f17486, 0xbce75b62, 0xbb859640 },  /* 209:  1.1513480e-04 -2.8241817e-02 -4.0767489e-03 */
    { 0x3e4dcecd, 0x3fd46c9e, 0x3df806b9 },  /* 210:  2.0098419e-01  1.6595647e+00  1.2110657e-01 */
    { 0x412345bf, 0x3e326b3d, 0x426a447a },  /* 211:  1.0204528e+01  1.7423721e-01  5.8566870e+01 */
    { 0x3e5fdb2f, 0x409abfe9, 0x3d392934 },  /* 212:  2.1860956e-01  4.8359265e+00  4.5205310e-02 */
    { 0xc3b64f38, 0x3fea4c2c, 0xc3473245 },  /* 213: -3.6461890e+02  1.8304496e+00 -1.9919636e+02 */
    { 0xbf2067c6, 0xc0179c56, 0x3e876cd1 },  /* 214: -6.2658346e-01 -2.3689170e+00  2.6450207e-01 */
    { 0x4116c202, 0x4168167c, 0x3f264a60 },  /* 215:  9.4223652e+00  1.4505489e+01  6.4957238e-01 */
    { 0x5b6dfa56, 0xbfe8ec4e, 0xdb02c71e },  /* 216:  6.6984817e+16 -1.8197114e+00 -3.6810681e+16 */
    { 0x3fe98734, 0x46506c3f, 0x390f6b07 },  /* 217:  1.8244386e+00  1.3339062e+04  1.3677413e-04 */
    { 0xbf1bb028, 0xbd3dff93, 0x4151c565 },  /* 218: -6.0815668e-01 -4.6386313e-02  1.3110692e+01 */
    { 0xc10b6f91, 0x407780a2, 0xc010391b },  /* 219: -8.7147379e+00  3.8672261e+00 -2.2534855e+00 */
    { 0xbf17f0e0, 0xb836c107, 0x4654d65b },  /* 220: -5.9351921e-01 -4.3571952e-05  1.3621589e+04 */
    { 0xbe9b1f5f, 0xbe9211b2, 0x3f87eef9 },  /* 221: -3.0297372e-01 -2.8529125e-01  1.0619804e+00 */
    { 0xc22b458c, 0x3e0543c6, 0xc3a48164 },  /* 222: -4.2817917e+01  1.3014135e-01 -3.2901086e+02 */
    { 0x3f3adb0c, 0x3db9eeb7, 0x4100a2b2 },  /* 223:  7.2990489e-01  9.0787344e-02  8.0397207e+00 */
    { 0x3df49ae1, 0xbfeb20eb, 0xbd8528a7 },  /* 224:  1.1943603e-01 -1.8369421e+00 -6.5018943e-02 */
    { 0xbfcdd8b0, 0x3d15111e, 0xc230c155 },  /* 225: -1.6081753e+00  3.6393277e-02 -4.4188801e+01 */
    { 0xbff158ed, 0x49aad4c5, 0xb5b4d615 },  /* 226: -1.8855263e+00  1.3994486e+06 -1.3473351e-06 */
    { 0x409a1cf3, 0xbdf3dcef, 0xc221c882 },  /* 227:  4.8160338e+00 -1.1907374e-01 -4.0445809e+01 */
    { 0x4040dcb7, 0x3ba9dafe, 0x44115664 },  /* 228:  3.0134714e+00  5.1835766e-03  5.8134983e+02 */
    { 0xc0ee9145, 0x3f3f3f23, 0xc11fabe7 },  /* 229: -7.4552331e+00  7.4705714e-01 -9.9794684e+00 */
    { 0x3cf26d8a, 0x3ff2d32e, 0x3c7f94d8 },  /* 230:  2.9593248e-02  1.8970697e+00  1.5599452e-02 */
    { 0xbfc34765, 0x3f270145, 0xc015ab9f },  /* 231: -1.5256163e+00  6.5236312e-01 -2.3385998e+00 */
    { 0x3b81273f, 0x47c09854, 0x332bac21 },  /* 232:  3.9414461e-03  9.8608656e+04  3.9970589e-08 */
    { 0x475000b4, 0xc7a6a283, 0xbf1fc6d2 },  /* 233:  5.3248703e+04 -8.5317023e+04 -6.2412753e-01 */
    { 0x41434d64, 0x00000000, 0x7f800000 },  /* 234:  1.2206394e+01  0.0000000e+00  inf */
    { 0xbfb6c0d4, 0xc9e8e368, 0x3548e3ba },  /* 235: -1.4277596e+00 -1.9078210e+06  7.4837191e-07 */
    { 0xbd5c841b, 0xbe2ba32a, 0x3ea473a2 },  /* 236: -5.3836923e-02 -1.6761461e-01  3.2119469e-01 */
    { 0xbde1048b, 0x3c6e485b, 0xc0f1bfb2 },  /* 237: -1.0987195e-01  1.4543618e-02 -7.5546501e+00 */
    { 0xc2ace9d9, 0x4150ecac, 0xc0d3dff6 },  /* 238: -8.6456734e+01  1.3057781e+01 -6.6210892e+00 */
    { 0xbaa9a446, 0xbf2a6b65, 0x3afed4e3 },  /* 239: -1.2942634e-03 -6.6570121e-01  1.9442107e-03 */
    { 0xdda9c37a, 0xbe32bb00, 0x5ef32811 },  /* 240: -1.5290944e+18 -1.7454147e-01  8.7606365e+18 */
    { 0x42b52da1, 0xbf38af52, 0xc2fb23ab },  /* 241:  9.0589119e+01 -7.2142518e-01 -1.2556967e+02 */
    { 0x3a0c7680, 0x3ee98b6e, 0x3a99f7ea },  /* 242:  5.3582340e-04  4.5614189e-01  1.1746858e-03 */
    { 0xc235a7d1, 0x3e3109b4, 0xc38356ae },  /* 243: -4.5413883e+01  1.7288858e-01 -2.6267718e+02 */
    { 0xc04653be, 0x3def0557, 0xc1d46a60 },  /* 244: -3.0988612e+00  1.1670940e-01 -2.6551941e+01 */
    { 0x3e43369f, 0xbfb1b400, 0xbe0c9cd8 },  /* 245:  1.9063805e-01 -1.3883057e+00 -1.3731706e-01 */
    { 0x0e296e1d, 0x40bfeb30, 0x0ce200a6 },  /* 246:  2.0883876e-30  5.9974594e+00  3.4821204e-31 */
    { 0x3c534b33, 0xbff66c56, 0xbbdb815c },  /* 247:  1.2896347e-02 -1.9251812e+00 -6.6987706e-03 */
    { 0x3e13b2f4, 0xbe5451ea, 0xbf3215b3 },  /* 248:  1.4423734e-01 -2.0734373e-01 -6.9564361e-01 */
    { 0x8258ff1d, 0x40fd5b5c, 0x80db42a5 },  /* 249: -1.5942388e-37  7.9174023e+00 -2.0135882e-38 */
    { 0x41b685d3, 0xbd76758d, 0xc3bd96a7 },  /* 250:  2.2815344e+01 -6.0170699e-02 -3.7917698e+02 */
    { 0xc094e9f4, 0x3dbba42c, 0xc24b29fb },  /* 251: -4.6535587e+00  9.1621727e-02 -5.0790996e+01 */
    { 0x41410a95, 0xc06fd787, 0xc04e0be7 },  /* 252:  1.2065084e+01 -3.7475297e+00 -3.2194764e+00 */
    { 0x3d790150, 0x3c876eb2, 0x406b5708 },  /* 253:  6.0792267e-02  1.6532276e-02  3.6771869e+00 */
    { 0xcd797c6c, 0xbf50a984, 0x4d990aeb },  /* 254: -2.6160506e+08 -8.1508660e-01  3.2095369e+08 */
    { 0xbb1c1570, 0x40b35648, 0xb9dece70 },  /* 255: -2.3816489e-03  5.6042824e+00 -4.2496946e-04 */
    { 0xbde1f0af, 0x3d666164, 0xbffb10e3 },  /* 256: -1.1032235e-01  5.6245223e-02 -1.9614528e+00 */
    { 0x422b6b20, 0xbf1eab1e, 0xc28a491f },  /* 257:  4.2854614e+01 -6.1979854e-01 -6.9142812e+01 */
    { 0x3fdaad19, 0xc25ca5a0, 0xbcfdb6a3 },  /* 258:  1.7084075e+00 -5.5161743e+01 -3.0970876e-02 */
    { 0xb9c7df86, 0xc0a37988, 0x389c7ff2 },  /* 259: -3.8122776e-04 -5.1085854e+00  7.4624917e-05 */
    { 0x3fd94fb3, 0xc0686d51, 0xbeef59ec },  /* 260:  1.6977447e+00 -3.6316721e+00 -4.6748293e-01 */
    { 0xbe31996f, 0x3fe7148c, 0xbdc4c06f },  /* 261: -1.7343687e-01  1.8053145e+00 -9.6070165e-02 */
    { 0x40cbdbd1, 0x3cc3eff6, 0x43852cbd },  /* 262:  6.3705831e+00  2.3918133e-02  2.6634951e+02 */
    { 0xb771a7dd, 0x3479ddef, 0xc2779655 },  /* 263: -1.4403803e-05  2.3270671e-07 -6.1896810e+01 */
    { 0x4197addd, 0x3d76acb4, 0x439d69cd },  /* 264:  1.8959894e+01  6.0223296e-02  3.1482658e+02 */
    { 0x3fd6e283, 0x3c1cb4a3, 0x432f8597 },  /* 265:  1.6787876e+00  9.5645515e-03  1.7552183e+02 */
    { 0xc27b9e0a, 0x3fd714b2, 0xc215be69 },  /* 266: -6.2904335e+01  1.6803191e+00 -3.7435947e+01 */
    { 0x3feea11b, 0x3cb85498, 0x42a5b496 },  /* 267:  1.8642915e+00  2.2501275e-02  8.2852707e+01 */
    { 0xc0e5a3b1, 0x3efa620f, 0xc16aca81 },  /* 268: -7.1762319e+00  4.8902938e-01 -1.4674439e+01 */
    { 0x417be6cd, 0xc542d9bb, 0xbba57a46 },  /* 269:  1.5743848e+01 -3.1176082e+03 -5.0499765e-03 */
    { 0x3f25b609, 0xbdd14405, 0xc0cab7f2 },  /* 270:  6.4730889e-01 -1.0218052e-01 -6.3349540e+00 */
    { 0x3b87a167, 0xeeb09376, 0x8c44a31b },  /* 271:  4.1391137e-03 -2.7323816e+28 -1.5148374e-31 */
    { 0xa7583214, 0x33bddeb8, 0xb311bf4f },  /* 272: -3.0003169e-15  8.8415106e-08 -3.3934438e-08 */
    { 0xbf105719, 0x33f6e0cb, 0xca95ac68 },  /* 273: -5.6382900e-01  1.1496157e-07 -4.9044998e+06 */
    { 0x3db4b701, 0xbddbf1e3, 0xbf5256cf },  /* 274:  8.8239677e-02 -1.0739496e-01 -8.2163707e-01 */
    { 0xbe4966ea, 0xbff114f1, 0x3dd5dd64 },  /* 275: -1.9668165e-01 -1.8834516e+00  1.0442618e-01 */
    { 0x3ea4861d, 0xc138709f, 0xbce45b58 },  /* 276:  3.2133570e-01 -1.1527495e+01 -2.7875587e-02 */
    { 0x43743449, 0x40549cc7, 0x429304f5 },  /* 277:  2.4420424e+02  3.3220689e+00  7.3509684e+01 */
    { 0xc0e5c94b, 0xbd41164d, 0x43185411 },  /* 278: -7.1808219e+00 -4.7140408e-02  1.5232838e+02 */
    { 0x3febeba0, 0xbfcf4806, 0xbf91af66 },  /* 279:  1.8431282e+00 -1.6193855e+00 -1.1381652e+00 */
    { 0x09348ab8, 0x3bd9c1a6, 0x0cd43fe6 },  /* 280:  2.1731937e-33  6.6453991e-03  3.2702230e-31 */
    { 0x3f1e1d46, 0x3ded0e67, 0x40aabfe9 },  /* 281:  6.1763418e-01  1.1575013e-01  5.3359266e+00 */
    { 0x3a3f1b5c, 0xbf0ec86e, 0xbaab521d },  /* 282:  7.2901486e-04 -5.5774581e-01 -1.3070737e-03 */
    { 0xbd8d916b, 0x3fd9ccb5, 0xbd2665e2 },  /* 283: -6.9125019e-02  1.7015597e+00 -4.0624505e-02 */
    { 0xc1e7a37b, 0x3f052d1c, 0xc25ea2aa },  /* 284: -2.8954824e+01  5.2021956e-01 -5.5658853e+01 */
    { 0xc0b9541b, 0x422e48cd, 0xbe081c76 },  /* 285: -5.7915168e+00  4.3571095e+01 -1.3292108e-01 */
    { 0x40c7a3d9, 0x3fddf648, 0x40664141 },  /* 286:  6.2387509e+00  1.7340784e+00  3.5977329e+00 */
    { 0xc09748c8, 0x4c41d410, 0xb3c7cf46 },  /* 287: -4.7276344e+00  5.0810944e+07 -9.3043625e-08 */
    { 0xba3d1232, 0xbf21fa22, 0x3a95691f },  /* 288: -7.2124891e-04 -6.3272297e-01  1.1399126e-03 */
    { 0x3e51d769, 0xc1067fe1, 0xbcc7b37c },  /* 289:  2.0492329e-01 -8.4062204e+00 -2.4377577e-02 */
    { 0xbd8b157e, 0xbe7ea4e0, 0x3e8bd317 },  /* 290: -6.7912087e-02 -2.4867582e-01  2.7309485e-01 */
    { 0x4eb95e4b, 0xbfddbe07, 0xce5601aa },  /* 291:  1.5549823e+09 -1.7323617e+00 -8.9760833e+08 */
    { 0xbfd3cd41, 0xc4daa911, 0x3a77f85b },  /* 292: -1.6547014e+00 -1.7492833e+03  9.4593102e-04 */
    { 0xbadaec8d, 0xbff102c5, 0x3a688a21 },  /* 293: -1.6702578e-03 -1.8828970e+00  8.8706804e-04 */
    { 0xbfe43ade, 0x422a9ae4, 0xbd2b3bfb },  /* 294: -1.7830465e+00  4.2651260e+01 -4.1805247e-02 */
    { 0x38a6735e, 0xbfd6247e, 0xb846fc6a },  /* 295:  7.9369856e-05 -1.6729887e+00 -4.7441957e-05 */
    { 0x3ff49e58, 0xbd4f3dfc, 0xc21715c1 },  /* 296:  1.9110823e+00 -5.0596222e-02 -3.7771244e+01 */
    { 0x413f8fc2, 0xbe225151, 0xc2970fa3 },  /* 297:  1.1972597e+01 -1.5851332e-01 -7.5530542e+01 */
    { 0xbcee99ec, 0x1c5b1cda, 0xe00b627d },  /* 298: -2.9126130e-02  7.2498311e-22 -4.0174908e+19 */
    { 0x41407965, 0xc00453a7, 0xc0ba2e46 },  /* 299:  1.2029637e+01 -2.0676057e+00 -5.8181486e+00 */
    { 0xbfe3c79f, 0x4bd1b31c, 0xb38b093b },  /* 300: -1.7795295e+00  2.7485752e+07 -6.4743706e-08 */
    { 0xbdbfde7b, 0x4072c19e, 0xbcca5629 },  /* 301: -9.3686067e-02  3.7930675e+00 -2.4699288e-02 */
    { 0x3f15df78, 0x3fdba6a6, 0x3eaeacba },  /* 302:  5.8544111e-01  1.7160232e+00  3.4116154e-01 */
    { 0x3ce071a4, 0xc12743a4, 0xbb2bc1d2 },  /* 303:  2.7397938e-02 -1.0454014e+01 -2.6208056e-03 */
    { 0xbc1a3960, 0xc7144ba4, 0x34851e05 },  /* 304: -9.4130933e-03 -3.7963641e+04  2.4795023e-07 */
    { 0x42ffbaf9, 0xbfd09e9b, 0xc29ce7b9 },  /* 305:  1.2786518e+02 -1.6298403e+00 -7.8452585e+01 */
    { 0x3e1f1012, 0x3f5b7b2e, 0x3e39875d },  /* 306:  1.5533474e-01  8.5734832e-01  1.8118043e-01 */
    { 0xbe392cba, 0xbdf5ac3f, 0x3fc0f571 },  /* 307: -1.8083468e-01 -1.1995744e-01  1.5074903e+00 */
    { 0x3ea356bb, 0xbe115eb9, 0xc00fd25c },  /* 308:  3.1902108e-01 -1.4196290e-01 -2.2472144e+00 */
    { 0x3f63d6cf, 0x46982d80, 0x383fa3f2 },  /* 309:  8.8999647e-01  1.9478750e+04  4.5690636e-05 */
    { 0x4da11d11, 0x3b9b086f, 0x51850534 },  /* 310:  3.3787958e+08  4.7312300e-03  7.1414745e+10 */
    { 0xbc6d939a, 0xbf288810, 0x3cb4709b },  /* 311: -1.4500523e-02 -6.5832615e-01  2.2026351e-02 */
    { 0xbfe81def, 0xbe59c1d6, 0x410870da },  /* 312: -1.8134135e+00 -2.1265349e-01  8.5275512e+00 */
    { 0xbf2e6aa9, 0x3c45ae32, 0xc261df78 },  /* 313: -6.8131500e-01  1.2065457e-02 -5.6468229e+01 */
    { 0xc008e61b, 0xc278205b, 0x3d0d3e33 },  /* 314: -2.1390445e+00 -6.2031597e+01  3.4483144e-02 */
    { 0x3c44930b, 0xc221f92c, 0xb99b57f7 },  /* 315:  1.1997948e-02 -4.0493332e+01 -2.9629442e-04 */
    { 0x40c504bf, 0x3bf2aa02, 0x444fd88f },  /* 316:  6.1568294e+00  7.4055204e-03  8.3138375e+02 */
    { 0xbf5cabaf, 0xbfc68528, 0x3f0e4831 },  /* 317: -8.6199468e-01 -1.5509386e+00  5.5578904e-01 */
    { 0xbe7626c8, 0xbfac6d64, 0x3e36ba82 },  /* 318: -2.4038231e-01 -1.3470883e+00  1.7844584e-01 */
    { 0x47505c00, 0xc0aa5fdc, 0xc61c899d },  /* 319:  5.3340000e+04 -5.3242016e+00 -1.0018404e+04 */
    { 0xbf2ef445, 0xbe716e63, 0x403982f3 },  /* 320: -6.8341476e-01 -2.3577265e-01  2.8986176e+00 */
    { 0xbf0ca93c, 0xbfe25d31, 0x3e9f13a0 },  /* 321: -5.4945731e-01 -1.7684690e+00  3.1069661e-01 */
    { 0x3fbf2409, 0xbf1ce65a, 0xc01bef1c },  /* 322:  1.4932872e+00 -6.1288989e-01 -2.4364690e+00 */
    { 0x427923c5, 0xbc834e6e, 0xc572ddc3 },  /* 323:  6.2284931e+01 -1.6028609e-02 -3.8858600e+03 */
    { 0x3e0c37b9, 0xc15325a5, 0xbc2a00e1 },  /* 324:  1.3693132e-01 -1.3196691e+01 -1.0376186e-02 */
    { 0xbfdf0a11, 0xd4c56b89, 0x2a909c50 },  /* 325: -1.7424947e+00 -6.7833016e+12  2.5688003e-13 */
    { 0x41b2b62f, 0x4086281c, 0x40aa82a1 },  /* 326:  2.2338957e+01  4.1923962e+00  5.3284461e+00 */
    { 0xbd830b29, 0x3f216b01, 0xbdcfd3f1 },  /* 327: -6.3986130e-02  6.3053900e-01 -1.0147847e-01 */
    { 0x3f513872, 0x3fd0a4e0, 0x3f005a88 },  /* 328:  8.1726754e-01  1.6300316e+00  5.0138141e-01 */
    { 0x413f4624, 0xbf177b61, 0xc1a19faa },  /* 329:  1.1954624e+01 -5.9172636e-01 -2.0202960e+01 */
    { 0x8102bb1c, 0x3fddf86d, 0x8096c5d9 },  /* 330: -2.4011473e-38  1.7341439e+00 -1.3846298e-38 */
    { 0xc14163b1, 0xbbfe1616, 0x44c2d893 },  /* 331: -1.2086839e+01 -7.7540977e-03  1.5587679e+03 */
    { 0xbbf9f935, 0x3cb9aedc, 0xbeac5182 },  /* 332: -7.6285847e-03  2.2666387e-02 -3.3655936e-01 */
    { 0x4614dd67, 0xbd2277c1, 0xc86a90df },  /* 333:  9.5273506e+03 -3.9664987e-02 -2.4019548e+05 */
    { 0xc0c4d223, 0xc12c1748, 0x3f1264d8 },  /* 334: -6.1506515e+00 -1.0755684e+01  5.7185127e-01 */
    { 0x3ff3121c, 0x40b868df, 0x3ea8b791 },  /* 335:  1.8989902e+00  5.7628016e+00  3.2952551e-01 */
    { 0x40e88a8e, 0x47301a5e, 0x392905a1 },  /* 336:  7.2669134e+00  4.5082367e+04  1.6119192e-04 */
    { 0x3690160e, 0x41a329d6, 0x34621173 },  /* 337:  4.2941019e-06  2.0395428e+01  2.1054238e-07 */
    { 0x408b873a, 0xc0189378, 0xbfea1b92 },  /* 338:  4.3602571e+00 -2.3840008e+00 -1.8289663e+00 */
    { 0xbf564322, 0x437007e1, 0xbb648460 },  /* 339: -8.3696187e-01  2.4003078e+02 -3.4868940e-03 */
    { 0x416c1cd2, 0xbf3ae5a0, 0xc1a1b4cd },  /* 340:  1.4757036e+01 -7.3006630e-01 -2.0213282e+01 */
    { 0x3d575fbb, 0x414aab93, 0x3b8805f5 },  /* 341:  5.2581530e-02  1.2666888e+01  4.1511008e-03 */
    { 0x4175948b, 0xbe6191a4, 0xc28b5b03 },  /* 342:  1.5348765e+01 -2.2028214e-01 -6.9677758e+01 */
    { 0xbe73d66b, 0x3c51b0cf, 0xc194d814 },  /* 343: -2.3812263e-01  1.2798502e-02 -1.8605508e+01 */
    { 0x3fbf207c, 0x00000000, 0x7f800000 },  /* 344:  1.4931788e+00  0.0000000e+00  inf */
    { 0xbe44fe88, 0x46033e81, 0xb7c01ff7 },  /* 345: -1.9237721e-01  8.3996260e+03 -2.2903069e-05 */
    { 0x590df1e6, 0xbffee9c9, 0xd88e8cd2 },  /* 346:  2.4971214e+15 -1.9915096e+00 -1.2538837e+15 */
    { 0xc142a5a0, 0xbf1daf92, 0x419e00bc },  /* 347: -1.2165436e+01 -6.1596024e-01  1.9750359e+01 */
    { 0x41eeb550, 0xc0c2de1e, 0xc09ccc06 },  /* 348:  2.9838531e+01 -6.0896139e+00 -4.8999053e+00 */
    { 0xc1f11c2b, 0x3e18fa4b, 0xc349be0b },  /* 349: -3.0138754e+01  1.4939229e-01 -2.0174236e+02 */
    { 0x3d446c5a, 0xc1c69a5f, 0xbafd30b6 },  /* 350:  4.7954895e-02 -2.4825377e+01 -1.9316885e-03 */
    { 0xc17368dd, 0xbdaa2e47, 0x43371415 },  /* 351: -1.5213101e+01 -8.3096080e-02  1.8307845e+02 */
    { 0xbfdcfe2d, 0x3bc4a817, 0xc38fd70b },  /* 352: -1.7265068e+00  6.0014832e-03 -2.8768002e+02 */
    { 0x3dc3ebf7, 0xbeeaaa25, 0xbe55bc13 },  /* 353:  9.5664911e-02 -4.5832935e-01 -2.0872526e-01 */
    { 0x469b8ba0, 0x3fc93156, 0x4645eaf6 },  /* 354:  1.9909812e+04  1.5718181e+00  1.2666741e+04 */
    { 0x2864ea62, 0xc0669f98, 0xa77e1aae },  /* 355:  1.2707366e-14 -3.6034908e+00 -3.5264045e-15 */
    { 0xc0cc2175, 0xbe1fcca2, 0x42238276 },  /* 356: -6.3790841e+00 -1.5605405e-01  4.0877402e+01 */
    { 0x3e28dc6d, 0x3e823d64, 0x3f25f501 },  /* 357:  1.6490336e-01  2.5437462e-01  6.4826969e-01 */
    { 0xbe0b86e3, 0xbdde137c, 0x3fa0d73b },  /* 358: -1.3625674e-01 -1.0843560e-01  1.2565683e+00 */
    { 0xc117e66b, 0xbf100266, 0x41870375 },  /* 359: -9.4937544e+00 -5.6253660e-01  1.6876688e+01 */
    { 0xbd6d9b5d, 0xc1dc9da3, 0x3b09dbb0 },  /* 360: -5.8009494e-02 -2.7576971e+01  2.1035484e-03 */
    { 0x3f31d40a, 0xbfe9a4c1, 0xbec2d80e },  /* 361:  6.9464171e-01 -1.8253404e+00 -3.8055461e-01 */
    { 0x3eedec45, 0xc51570b3, 0xb94bc9be },  /* 362:  4.6469322e-01 -2.3910437e+03 -1.9434744e-04 */
    { 0xbdcb2314, 0x3e1d28ac, 0xbf25728e },  /* 363: -9.9188000e-02  1.5347546e-01 -6.4627920e-01 */
    { 0xbdea37e4, 0xbdaeea1b, 0x3fab65d2 },  /* 364: -1.1436442e-01 -8.5407458e-02  1.3390448e+00 */
    { 0x383d6628, 0xbf04e12c, 0xb8b671a8 },  /* 365:  4.5156252e-05 -5.1906085e-01 -8.6996066e-05 */
    { 0x80000000, 0xbd6b1d03, 0x00000000 },  /* 366: -0.0000000e+00 -5.7400715e-02  0.0000000e+00 */
    { 0x4258806a, 0xbf56de79, 0xc280f8f9 },  /* 367:  5.4125404e+01 -8.3933216e-01 -6.4486275e+01 */
    { 0x3dd4f194, 0x3fc154bd, 0x3d8cfc2f },  /* 368:  1.0397640e-01  1.5103985e+00  6.8840374e-02 */
    { 0xbf2e6687, 0x132d7155, 0xeb80b4f4 },  /* 369: -6.8125194e-01  2.1891547e-27 -3.1119406e+26 */
    { 0xc25002fa, 0x3e4022bb, 0xc38a9396 },  /* 370: -5.2002907e+01  1.8763249e-01 -2.7715300e+02 */
    { 0xbc25b590, 0x424ec816, 0xb94d26cc },  /* 371: -1.0114089e-02  5.1695396e+01 -1.9564776e-04 */
    { 0x3bc8562a, 0xbfc88afa, 0xbb7fbc95 },  /* 372:  6.1137872e-03 -1.5667412e+00 -3.9022316e-03 */
    { 0xc0ad8c6b, 0x3f1caa99, 0xc10dcb06 },  /* 373: -5.4233909e+00  6.1197811e-01 -8.8620667e+00 */
    { 0xc2f2db8b, 0x4390cdae, 0xbed6acf7 },  /* 374: -1.2142879e+02  2.8960687e+02 -4.1928837e-01 */
    { 0x3edda796, 0x3fd8dd55, 0x3e82d3c6 },  /* 375:  4.3291920e-01  1.6942545e+00  2.5552194e-01 */
    { 0x3d086dc9, 0xbfdcd5ce, 0xbc9e2737 },  /* 376:  3.3307824e-02 -1.7252748e+00 -1.9305808e-02 */
    { 0x3e195fdb, 0xc10eb117, 0xbc899531 },  /* 377:  1.4977972e-01 -8.9182348e+00 -1.6794772e-02 */
    { 0xbfb923a0, 0xc28a7c1e, 0x3cab1f41 },  /* 378: -1.4463997e+00 -6.9242416e+01  2.0888926e-02 */
    { 0xbd2f62b7, 0xc09ecec1, 0x3c0d5ca9 },  /* 379: -4.2818751e-02 -4.9627385e+00  8.6280490e-03 */
    { 0x3f2708ad, 0x41ccd0a0, 0x3cd0c6f2 },  /* 380:  6.5247613e-01  2.5601868e+01  2.5485490e-02 */
    { 0x4193c81a, 0x41bc449f, 0x3f48f2b5 },  /* 381:  1.8472706e+01  2.3533506e+01  7.8495340e-01 */
    { 0x3ff1ecb2, 0x439366c0, 0x3bd214f2 },  /* 382:  1.8900359e+00  2.9480273e+02  6.4111884e-03 */
    { 0x3fe82843, 0x3e21f6c9, 0x41377943 },  /* 383:  1.8137287e+00  1.5816797e-01  1.1467105e+01 */
    { 0x401226e8, 0xbcd611ec, 0xc2aec762 },  /* 384:  2.2836246e+00 -2.6131593e-02 -8.7389417e+01 */
    { 0x420afcf1, 0x3f1a07d2, 0x4266ffcf },  /* 385:  3.4747013e+01  6.0168183e-01  5.7749813e+01 */
    { 0xc4fd0851, 0xbdca62b7, 0x46a0082c },  /* 386: -2.0242599e+03 -9.8821096e-02  2.0484087e+04 */
    { 0x3ceab4af, 0x3ff90917, 0x3c714501 },  /* 387:  2.8650610e-02  1.9455899e+00  1.4725924e-02 */
    { 0xbcafcaae, 0xc0ccea9b, 0x3b5b9d63 },  /* 388: -2.1458950e-02 -6.4036384e+00  3.3510559e-03 */
    { 0x3d5cb7b1, 0x36115de8, 0x46c25941 },  /* 389:  5.3886119e-02  2.1661344e-06  2.4876627e+04 */
    { 0xb8520929, 0xbef6a685, 0x38d9ff56 },  /* 390: -5.0076433e-05 -4.8173919e-01  1.0394926e-04 */
    { 0x3fd71c73, 0xc3591648, 0xbbfdab7f },  /* 391:  1.6805557e+00 -2.1708704e+02 -7.7413913e-03 */
    { 0xbfcdaad3, 0x3fa78488, 0xbf9d2669 },  /* 392: -1.6067756e+00  1.3087320e+00 -1.2277346e+00 */
    { 0x3e49f8eb, 0x3ddead66, 0x3fe83254 },  /* 393:  1.9723861e-01  1.0872917e-01  1.8140358e+00 */
    { 0xb49875cc, 0x3e0a824c, 0xb60ce486 },  /* 394: -2.8397915e-07  1.3526267e-01 -2.0994643e-06 */
    { 0x3f05f0df, 0xbdec39b6, 0xc0912736 },  /* 395:  5.2320665e-01 -1.1534445e-01 -4.5360366e+00 */
    { 0xbf06a8f5, 0x3f0d8ac9, 0xbf738d79 },  /* 396: -5.2601558e-01  5.5289894e-01 -9.5137744e-01 */
    { 0xbfedaca4, 0xc05d6e09, 0x3f0963ee },  /* 397: -1.8568311e+00 -3.4598410e+00  5.3668104e-01 */
    { 0x4456e414, 0xbe80152f, 0xc556c08a },  /* 398:  8.5956372e+02 -2.5016162e-01 -3.4360336e+03 */
    { 0xce457197, 0x3de40e16, 0xcfdda340 },  /* 399: -8.2813894e+08  1.1135499e-01 -7.4369270e+09 */
    { 0x3d949461, 0xbd3fc53f, 0xbfc657de },  /* 400:  7.2548635e-02 -4.6818968e-02 -1.5495565e+00 */
    { 0x3fc03a60, 0xc9e3ee3c, 0xb557e694 },  /* 401:  1.5017815e+00 -1.8672075e+06 -8.0429275e-07 */
    { 0x3f4a299b, 0xc1fbb999, 0xbccd9888 },  /* 402:  7.8969735e-01 -3.1465624e+01 -2.5097146e-02 */
    { 0x41ce0a5e, 0x38dacb51, 0x487113d9 },  /* 403:  2.5755062e+01  1.0432921e-04  2.4686339e+05 */
    { 0x3dd75e80, 0xc1b1138b, 0xbb9bae16 },  /* 404:  1.0516071e-01 -2.2134542e+01 -4.7509775e-03 */
    { 0x3ff786e1, 0xe215e150, 0x9d536451 },  /* 405:  1.9338037e+00 -6.9120009e+20 -2.7977480e-21 */
    { 0x40a7164a, 0xbfec9378, 0xc034ce40 },  /* 406:  5.2214708e+00 -1.8482504e+00 -2.8250885e+00 */
    { 0xbe51b44b, 0x3d947de8, 0xc034c3e1 },  /* 407: -2.0478933e-01  7.2505772e-02 -2.8244555e+00 */
    { 0x41280115, 0xc6d4ac52, 0xb9ca3b1e },  /* 408:  1.0500264e+01 -2.7222160e+04 -3.8572487e-04 */
    { 0x41ebc26f, 0xbfeaf6b9, 0xc1806ef9 },  /* 409:  2.9469938e+01 -1.8356544e+00 -1.6054187e+01 */
    { 0x3ab9a7f7, 0x3fcb2327, 0x3a69f83b },  /* 410:  1.4164437e-03  1.5870103e+00  8.9252336e-04 */
    { 0x3ffcf189, 0xbfbcf4bd, 0xbfab5875 },  /* 411:  1.9761211e+00 -1.4762188e+00 -1.3386370e+00 */
    { 0x4110b682, 0xbe5845e6, 0xc22b4b8a },  /* 412:  9.0445576e+00 -2.1120414e-01 -4.2823770e+01 */
    { 0xbeee823c, 0xc18912fb, 0x3cdeb841 },  /* 413: -4.6583736e-01 -1.7134268e+01  2.7187468e-02 */
    { 0xbf50bdd0, 0x80000000, 0x7f800000 },  /* 414: -8.1539631e-01 -0.0000000e+00  inf */
    { 0xc0af0f55, 0xbf9e741c, 0x408d6a2c },  /* 415: -5.4706216e+00 -1.2379184e+00  4.4192103e+00 */
    { 0x3e2bb3f1, 0x44429911, 0x3961e17f },  /* 416:  1.6767861e-01  7.7839166e+02  2.1541676e-04 */
    { 0x3bd03734, 0xbfceb250, 0xbb80f0d4 },  /* 417:  6.3542370e-03 -1.6148167e+00 -3.9349588e-03 */
    { 0xfee7a8e4, 0x3fb7eef8, 0xfea13680 },  /* 418: -1.5396430e+38  1.4369802e+00 -1.0714434e+38 */
    { 0xbe1c9e81, 0x40800e8a, 0xbd1c8cb9 },  /* 419: -1.5294839e-01  4.0017748e+00 -3.8220140e-02 */
    { 0x406bb020, 0xbc9a801e, 0xc3434310 },  /* 420:  3.6826248e+00 -1.8859919e-02 -1.9526196e+02 */
    { 0xb5dce07d, 0x40c0d8bc, 0xb4929ad6 },  /* 421: -1.6456612e-06  6.0264568e+00 -2.7307276e-07 */
    { 0x3f08b5c4, 0xbfe6e570, 0xbe9792d5 },  /* 422:  5.3402352e-01 -1.8038769e+00 -2.9604211e-01 */
    { 0xc0de1297, 0xc004db00, 0x4055f4df },  /* 423: -6.9397693e+00 -2.0758667e+00  3.3430708e+00 */
    { 0x3e2805e6, 0xc36c552b, 0xba360176 },  /* 424:  1.6408500e-01 -2.3633269e+02 -6.9429668e-04 */
    { 0x3fd72c79, 0xc3442088, 0xbc0c6e3a },  /* 425:  1.6810447e+00 -1.9612708e+02 -8.5712016e-03 */
    { 0x407dfeef, 0xbf13d395, 0xc0dbee0e },  /* 426:  3.9686849e+00 -5.7744724e-01 -6.8728096e+00 */
    { 0x3fb7517a, 0x3f1b58bf, 0x40170c2e },  /* 427:  1.4321740e+00  6.0682291e-01  2.3601185e+00 */
    { 0xbd3a6432, 0xbd9117fe, 0x3f246ead },  /* 428: -4.5505710e-02 -7.0846543e-02  6.4231377e-01 */
    { 0x3f354d7c, 0xc00403d1, 0xbeafc9ef },  /* 429:  7.0821357e-01 -2.0627329e+00 -3.4333750e-01 */
    { 0x3970d531, 0x40bd7e51, 0x3822add1 },  /* 430:  2.2967604e-04  5.9216695e+00  3.8785690e-05 */
    { 0xbef57f06, 0x3d45854a, 0xc11f16fa },  /* 431: -4.7948474e-01  4.8222817e-02 -9.9431091e+00 */
    { 0xbff8cb93, 0xbcca06e6, 0x429da1a2 },  /* 432: -1.9437126e+00 -2.4661493e-02  7.8815692e+01 */
    { 0xc7a96efe, 0x3e047640, 0xc923b9ed },  /* 433: -8.6749984e+04  1.2935734e-01 -6.7062283e+05 */
    { 0xc0ba8945, 0x3fac6623, 0xc08a7f13 },  /* 434: -5.8292565e+00  1.3468670e+00 -4.3280121e+00 */
    { 0xbd691e12, 0x3e2e25ba, 0xbeab57f5 },  /* 435: -5.6913443e-02  1.7006579e-01 -3.3465545e-01 */
    { 0xbcff31e1, 0x3e7b77e2, 0xbe01e598 },  /* 436: -3.1151714e-02  2.4557450e-01 -1.2685239e-01 */
    { 0xc05d54e7, 0x39c6ef65, 0xc60e6916 },  /* 437: -3.4583070e+00  3.7943866e-04 -9.1142717e+03 */
    { 0xbb8f00b1, 0x416bd2e4, 0xb99b3ccc },  /* 438: -4.3640961e-03  1.4738987e+01 -2.9609200e-04 */
    { 0xc457c711, 0x3ffe6a8c, 0xc3d91ef1 },  /* 439: -8.6311041e+02  1.9876266e+00 -4.3424174e+02 */
    { 0x56748b96, 0x4466dcd6, 0x51879613 },  /* 440:  6.7220089e+13  9.2345056e+02  7.2792298e+10 */
    { 0x4315eeea, 0x4141b84e, 0x414622d8 },  /* 441:  1.4993326e+02  1.2107496e+01  1.2383506e+01 */
    { 0x501336da, 0xbf4c5ab5, 0xd0386b4e },  /* 442:  9.8793820e+09 -7.9825908e-01 -1.2376160e+10 */
    { 0xc0ff3c99, 0x444a750a, 0xbc215e72 },  /* 443: -7.9761472e+00  8.0982874e+02 -9.8491778e-03 */
    { 0x3e906b9b, 0xbf4960db, 0xbeb797bf },  /* 444:  2.8207096e-01 -7.8663415e-01 -3.5857961e-01 */
    { 0x383b3c3b, 0x3f046c77, 0x38b4fb07 },  /* 445:  4.4640368e-05  5.1728004e-01  8.6298261e-05 */
    { 0x3e2f7219, 0xad2b54b8, 0xd08312f9 },  /* 446:  1.7133369e-01 -9.7390360e-12 -1.7592469e+10 */
    { 0x39a09c55, 0xbf19999f, 0xba05d797 },  /* 447:  3.0634055e-04 -6.0000032e-01 -5.1056730e-04 */
    { 0xcd2a1677, 0x47f27d73, 0xc4b3905e },  /* 448: -1.7834994e+08  1.2415490e+05 -1.4365115e+03 */
    { 0xbf2c3fe5, 0x406e0a85, 0xbe393eb1 },  /* 449: -6.7284995e-01  3.7193921e+00 -1.8090321e-01 */
    { 0x3e5d8d06, 0x442e4e25, 0x39a2b1cd },  /* 450:  2.1635827e-01  6.9722101e+02  3.1031520e-04 */
    { 0xc181e8a5, 0x41224ca6, 0xbfcce8c2 },  /* 451: -1.6238596e+01  1.0143713e+01 -1.6008533e+00 */
    { 0x41fb0d1c, 0xbf28ce33, 0xc23e5d4b },  /* 452:  3.1381401e+01 -6.5939635e-01 -4.7591105e+01 */
    { 0x42390d0d, 0xbccf614f, 0xc4e46f93 },  /* 453:  4.6262745e+01 -2.5314955e-02 -1.8274867e+03 */
    { 0x40a4ec8b, 0x3c61dcec, 0x43baee0e },  /* 454:  5.1538749e+00  1.3785582e-02  3.7385980e+02 */
    { 0xbe4086cc, 0x3feb9c50, 0xbdd13001 },  /* 455: -1.8801421e-01  1.8407078e+00 -1.0214235e-01 */
    { 0x44c3d6af, 0x3df1d44e, 0x464f5078 },  /* 456:  1.5667089e+03  1.1808072e-01  1.3268117e+04 */
    { 0xbe099511, 0x3fc568e5, 0xbdb26a82 },  /* 457: -1.3435771e-01  1.5422636e+00 -8.7117211e-02 */
    { 0x3ff342c3, 0xbb747a79, 0xc3feb999 },  /* 458:  1.9004749e+00 -3.7304445e-03 -5.0944999e+02 */
    { 0x9c8a360d, 0x36931875, 0xa57089b4 },  /* 459: -9.1460458e-22  4.3837886e-06 -2.0863337e-16 */
    { 0x3fe9f775, 0x3fe24c9a, 0x3f84563c },  /* 460:  1.8278643e+00  1.7679627e+00  1.0338817e+00 */
    { 0x413d94c2, 0x41800d3e, 0x3f3d8127 },  /* 461:  1.1848818e+01  1.6006466e+01  7.4025196e-01 */
    { 0xbdfcb9e9, 0x40a8c89e, 0xbcbfa8c7 },  /* 462: -1.2340147e-01  5.2744894e+00 -2.3395908e-02 */
    { 0xbf2d03ec, 0xc1ece65f, 0x3cbaf6f8 },  /* 463: -6.7584109e-01 -2.9612486e+01  2.2822842e-02 */
    { 0x3f18fc1b, 0x408364ee, 0x3e150865 },  /* 464:  5.9759682e-01  4.1060705e+00  1.4553983e-01 */
    { 0xbfbbce34, 0xbdea27b8, 0x414d5386 },  /* 465: -1.4672303e+00 -1.1433357e-01  1.2832892e+01 */
    { 0x3e69ecf9, 0xbf9f1dc6, 0xbe3c2e0c },  /* 466:  2.2844304e-01 -1.2430961e+00 -1.8376941e-01 */
    { 0x3fee194f, 0x37d28ff3, 0x4790bd47 },  /* 467:  1.8601474e+00  2.5100982e-05  7.4106556e+04 */
    { 0x423c50ac, 0xbe56a5a7, 0xc3609855 },  /* 468:  4.7078781e+01 -2.0961629e-01 -2.2459505e+02 */
    { 0x41bbc8e5, 0xc109a577, 0xc02e9fea },  /* 469:  2.3473093e+01 -8.6028967e+00 -2.7285104e+00 */
    { 0x3f395bb3, 0x3fa90afa, 0x3f0c5aa2 },  /* 470:  7.2405547e-01  1.3206475e+00  5.4825794e-01 */
    { 0x3da134a5, 0x025360e8, 0x7ac33c59 },  /* 471:  7.8713693e-02  1.5529642e-37  5.0686095e+35 */
    { 0x3eae623d, 0x4161b0a2, 0x3cc5cdaa },  /* 472:  3.4059325e-01  1.4105623e+01  2.4145920e-02 */
    { 0xbfb0145d, 0x445ef9f7, 0xbaca2854 },  /* 473: -1.3756214e+00  8.9190570e+02 -1.5423396e-03 */
    { 0xbcc8be2b, 0xc189cbaf, 0x3aba78ef },  /* 474: -2.4504742e-02 -1.7224455e+01  1.4226715e-03 */
    { 0x5c9c034f, 0x3c23cfc9, 0x5ff3cff7 },  /* 475:  3.5130987e+17  9.9982703e-03  3.5137065e+19 */
    { 0x3d4a3763, 0x3d1ddcdf, 0x3fa3f697 },  /* 476:  4.9369227e-02  3.8540717e-02  1.2809629e+00 */
    { 0xba3be01a, 0x3f147103, 0xbaa200ec },  /* 477: -7.1668776e-04  5.7984942e-01 -1.2359894e-03 */
    { 0xc0dfe777, 0xbadcfaf4, 0x4581b191 },  /* 478: -6.9970050e+00 -1.6859458e-03  4.1501957e+03 */
    { 0xc0e11ee9, 0xbdb861d6, 0x429c47f8 },  /* 479: -7.0350232e+00 -9.0030357e-02  7.8140568e+01 */
    { 0xbe15607e, 0x41102d21, 0xbc849dfd },  /* 480: -1.4587590e-01  9.0110178e+00 -1.6188615e-02 */
    { 0xc149364e, 0xbbf2a3fe, 0x44d44a61 },  /* 481: -1.2575758e+01 -7.4048033e-03  1.6983244e+03 */
    { 0x3e09ac8c, 0x3b52d294, 0x42272d25 },  /* 482:  1.3444728e-01  3.2168971e-03  4.1794086e+01 */
    { 0xc0eb2280, 0x3efe8013, 0xc16c8536 },  /* 483: -7.3479614e+00  4.9707088e-01 -1.4782522e+01 */
    { 0xb7e39aa0, 0x2d67d664, 0xc9fb5348 },  /* 484: -2.7132512e-05  1.3178434e-11 -2.0588570e+06 */
    { 0x462c90c8, 0x426e0c9f, 0x4339940b },  /* 485:  1.1044195e+04  5.9512325e+01  1.8557829e+02 */
    { 0x4438cb65, 0xbc0e0345, 0xc7a68f73 },  /* 486:  7.3917804e+02 -8.6677717e-03 -8.5278900e+04 */
    { 0x3fbb6946, 0x3fe760be, 0x3f4f5ac8 },  /* 487:  1.4641502e+00  1.8076398e+00  8.0997894e-01 */
    { 0x426e523f, 0xc12ab0db, 0xc0b2b734 },  /* 488:  5.9580318e+01 -1.0668178e+01 -5.5848638e+00 */
    { 0x40924d1e, 0xc2313a8f, 0xbdd35391 },  /* 489:  4.5719137e+00 -4.4307186e+01 -1.0318673e-01 */
    { 0x4179db18, 0x3e0290ed, 0x42f4f1fa },  /* 490:  1.5615990e+01  1.2750597e-01  1.2247261e+02 */
    { 0xc14faffd, 0x3dcb284c, 0xc302daab },  /* 491: -1.2980466e+01  9.9197954e-02 -1.3085417e+02 */
    { 0x408ee932, 0x3aca7e8a, 0x4534ac38 },  /* 492:  4.4659662e+00  1.5449089e-03  2.8907636e+03 */
    { 0xbfecf38b, 0x498e023d, 0xb5d593a8 },  /* 493: -1.8511823e+00  1.1633356e+06 -1.5912711e-06 */
    { 0xf53afb09, 0xbe34d37b, 0x76845b47 },  /* 494: -2.3702608e+32 -1.7658798e-01  1.3422548e+33 */
    { 0x3f49cafd, 0x3f08eedd, 0x3fbca0ed },  /* 495:  7.8825361e-01  5.3489476e-01  1.4736611e+00 */
    { 0x41346f0e, 0x4862d5fe, 0x384ba1cc },  /* 496:  1.1277113e+01  2.3227997e+05  4.8549658e-05 */
    { 0xc20cb32e, 0x3f337537, 0xc248b608 },  /* 497: -3.5174980e+01  7.0100731e-01 -5.0177765e+01 */
    { 0x3f3b2204, 0x3fd2f173, 0x3ee31a9a },  /* 498:  7.3098779e-01  1.6479934e+00  4.4356231e-01 */
    { 0x3f07a94a, 0xc16e2b78, 0xbd11d13e },  /* 499:  5.2992690e-01 -1.4885612e+01 -3.5599939e-02 */
    { 0xc3926d27, 0xc30365c7, 0x400ea3e5 },  /* 500: -2.9285275e+02 -1.3139757e+02  2.2287532e+00 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u x,y,z;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	x.lo = pgm_read_dword (& t[i].x);
	y.lo = pgm_read_dword (& t[i].y);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = x.fl / y.fl;
	/* Comparison is integer to verify the zero sign.	*/
	if (v.lo != z.lo)
	    x_exit (i+1);
    }
    return 0;
}
