#!/usr/bin/perl -T

# this script checks is the current version of /etc/dhcpd.leases is more
# current than the version stored in DDNSHOME.  If so, ddns.pl is called
# to create the ndupdate data file.  Then nsupdate is called to notify
# BIND of the changes.

use strict;

require '/etc/autodns-dhcp.conf' ;
exit 0 if ($main::DOMAIN eq "__DOMAIN__") ;

my $UPDATE="$main::DDNSHOME/nsupdate.data";
my $DHCPUP="$main::DDNSHOME/dhcpd.conf.new";
my $DHCPD_TEMP="$main::DDNSHOME/dhcpd.leases.last";
my $DDNS="/usr/sbin/ddns.pl";
my $LOCKFILE="$main::DDNSHOME/lock";
my $DHCPDCONF="/etc/dhcpd.conf";
my $DHCPDPID="/var/run/dhcpd.pid";

my($ref,$data);
my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$blocks);

# get timestamp on leases file
($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,
 $blksize,$blocks)=stat($main::DHCPD);
$data=$mtime;

# get timestamp on saved file
($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,
 $blksize,$blocks)=stat($DHCPD_TEMP);
$ref=$mtime;

if ($ref >= $data) {
    exit 0;
}

# are we locked? (JIC :-)
if (-e "$LOCKFILE") {
    exit 0;
}

# ok lock us up
system "/bin/touch", $LOCKFILE;

$ENV{DDNSHOME}=$main::DDNSHOME;
$ENV{DHCPD}=$main::DHCPD;
$ENV{UPDATE}=$UPDATE;
$ENV{DHCPD_TEMP}=$DHCPD_TEMP;
$ENV{DNS_DOMAIN}=$main::DOMAIN;
$ENV{DHCPUP}=$DHCPUP;

# call ddns.pl
system "/usr/bin/perl", $DDNS;

($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,
 $blksize,$blocks)=stat($UPDATE);

# now call nsupdate to notify BIND
if ( $size > 0  && ! system $main::NSUPDATE,$UPDATE) {
   ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,
    $blksize,$blocks)=stat($DHCPUP);
   $data=$size;
   ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,
    $blksize,$blocks)=stat($DHCPDCONF);
   if ($data > $size) {
      system "/bin/cp",$DHCPUP,$DHCPDCONF;
      if (open DPID, "</var/run/dhcpd.pid") {
         my $dhcpid=<DPID>;
         $ENV{'PATH'} = '/sbin:/bin';
         system "/etc/init.d/dhcp stop";
         waitpid $dhcpid,0;
         system "/etc/init.d/dhcp start 2>/dev/null";
      }
   } else {
      print STDERR "$data $size";
      print STDERR "Error creating the new dhcpd configuration.\n";
   }
}

# unlock the process
system "/bin/rm", $LOCKFILE;
