/*
    This file is part of audtty, copyright 2008 Chris Taylor.

    audtty is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    audtty is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with audtty; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    This file contains pieces code from several other GPL'd projects.
*/

#include <stdlib.h>
#include <stdio.h>
#include <audacious/audctrl.h>
#include <string.h>
#include <dirent.h>
#include <curses.h>
#include <time.h>
#include <sys/stat.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include "main.h"
#include "dbus.h"
#include "settings.h"
#include "kbd_constants.h"
#include "curses_printf.h"
#include "browse.h"

win browser;
gchar *files[5000];
controller cont;

void get_contents( void );
void sort_alpha( void );
void swap(gchar** tmp1, gchar** tmp2);
void browser_paint( void );
bool check_dir( void );
void add_file(bool dir);
void remove_win( void );

void file_browser(int height)
{
	cont.height=height;
	gint c,i;

	for(i=0;i<5000;i++)
		files[i]=NULL;

	cont.location=getenv("HOME");
	chdir(cont.location);
	cont.selector=0;
	cont.length = 1;
	cont.first=0;
	cont.pos_height=0;
	clear();
	refresh();

	browser.location = newwin(1, 0, 0, 0);
	browser.title = newwin(1, 0, 1, 0);
	browser.list = newwin(cont.height, 0, 3, 0);

	wcolor_set(browser.location, 1, NULL);
	wcolor_set(browser.title, 1, NULL);
	wcolor_set(browser.list, 1, NULL);

	mvwtitledhline(browser.title, 0, "File Browser");
	wnoutrefresh(browser.title);
	wnoutrefresh(browser.list);

	doupdate();

	get_contents();
	browser_paint();

	while((c=getch()))
	{
		switch(c)
		{
			case 'q':
			case 'k':
			case ESCAPE:
				remove_win();
				return;
			case KEY_DOWN:
				if( cont.selector < (cont.length - 1) )
				{
					++(cont.selector);
					browser_paint();
				}
				break;
			case KEY_UP:
				if ( cont.selector > 0 )
				{
					--(cont.selector);
					browser_paint();
				}
				break;
			case KEY_NPAGE:
				cont.selector+=cont.height;
				cont.pos_height=0;
				if(cont.selector>=cont.length)
					cont.selector = cont.length-1;
				cont.first=cont.selector;
				browser_paint();
				break;
			case KEY_PPAGE:
				cont.selector-=cont.height;
				cont.pos_height=0;
				if(cont.selector<0)
					cont.selector = 0;
				cont.first=cont.selector;
				browser_paint();
				break;
			case KEY_HOME:
				cont.pos_height=0;
				cont.selector=0;
				cont.first=0;
				browser_paint();
				break;
			case KEY_END:
				cont.pos_height=0;
				cont.selector=cont.length-1;
				cont.first=cont.selector;
				browser_paint();
				break;
			case 'a':
			case 'A':
				add_file(TRUE);
				break;
			case ENTER:
				add_file(FALSE);
				get_contents();
				browser_paint();
				break;
			default:
				break;
		}
	}
	return;
}

void get_contents( void )
{
	int count = 0;
	DIR *dir;
	struct dirent* contents;
	int i;

	cont.first=0;
	cont.pos_height=0;

	werase(browser.location);
	doupdate();
	waddstr(browser.location, "Current Directory: ");
	waddstr(browser.location, cont.location);
	wnoutrefresh(browser.location);

	for(i=0;i<cont.length;i++)
		files[i]=NULL;

	dir = opendir(cont.location);
	if(!dir)
	{
		printf("Failed to open directory: %s \n",cont.location);
		exit(1);
	}
	while((contents=readdir(dir))&& count<5000)
	{
			files[count]=contents->d_name;
			count++;
	}
	cont.length=count;
	sort_alpha();
	browser_paint();
	usleep(50000);
	closedir(dir);
}
void sort_alpha( void )
{
	int i, j;
	int min;
	for (i = 0; i < cont.length; i++)
	{
		min = i;
		for (j = i + 1; j < cont.length; j++)
		{
			if(files[min]==NULL||files[j]==NULL)
				continue;
			else if (strcmp(files[min],files[j]) > 0)
			{
				min = j;
			}
		}
		swap(&files[i], &files[min]);
	}
}

void swap(gchar** tmp1, gchar** tmp2)
{
	gchar *tmp;

	tmp = *tmp1;
	*tmp1 = *tmp2;
	*tmp2 = tmp;
	
}

bool check_dir( void )
{
	struct stat statbuf;
	char temp[(strlen(cont.location)+1+strlen(files[cont.selector]))];

	strcpy(temp,cont.location);
	strcat(temp,"/");
	strcat(temp,files[cont.selector]);
	stat(temp,&statbuf);

	if(S_ISDIR(statbuf.st_mode))
		return TRUE;
	else
		return FALSE;
}

void add_file(bool dir)
{
	if(dir)
	{
		if(strcmp(files[cont.selector],".")==0)
			flash();
		else
		{
			char temp[(strlen(cont.location)+1+strlen(files[cont.selector]))];
			gchar *uri = NULL;

			strcpy(temp,cont.location);
			strcat(temp,"/");
			strcat(temp,files[cont.selector]);

			uri = g_filename_to_uri(temp, NULL, NULL);
			audacious_remote_playlist_add_url_string(dbus_proxy,uri);
			get_contents();
		}
	}
	else
	{
		if(strcmp(files[cont.selector],".")==0)
			flash();
		else if(strcmp(files[cont.selector],"..")==0)
		{
			strcat(cont.location,"/");
			strcat(cont.location,files[cont.selector]);

			chdir(cont.location);
			cont.selector=1;
			get_contents();
		}
		else if(check_dir())
		{
			strcat(cont.location,"/");
			strcat(cont.location,files[cont.selector]);

			chdir(cont.location);
			cont.selector=1;
			get_contents();
		}
		else
		{
			char temp[(strlen(cont.location)+1+strlen(files[cont.selector]))];
			gchar *uri = NULL;


			strcpy(temp,cont.location);
			strcat(temp,"/");
			strcat(temp,files[cont.selector]);

			uri = g_filename_to_uri(temp, NULL, NULL);
			audacious_remote_playlist_add_url_string(dbus_proxy,uri);
		}
	}
}

void remove_win( void )
{
	delwin(browser.title);
	delwin(browser.list);
	delwin(browser.location);
	doupdate();
	mainwin_repaint();
}


void browser_paint( void )
{
	int i,last;
	last=cont.first+(cont.height-1);

	if(cont.selector<cont.prev_pos)
	{
		--cont.pos_height;
		if(cont.selector<cont.first)
		{
			cont.pos_height=0;
			--cont.first;
			if(cont.first<0)
				cont.first=0;
		}
	}
	else if(cont.selector>cont.prev_pos)
	{
		++cont.pos_height;
		if(cont.selector>last)
		{
			++cont.first;
			cont.pos_height=cont.height;
		}
	}
	for(i=0;i<cont.height;i++)
	{
		int show_file=cont.first+i;
		if(files[show_file]!=NULL)
		{
			mvwaddstr(browser.list,i,0,files[show_file]);
			wclrtoeol(browser.list);
		
		if(i==0)
			wclrtobot(browser.list);

		if (show_file == cont.selector)
			mvwchgat(browser.list, i, 0, -1, A_REVERSE, 2, NULL);
		else
			mvwchgat(browser.list, i, 0, -1, A_NORMAL, 1, NULL);
		}
	}
	cont.prev_pos=cont.selector;
	wnoutrefresh(browser.list);
	doupdate();
}