#ifndef ATLAS_RBLAS_H
#define ATLAS_RBLAS_H
/*
*  ---------------------------------------------------------------------
*  #define macros definitions
*  ---------------------------------------------------------------------
*/
#define    Mptr(a_,i_,j_,lda_,siz_) \
           ( (void*) ( (char*)(a_) + ( ( (i_)+(j_)*(lda_) )*(siz_) ) ) )
/*
*  ---------------------------------------------------------------------
*  #typedef definitions
*  ---------------------------------------------------------------------
*/
typedef void           (*GEMM_T)
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );
typedef void           (*HEMM_T)
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
typedef void           (*HERK_T)
( const int, const int, void *, void *, const int, void *, void *, const int );
typedef int            (*HER2K_T)
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
typedef void           (*SYMM_T)
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
typedef void           (*SYRK_T)
( const int, const int, void *, void *, const int, void *, void *, const int );
typedef int            (*SYR2K_T)
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *,    const int );
typedef void           (*TRMM_T)
( const int, const int, void *, void *, const int, void *, const int );
typedef void           (*TRSM_T)
( const int, const int, void *, void *, const int, void *, const int );

typedef struct
{ int size; void * one; GEMM_T TgemmNN; GEMM_T Tgemm; SYMM_T Tsymm; }
ATL_symm_type;
typedef struct
{ int size; void * one; GEMM_T TgemmNN; GEMM_T Tgemm; HEMM_T Themm; }
ATL_hemm_type;

typedef struct { int size; GEMM_T Tgemm; SYRK_T  Tsyrk;  } ATL_syrk_type;
typedef struct { int size; GEMM_T Tgemm; HERK_T  Therk;  } ATL_herk_type;

typedef struct
{ int size; void * one; GEMM_T Tgemm; SYR2K_T Tsyr2k; } ATL_syr2k_type;
typedef struct
{ int size; void * one; GEMM_T Tgemm; HER2K_T Ther2k; } ATL_her2k_type;

typedef struct { int size; void * one;           GEMM_T Tgemm; TRMM_T Ttrmm; }
ATL_trmm_type;
typedef struct { int size; void * one, * negone; GEMM_T Tgemm; TRSM_T Ttrsm; }
ATL_trsm_type;
/*
*  ---------------------------------------------------------------------
*  Level 3 recursive BLAS internal function prototypes
*  ---------------------------------------------------------------------
*/
void           ATL_sgemmNN_RB
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );
void           ATL_sgemmNT_RB
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );
void           ATL_sgemmTN_RB
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );

void           ATL_dgemmNN_RB
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );
void           ATL_dgemmNT_RB
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );
void           ATL_dgemmTN_RB
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );

void           ATL_cgemmNN_RB
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );
void           ATL_cgemmNT_RB
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );
void           ATL_cgemmTN_RB
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );
void           ATL_cgemmNC_RB
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );
void           ATL_cgemmCN_RB
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );

void           ATL_zgemmNN_RB
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );
void           ATL_zgemmNT_RB
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );
void           ATL_zgemmTN_RB
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );
void           ATL_zgemmNC_RB
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );
void           ATL_zgemmCN_RB
( const int, const int, const int, void *, void *, const int, void *, const int,
  void *, void *, const int );

void           ATL_slascal
( const int, const int, const float *, float *, const int );
void           ATL_clascal
( const int, const int, const float *, float *, const int );
void           ATL_strscal
( const enum ATLAS_UPLO, const int, const float *, float *, const int );
void           ATL_ctrscal
( const enum ATLAS_UPLO, const int, const float *, float *, const int );
void           ATL_chescal
( const enum ATLAS_UPLO, const int, const float *, float *, const int );

void           ATL_dlascal
( const int, const int, const double *, double *, const int );
void           ATL_zlascal
( const int, const int, const double *, double *, const int );
void           ATL_dtrscal
( const enum ATLAS_UPLO, const int, const double *, double *, const int );
void           ATL_ztrscal
( const enum ATLAS_UPLO, const int, const double *, double *, const int );
void           ATL_zhescal
( const enum ATLAS_UPLO, const int, const double *, double *, const int );
/*
*  ---------------------------------------------------------------------
*  Recursive BLAS function prototypes
*  ---------------------------------------------------------------------
*/
void           ATL_rsymmLL
( ATL_symm_type *, const int, const int, void *, void *, const int, void *,
  const int, void *, void *, const int, const int );
void           ATL_rsymmLU
( ATL_symm_type *, const int, const int, void *, void *, const int, void *,
  const int, void *, void *, const int, const int );
void           ATL_rsymmRL
( ATL_symm_type *, const int, const int, void *, void *, const int, void *,
  const int, void *, void *, const int, const int );
void           ATL_rsymmRU
( ATL_symm_type *, const int, const int, void *, void *, const int, void *,
  const int, void *, void *, const int, const int );

void           ATL_rhemmLL
( ATL_hemm_type *, const int, const int, void *, void *, const int, void *,
  const int, void *, void *, const int, const int );
void           ATL_rhemmLU
( ATL_hemm_type *, const int, const int, void *, void *, const int, void *,
  const int, void *, void *, const int, const int );
void           ATL_rhemmRL
( ATL_hemm_type *, const int, const int, void *, void *, const int, void *,
  const int, void *, void *, const int, const int );
void           ATL_rhemmRU
( ATL_hemm_type *, const int, const int, void *, void *, const int, void *,
  const int, void *, void *, const int, const int );

void           ATL_rsyrkLN
( ATL_syrk_type *, const int, const int, void *, void *, const int, void *,
  void *, const int, const int );
void           ATL_rsyrkUN
( ATL_syrk_type *, const int, const int, void *, void *, const int, void *,
  void *, const int, const int );
void           ATL_rsyrkLT
( ATL_syrk_type *, const int, const int, void *, void *, const int, void *,
  void *, const int, const int );
void           ATL_rsyrkUT
( ATL_syrk_type *, const int, const int, void *, void *, const int, void *,
  void *, const int, const int );

void           ATL_rherkLN
( ATL_herk_type *, const int, const int, void *, void *, const int, void *,
  void *, const int, const int );
void           ATL_rherkUN
( ATL_herk_type *, const int, const int, void *, void *, const int, void *,
  void *, const int, const int );
void           ATL_rherkLC
( ATL_herk_type *, const int, const int, void *, void *, const int, void *,
  void *, const int, const int );
void           ATL_rherkUC
( ATL_herk_type *, const int, const int, void *, void *, const int, void *,
  void *, const int, const int );

void           ATL_rsyr2kLN
( ATL_syr2k_type *, const int, const int, void *, void *, const int, void *,
  const int, void *, void *, const int, const int );
void           ATL_rsyr2kUN
( ATL_syr2k_type *, const int, const int, void *, void *, const int, void *,
  const int, void *, void *, const int, const int );
void           ATL_rsyr2kLT
( ATL_syr2k_type *, const int, const int, void *, void *, const int, void *,
  const int, void *, void *, const int, const int );
void           ATL_rsyr2kUT
( ATL_syr2k_type *, const int, const int, void *, void *, const int, void *,
  const int, void *, void *, const int, const int );

void           ATL_rher2kLN
( ATL_her2k_type *, const int, const int, void *, void *, void *, const int,
  void *, const int, void *, void *, const int, const int );
void           ATL_rher2kUN
( ATL_her2k_type *, const int, const int, void *, void *, void *, const int,
  void *, const int, void *, void *, const int, const int );
void           ATL_rher2kLC
( ATL_her2k_type *, const int, const int, void *, void *, void *, const int,
  void *, const int, void *, void *, const int, const int );
void           ATL_rher2kUC
( ATL_her2k_type *, const int, const int, void *, void *, void *, const int,
  void *, const int, void *, void *, const int, const int );

void           ATL_rtrmmLLN
( ATL_trmm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrmmLUN
( ATL_trmm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrmmLLT
( ATL_trmm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrmmLUT
( ATL_trmm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrmmLLC
( ATL_trmm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrmmLUC
( ATL_trmm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrmmRLN
( ATL_trmm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrmmRUN
( ATL_trmm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrmmRLT
( ATL_trmm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrmmRUT
( ATL_trmm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrmmRLC
( ATL_trmm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrmmRUC
( ATL_trmm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );

void           ATL_rtrsmLLN
( ATL_trsm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrsmLUN
( ATL_trsm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrsmLLT
( ATL_trsm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrsmLUT
( ATL_trsm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrsmLLC
( ATL_trsm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrsmLUC
( ATL_trsm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrsmRLN
( ATL_trsm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrsmRUN
( ATL_trsm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrsmRLT
( ATL_trsm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrsmRUT
( ATL_trsm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrsmRLC
( ATL_trsm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
void           ATL_rtrsmRUC
( ATL_trsm_type *, const int, const int, void *, void *, const int, void *,
  const int,  const int );
/*
*  ---------------------------------------------------------------------
*  Single precision real BLAS kernel function prototypes
*  ---------------------------------------------------------------------
*/
void           ATL_ssymmLL
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_ssymmLU
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_ssymmRL
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_ssymmRU
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );

void           ATL_ssyrkLN
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_ssyrkLT
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_ssyrkUN
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_ssyrkUT
( const int, const int, void *, void *, const int, void *, void *, const int );

int            ATL_ssyr2kLN
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_ssyr2kLT
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_ssyr2kUN
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_ssyr2kUT
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );

void           ATL_strmmLLNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strmmLUNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strmmLLTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strmmLUTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strmmRLNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strmmRUNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strmmRLTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strmmRUTN
( const int, const int, void *, void *, const int, void *, const int );

void           ATL_strmmLLNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strmmLUNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strmmLLTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strmmLUTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strmmRLNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strmmRUNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strmmRLTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strmmRUTU
( const int, const int, void *, void *, const int, void *, const int );

void           ATL_strsmLLNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strsmLUNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strsmLLTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strsmLUTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strsmRLNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strsmRUNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strsmRLTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strsmRUTN
( const int, const int, void *, void *, const int, void *, const int );

void           ATL_strsmLLNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strsmLUNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strsmLLTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strsmLUTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strsmRLNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strsmRUNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strsmRLTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_strsmRUTU
( const int, const int, void *, void *, const int, void *, const int );
/*
*  ---------------------------------------------------------------------
*  Double precision real BLAS kernel function prototypes
*  ---------------------------------------------------------------------
*/
void           ATL_dsymmLL
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_dsymmLU
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_dsymmRL
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_dsymmRU
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );

void           ATL_dsyrkLN
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_dsyrkLT
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_dsyrkUN
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_dsyrkUT
( const int, const int, void *, void *, const int, void *, void *, const int );

int            ATL_dsyr2kLN
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_dsyr2kLT
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_dsyr2kUN
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_dsyr2kUT
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );

void           ATL_dtrmmLLNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrmmLUNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrmmLLTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrmmLUTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrmmRLNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrmmRUNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrmmRLTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrmmRUTN
( const int, const int, void *, void *, const int, void *, const int );

void           ATL_dtrmmLLNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrmmLUNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrmmLLTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrmmLUTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrmmRLNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrmmRUNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrmmRLTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrmmRUTU
( const int, const int, void *, void *, const int, void *, const int );

void           ATL_dtrsmLLNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrsmLUNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrsmLLTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrsmLUTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrsmRLNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrsmRUNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrsmRLTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrsmRUTN
( const int, const int, void *, void *, const int, void *, const int );

void           ATL_dtrsmLLNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrsmLUNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrsmLLTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrsmLUTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrsmRLNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrsmRUNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrsmRLTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_dtrsmRUTU
( const int, const int, void *, void *, const int, void *, const int );
/*
*  ---------------------------------------------------------------------
*  Single precision complex BLAS kernel function prototypes
*  ---------------------------------------------------------------------
*/
void           ATL_csymmLL
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_csymmLU
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_csymmRL
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_csymmRU
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_chemmLL
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_chemmLU
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_chemmRL
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_chemmRU
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );

void           ATL_csyrkLN
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_csyrkLT
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_csyrkUN
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_csyrkUT
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_cherkLN
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_cherkLC
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_cherkUN
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_cherkUC
( const int, const int, void *, void *, const int, void *, void *, const int );

int            ATL_csyr2kLN
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_csyr2kLT
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_csyr2kUN
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_csyr2kUT
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_cher2kLN
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_cher2kLC
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_cher2kUN
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_cher2kUC
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );

void           ATL_ctrmmLLNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmLUNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmLLTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmLUTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmLLCN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmLUCN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmRLNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmRUNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmRLTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmRUTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmRLCN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmRUCN
( const int, const int, void *, void *, const int, void *, const int );

void           ATL_ctrmmLLNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmLUNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmLLTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmLUTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmLLCU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmLUCU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmRLNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmRUNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmRLTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmRUTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmRLCU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrmmRUCU
( const int, const int, void *, void *, const int, void *, const int );

void           ATL_ctrsmLLNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmLUNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmLLTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmLUTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmLLCN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmLUCN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmRLNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmRUNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmRLTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmRUTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmRLCN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmRUCN
( const int, const int, void *, void *, const int, void *, const int );

void           ATL_ctrsmLLNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmLUNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmLLTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmLUTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmLLCU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmLUCU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmRLNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmRUNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmRLTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmRUTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmRLCU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ctrsmRUCU
( const int, const int, void *, void *, const int, void *, const int );
/*
*  ---------------------------------------------------------------------
*  Double precision complex BLAS kernel function prototypes
*  ---------------------------------------------------------------------
*/
void           ATL_zsymmLL
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_zsymmLU
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_zsymmRL
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_zsymmRU
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_zhemmLL
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_zhemmLU
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_zhemmRL
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
void           ATL_zhemmRU
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );

void           ATL_zsyrkLN
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_zsyrkLT
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_zsyrkUN
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_zsyrkUT
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_zherkLN
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_zherkLC
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_zherkUN
( const int, const int, void *, void *, const int, void *, void *, const int );
void           ATL_zherkUC
( const int, const int, void *, void *, const int, void *, void *, const int );

int            ATL_zsyr2kLN
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_zsyr2kLT
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_zsyr2kUN
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_zsyr2kUT
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_zher2kLN
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_zher2kLC
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_zher2kUN
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );
int            ATL_zher2kUC
( const int, const int, void *, void *, const int, void *, const int, void *,
  void *, const int );

void           ATL_ztrmmLLNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmLUNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmLLTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmLUTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmLLCN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmLUCN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmRLNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmRUNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmRLTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmRUTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmRLCN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmRUCN
( const int, const int, void *, void *, const int, void *, const int );

void           ATL_ztrmmLLNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmLUNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmLLTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmLUTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmLLCU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmLUCU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmRLNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmRUNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmRLTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmRUTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmRLCU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrmmRUCU
( const int, const int, void *, void *, const int, void *, const int );

void           ATL_ztrsmLLNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmLUNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmLLTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmLUTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmLLCN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmLUCN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmRLNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmRUNN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmRLTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmRUTN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmRLCN
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmRUCN
( const int, const int, void *, void *, const int, void *, const int );

void           ATL_ztrsmLLNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmLUNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmLLTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmLUTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmLLCU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmLUCU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmRLNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmRUNU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmRLTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmRUTU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmRLCU
( const int, const int, void *, void *, const int, void *, const int );
void           ATL_ztrsmRUCU
( const int, const int, void *, void *, const int, void *, const int );
#endif
