#include <stdio.h>
#include <ctype.h>
#include <assert.h>

char *NegateFloats(char *ln)
{
   static char ol[512];
   char num[128];
   int i=0, j=0, k, h, ndot;

   do
   {
      if ( (ln[i] == '.') || isdigit(ln[i]) )
      {
         if (i==0 || isspace(ln[i-1]) || isdigit(ln[i]))
         {
            for (ndot=k=0; isdigit(ln[i]) || ln[i] == '.'; k++)
            {
               if (ln[i] == '.') ndot++;
               num[k] = ln[i++];
            }
            if (ndot == 1 && k > 1 && isspace(ln[i]))
            {
               if (j > 1 && ol[j-1] == ' ' && ol[j-2] == ' ') ol[j-1] = '-';
               else if (j == 0 || ol[j-1] != '-') ol[j++] = '-';
            }
            for (h=0; h < k; h++) ol[j++] = num[h];
         }
         else ol[j++] = ln[i++];
      }
      else ol[j++] = ln[i++];
   }
   while(ln[i]);
   ol[j] = '\0';
   return(ol);
}

main(int nargs, char **args)
{
   char tnam[256], ln[512], *lp;
   FILE *fpin, *fpout;
   int i;

   assert(tmpnam(tnam));
   for(i=1; i < nargs; i++)
   {
      fpin = fopen(args[i], "r");
      if (fpin == NULL)
      {
         fprintf(stderr, "FILE %s NOT FOUND, SKIPPING!!\n", args[i]);
         continue;
      }
      fpout = fopen(tnam, "w");
      assert(fpin);
      assert(fpout);
      while (fgets(ln, 512, fpin))
      {
         lp = NegateFloats(ln);
         fputs(lp, fpout);
      }
      fclose(fpin);
      fclose(fpout);
      remove(args[i]);
      sprintf(ln, "cp %s %s\n", tnam, args[i]);
      assert(system(ln) == 0);
      remove(tnam);
   }
   exit(0);
}
