#ifndef __IconCache_H_
#define __IconCache_H_

#include <stdio.h>

class Chain {
  Chain *next;
public:
  Chain() : next(0) {}
  void append(Chain *a) {next = a;}
  Chain *select() const {return next;}
};

class Icon;

class IconCache {
  Chain *first;
  unsigned min, max, fill;
  unsigned hit, miss, clean;
public:
  IconCache(unsigned mi, unsigned ma) :
     min(mi), max(ma), fill(0), hit(0), miss(0), clean(0) {};
  ~IconCache() {
    printf("cache statistic: %d hits %d misses %d cleanups\n", hit, miss, clean);
  }
  Icon *Find(char name);
  void Insert(Chain*);
 protected:
  void CleanUp();
};

#endif // __IconCache_H_
