// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __DString_h__
#define __DString_h__

#include "StrHashTable.h"
#include <assert.h>

namespace Puma {


extern StrHashTable ___str_dict;

class DString {
  StrHashKey *m_Key;

public:
  DString () {
    m_Key = ___str_dict.empty ();
    assert (m_Key);
  }
  DString (const char *s) {
    if(s == 0) {
      m_Key = ___str_dict.empty ();
    } else {
      m_Key = ___str_dict.insert (s);
    }
    assert (m_Key);
  }
  DString (const DString &s) : m_Key (s.m_Key) {
    assert (s.m_Key);
  }
  
  DString &operator = (const DString &s) {
    assert (s.m_Key);
    m_Key = s.m_Key;
    return *this;
  }
  
  DString &operator = (const char *s) {
    if(s == 0) {
      m_Key = ___str_dict.empty ();
    } else {
      m_Key = ___str_dict.insert (s);
    }
    assert (m_Key);
    return *this;
  }

  bool operator == (const DString &s) const { 
    assert (m_Key && s.m_Key);
    return m_Key == s.m_Key; 
  }
  bool operator != (const DString &s) const { 
    assert (m_Key && s.m_Key);
    return m_Key != s.m_Key; 
  }

  const char *c_str() const { 
    assert (m_Key);
    return m_Key->c_str (); 
  }
  unsigned int length () const { 
    assert (m_Key);
    return m_Key->length (); 
  }
  bool empty () const {
    assert (m_Key);
    return m_Key->length () == 0;
  }
  unsigned int magic () const { 
    assert (m_Key);
    return m_Key->getMagic (); 
  }

  operator const char *() const {
    assert (m_Key);
    return c_str ();
  }
};


} // namespace Puma

#endif /* __DString_h__ */
