// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/CScanBuffer.h"

namespace Puma {

void CScanBuffer::check () {
  while (next_buffer->state () == ScanBuffer::STATE_OK) {
    bool restore_state = true;
    int curr_len = next_buffer->len ();
    char lookahead;

    lookahead = next_buffer->next ();
    if (lookahead == '\\' && next_buffer->state () == ScanBuffer::STATE_OK) {
      lookahead = next_buffer->next ();
      if (lookahead == '\x0d') // DOS!
        lookahead = next_buffer->next ();
      if (lookahead == '\n') {
        restore_state = false;
      }
    }

    if (restore_state) {
      next_buffer->more (curr_len);
      break;
    }
  }
}

} // namespace Puma
