/* Driver template for the LEMON parser generator.
** Copyright 1991-1995 by D. Richard Hipp.
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
** 
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with this library; if not, write to the
** Free Software Foundation, Inc., 59 Temple Place - Suite 330,
** Boston, MA  02111-1307, USA.
**
** Modified 1997 to make it suitable for use with makeheaders.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 39 "manip/CMatchParser.lem"

#include "Puma/CTreeMatcher.h"
#include "Puma/CMatchParser.h"
#include "Puma/CWildcardTokens.h"
#include "Puma/CTokens.h"
#include "Puma/CTree.h"
#include <stdlib.h>

using namespace Puma;

void *CMatchParserAlloc (void *(*mallocProc)(...));
void CMatchParser       (void *pParser, int tokenID, CTree *token, 
                           CTreeMatcher::match_state *mstate);
void CMatchParserFree   (void *pParser, void (*freeProc)(...));
void CMatchParserTrace  (FILE *TraceFILE, char *zTracePrompt);

namespace Puma {


// Traverse the match-condition tree.
void CTreeMatcher::travConditionTree (CTree *node, void *pParser, 
                                      match_state *mstate) const {
  if (! node || ! pParser || ! mstate) return;

  int id;
  CTree *son;
  const char *type;
  bool element_node = false;

  for (int i = 0; i < node->Sons () && mstate->value != -1; i++) {
    son = node->Son (i);
    if (! son) 
      continue;
    type = son->NodeName ();
    id = MATCHTREE;

    // Visit the current son.
    if (type == CT_AnyCondition::NodeId ()) {
      if (element_node)
        id = M_ELEMENT_NO;
      else {
        travConditionTree (son, pParser, mstate);
        continue;
      }
    } else if (type == CT_Token::NodeId ()) {
      if (! son->token ()) 
        continue;

      if (son->token ()->is_wildcard ()) {
        switch (son->token ()->type ()) {
          case TOK_WC_EXACT   : id = M_EXACT;      break;
          case TOK_WC_FIRST   : id = M_FIRST;      break;
          case TOK_WC_LAST    : id = M_LAST;       break;
          case TOK_WC_PRUNE   : id = M_PRUNE;      break;
          case TOK_WC_LEAF    : id = M_LEAF;       break;
          case TOK_WC_COLLECT : id = M_COLLECT;    break;
          case TOK_WC_NODENAME: id = M_NODENAME;   break;
          case TOK_WC_NOT     : id = M_NOT;        break;
          case TOK_WC_AND     : id = M_AND;        break;
          case TOK_WC_XOR     : id = M_XOR;        break;
          case TOK_WC_OR      : id = M_OR;         break;
          case TOK_WC_SEQ     : id = M_SEQ;        break;
          case TOK_WC_ELEMENT : id = M_ELEMENT;
            element_node = true;
            break;
          case TOK_WC_ELIF    : id = M_ELIF;       break;
          case TOK_WC_ENDIF   : id = M_ENDIF;      break;
          case TOK_WC_IF      : id = M_IF; 
            mstate->depth++;
            mstate->selected[mstate->depth] = 0; 
            break;
          default             : id = 0;            break;
        }
      } else if (son->token ()->is_core ()) {
        switch (son->token ()->type ()) {
          case TOK_OPEN_ROUND : id = M_OPEN_ROUND;  break;
          case TOK_CLOSE_ROUND: id = M_CLOSE_ROUND; break;
          default             : id = MATCHTREE;     break;
        }
      } else 
        id = son->token ()->type ();
    } 
        
    // Parse the current node.
    CMatchParser (pParser, id, son, mstate);
  }
}

// Evaluate the given match-condition.
bool CTreeMatcher::evalMatchCondition (CTree *tree, CTree *condition,
                                       CMatch *matchObj, int mode) const {
  if (! tree || ! condition || ! matchObj) 
    return false;

  Array<int> selected; 
  selected[0] = 0;
  match_state mstate = {0, tree, matchObj, mode, 0, selected,
                        (CTreeMatcher*)this};

  // Generate the Lemon parser.
  void *pParser = CMatchParserAlloc ((void* (*)(...))malloc);
  //CMatchParserTrace(stdout, "TRACE: ");

  // Parse the match-condition tree.
  travConditionTree (condition, pParser, &mstate);

  // Finish and then free the parser.
  CMatchParser (pParser, 0, (CTree*)0, &mstate);
  CMatchParserFree (pParser, (void (*)(...))::free);

  return (mstate.value <= 0) ? false : true;
}


} // namespace Puma

#line 142 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    CMatchParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is CMatchParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    CMatchParserARGDECL       is a declaration of a 3rd argument to the
**                       parser, or null if there is no extra argument.
**    CMatchParserKRARGDECL     A version of CMatchParserARGDECL for K&R C.
**    CMatchParserANSIARGDECL   A version of CMatchParserARGDECL for ANSI C.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
/*  */
#define YYCODETYPE unsigned char
#define YYNOCODE 29
#define YYACTIONTYPE unsigned char
#define CMatchParserTOKENTYPE CTree *
typedef union {
  CMatchParserTOKENTYPE yy0;
  int yy4;
  int yy57;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define CMatchParserARGDECL ,mstate
#define CMatchParserXARGDECL CTreeMatcher::match_state *mstate;
#define CMatchParserANSIARGDECL ,CTreeMatcher::match_state *mstate
#define YYNSTATE 42
#define YYNRULE 23
#define YYERRORSYMBOL 23
#define YYERRSYMDT yy57
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)
/* Next is the action table.  Each entry in this table contains
**
**  +  An integer which is the number representing the look-ahead
**     token
**
**  +  An integer indicating what action to take.  Number (N) between
**     0 and YYNSTATE-1 mean shift the look-ahead and go to state N.
**     Numbers between YYNSTATE and YYNSTATE+YYNRULE-1 mean reduce by
**     rule N-YYNSTATE.  Number YYNSTATE+YYNRULE means that a syntax
**     error has occurred.  Number YYNSTATE+YYNRULE+1 means the parser
**     accepts its input.
**
**  +  A pointer to the next entry with the same hash value.
**
** The action table is really a series of hash tables.  Each hash
** table contains a number of entries which is a power of two.  The
** "state" table (which follows) contains information about the starting
** point and size of each hash table.
*/
struct yyActionEntry {
  YYCODETYPE   lookahead;   /* The value of the look-ahead token */
  YYACTIONTYPE action;      /* Action to take for this look-ahead */
  struct yyActionEntry *next; /* Next look-ahead with the same hash, or NULL */
};
static struct yyActionEntry yyActionTable[] = {
/* State 0 */
  {  16,   3, 0                    }, /*           M_OPEN_ROUND shift  3 */
  {   1,  59, 0                    }, /*              MATCHTREE reduce 17 */
  {  18,  40, 0                    }, /*                M_PRUNE shift  40 */
  {   9,  36, 0                    }, /*                M_EXACT shift  36 */
  {   4,  14, 0                    }, /*              M_COLLECT shift  14 */
  {   5,  27, 0                    }, /*              M_ELEMENT shift  27 */
  {  22,   1, 0                    }, /*            conditional shift  1 */
  {  11,  16, 0                    }, /*                   M_IF shift  16 */
  {  24,  66, 0                    }, /*        match_condition accept */
  {  25,  25, &yyActionTable[   3] }, /*             match_mode shift  25 */
  {  10,  37, 0                    }, /*                M_FIRST shift  37 */
  {  27,  24, &yyActionTable[   7] }, /*             tree_match shift  24 */
  {  12,  38, 0                    }, /*                 M_LAST shift  38 */
  {  13,  39, 0                    }, /*                 M_LEAF shift  39 */
  {  14,  22, 0                    }, /*             M_NODENAME shift  22 */
  {  15,  12, 0                    }, /*                  M_NOT shift  12 */
/* State 1 */
  {   0,  42, 0                    }, /*                      $ reduce 0 */
  {  17,   6, 0                    }, /*                   M_OR shift  6 */
  {   2,  10, 0                    }, /*                  M_AND shift  10 */
  {  19,   2, 0                    }, /*                  M_SEQ shift  2 */
  {YYNOCODE,0,0}, /* Unused */
  {  21,   8, 0                    }, /*                  M_XOR shift  8 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 2 */
  {  16,   3, 0                    }, /*           M_OPEN_ROUND shift  3 */
  {   1,  59, 0                    }, /*              MATCHTREE reduce 17 */
  {  18,  40, 0                    }, /*                M_PRUNE shift  40 */
  {   9,  36, 0                    }, /*                M_EXACT shift  36 */
  {   4,  14, 0                    }, /*              M_COLLECT shift  14 */
  {   5,  27, 0                    }, /*              M_ELEMENT shift  27 */
  {  22,  41, 0                    }, /*            conditional shift  41 */
  {  11,  16, 0                    }, /*                   M_IF shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {  25,  25, &yyActionTable[  27] }, /*             match_mode shift  25 */
  {  10,  37, 0                    }, /*                M_FIRST shift  37 */
  {  27,  24, &yyActionTable[  31] }, /*             tree_match shift  24 */
  {  12,  38, 0                    }, /*                 M_LAST shift  38 */
  {  13,  39, 0                    }, /*                 M_LEAF shift  39 */
  {  14,  22, 0                    }, /*             M_NODENAME shift  22 */
  {  15,  12, 0                    }, /*                  M_NOT shift  12 */
/* State 3 */
  {  16,   3, 0                    }, /*           M_OPEN_ROUND shift  3 */
  {   1,  59, 0                    }, /*              MATCHTREE reduce 17 */
  {  18,  40, 0                    }, /*                M_PRUNE shift  40 */
  {   9,  36, 0                    }, /*                M_EXACT shift  36 */
  {   4,  14, 0                    }, /*              M_COLLECT shift  14 */
  {   5,  27, 0                    }, /*              M_ELEMENT shift  27 */
  {  22,   4, 0                    }, /*            conditional shift  4 */
  {  11,  16, 0                    }, /*                   M_IF shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {  25,  25, &yyActionTable[  43] }, /*             match_mode shift  25 */
  {  10,  37, 0                    }, /*                M_FIRST shift  37 */
  {  27,  24, &yyActionTable[  47] }, /*             tree_match shift  24 */
  {  12,  38, 0                    }, /*                 M_LAST shift  38 */
  {  13,  39, 0                    }, /*                 M_LEAF shift  39 */
  {  14,  22, 0                    }, /*             M_NODENAME shift  22 */
  {  15,  12, 0                    }, /*                  M_NOT shift  12 */
/* State 4 */
  {   3,   5, 0                    }, /*          M_CLOSE_ROUND shift  5 */
  {  17,   6, 0                    }, /*                   M_OR shift  6 */
  {   2,  10, 0                    }, /*                  M_AND shift  10 */
  {  19,   2, &yyActionTable[  56] }, /*                  M_SEQ shift  2 */
  {YYNOCODE,0,0}, /* Unused */
  {  21,   8, 0                    }, /*                  M_XOR shift  8 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 5 */
  {YYNOCODE,0,0}, /* Unused */
/* State 6 */
  {  16,   3, 0                    }, /*           M_OPEN_ROUND shift  3 */
  {   1,  59, 0                    }, /*              MATCHTREE reduce 17 */
  {  18,  40, 0                    }, /*                M_PRUNE shift  40 */
  {   9,  36, 0                    }, /*                M_EXACT shift  36 */
  {   4,  14, 0                    }, /*              M_COLLECT shift  14 */
  {   5,  27, 0                    }, /*              M_ELEMENT shift  27 */
  {  22,   7, 0                    }, /*            conditional shift  7 */
  {  11,  16, 0                    }, /*                   M_IF shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {  25,  25, &yyActionTable[  68] }, /*             match_mode shift  25 */
  {  10,  37, 0                    }, /*                M_FIRST shift  37 */
  {  27,  24, &yyActionTable[  72] }, /*             tree_match shift  24 */
  {  12,  38, 0                    }, /*                 M_LAST shift  38 */
  {  13,  39, 0                    }, /*                 M_LEAF shift  39 */
  {  14,  22, 0                    }, /*             M_NODENAME shift  22 */
  {  15,  12, 0                    }, /*                  M_NOT shift  12 */
/* State 7 */
  {YYNOCODE,0,0}, /* Unused */
  {  21,   8, 0                    }, /*                  M_XOR shift  8 */
  {   2,  10, 0                    }, /*                  M_AND shift  10 */
  {  19,   2, 0                    }, /*                  M_SEQ shift  2 */
/* State 8 */
  {  16,   3, 0                    }, /*           M_OPEN_ROUND shift  3 */
  {   1,  59, 0                    }, /*              MATCHTREE reduce 17 */
  {  18,  40, 0                    }, /*                M_PRUNE shift  40 */
  {   9,  36, 0                    }, /*                M_EXACT shift  36 */
  {   4,  14, 0                    }, /*              M_COLLECT shift  14 */
  {   5,  27, 0                    }, /*              M_ELEMENT shift  27 */
  {  22,   9, 0                    }, /*            conditional shift  9 */
  {  11,  16, 0                    }, /*                   M_IF shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {  25,  25, &yyActionTable[  88] }, /*             match_mode shift  25 */
  {  10,  37, 0                    }, /*                M_FIRST shift  37 */
  {  27,  24, &yyActionTable[  92] }, /*             tree_match shift  24 */
  {  12,  38, 0                    }, /*                 M_LAST shift  38 */
  {  13,  39, 0                    }, /*                 M_LEAF shift  39 */
  {  14,  22, 0                    }, /*             M_NODENAME shift  22 */
  {  15,  12, 0                    }, /*                  M_NOT shift  12 */
/* State 9 */
  {  19,   2, 0                    }, /*                  M_SEQ shift  2 */
/* State 10 */
  {  16,   3, 0                    }, /*           M_OPEN_ROUND shift  3 */
  {   1,  59, 0                    }, /*              MATCHTREE reduce 17 */
  {  18,  40, 0                    }, /*                M_PRUNE shift  40 */
  {   9,  36, 0                    }, /*                M_EXACT shift  36 */
  {   4,  14, 0                    }, /*              M_COLLECT shift  14 */
  {   5,  27, 0                    }, /*              M_ELEMENT shift  27 */
  {  22,  11, 0                    }, /*            conditional shift  11 */
  {  11,  16, 0                    }, /*                   M_IF shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {  25,  25, &yyActionTable[ 105] }, /*             match_mode shift  25 */
  {  10,  37, 0                    }, /*                M_FIRST shift  37 */
  {  27,  24, &yyActionTable[ 109] }, /*             tree_match shift  24 */
  {  12,  38, 0                    }, /*                 M_LAST shift  38 */
  {  13,  39, 0                    }, /*                 M_LEAF shift  39 */
  {  14,  22, 0                    }, /*             M_NODENAME shift  22 */
  {  15,  12, 0                    }, /*                  M_NOT shift  12 */
/* State 11 */
  {  19,   2, 0                    }, /*                  M_SEQ shift  2 */
  {  21,   8, &yyActionTable[ 118] }, /*                  M_XOR shift  8 */
/* State 12 */
  {  16,   3, 0                    }, /*           M_OPEN_ROUND shift  3 */
  {   1,  59, 0                    }, /*              MATCHTREE reduce 17 */
  {  18,  40, 0                    }, /*                M_PRUNE shift  40 */
  {   9,  36, 0                    }, /*                M_EXACT shift  36 */
  {   4,  14, 0                    }, /*              M_COLLECT shift  14 */
  {   5,  27, 0                    }, /*              M_ELEMENT shift  27 */
  {  22,  13, 0                    }, /*            conditional shift  13 */
  {  11,  16, 0                    }, /*                   M_IF shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {  25,  25, &yyActionTable[ 123] }, /*             match_mode shift  25 */
  {  10,  37, 0                    }, /*                M_FIRST shift  37 */
  {  27,  24, &yyActionTable[ 127] }, /*             tree_match shift  24 */
  {  12,  38, 0                    }, /*                 M_LAST shift  38 */
  {  13,  39, 0                    }, /*                 M_LEAF shift  39 */
  {  14,  22, 0                    }, /*             M_NODENAME shift  22 */
  {  15,  12, 0                    }, /*                  M_NOT shift  12 */
/* State 13 */
  {YYNOCODE,0,0}, /* Unused */
/* State 14 */
  {  16,   3, 0                    }, /*           M_OPEN_ROUND shift  3 */
  {   1,  59, 0                    }, /*              MATCHTREE reduce 17 */
  {  18,  40, 0                    }, /*                M_PRUNE shift  40 */
  {   9,  36, 0                    }, /*                M_EXACT shift  36 */
  {   4,  14, 0                    }, /*              M_COLLECT shift  14 */
  {   5,  27, 0                    }, /*              M_ELEMENT shift  27 */
  {  22,  15, 0                    }, /*            conditional shift  15 */
  {  11,  16, 0                    }, /*                   M_IF shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {  25,  25, &yyActionTable[ 140] }, /*             match_mode shift  25 */
  {  10,  37, 0                    }, /*                M_FIRST shift  37 */
  {  27,  24, &yyActionTable[ 144] }, /*             tree_match shift  24 */
  {  12,  38, 0                    }, /*                 M_LAST shift  38 */
  {  13,  39, 0                    }, /*                 M_LEAF shift  39 */
  {  14,  22, 0                    }, /*             M_NODENAME shift  22 */
  {  15,  12, 0                    }, /*                  M_NOT shift  12 */
/* State 15 */
  {YYNOCODE,0,0}, /* Unused */
/* State 16 */
  {  16,   3, 0                    }, /*           M_OPEN_ROUND shift  3 */
  {   1,  59, 0                    }, /*              MATCHTREE reduce 17 */
  {  18,  40, 0                    }, /*                M_PRUNE shift  40 */
  {   9,  36, 0                    }, /*                M_EXACT shift  36 */
  {   4,  14, 0                    }, /*              M_COLLECT shift  14 */
  {   5,  27, 0                    }, /*              M_ELEMENT shift  27 */
  {  22,  17, 0                    }, /*            conditional shift  17 */
  {  10,  37, 0                    }, /*                M_FIRST shift  37 */
  {  11,  16, 0                    }, /*                   M_IF shift  16 */
  {  25,  25, &yyActionTable[ 157] }, /*             match_mode shift  25 */
  {  26,  18, &yyActionTable[ 161] }, /*              selection shift  18 */
  {  27,  24, &yyActionTable[ 162] }, /*             tree_match shift  24 */
  {  12,  38, 0                    }, /*                 M_LAST shift  38 */
  {  13,  39, 0                    }, /*                 M_LEAF shift  39 */
  {  14,  22, 0                    }, /*             M_NODENAME shift  22 */
  {  15,  12, 0                    }, /*                  M_NOT shift  12 */
/* State 17 */
  {  17,   6, 0                    }, /*                   M_OR shift  6 */
  {  21,   8, &yyActionTable[ 170] }, /*                  M_XOR shift  8 */
  {   2,  10, 0                    }, /*                  M_AND shift  10 */
  {  19,   2, 0                    }, /*                  M_SEQ shift  2 */
/* State 18 */
  {   8,  19, 0                    }, /*                M_ENDIF shift  19 */
  {   7,  20, 0                    }, /*                 M_ELIF shift  20 */
/* State 19 */
  {YYNOCODE,0,0}, /* Unused */
/* State 20 */
  {  16,   3, 0                    }, /*           M_OPEN_ROUND shift  3 */
  {   1,  59, 0                    }, /*              MATCHTREE reduce 17 */
  {  18,  40, 0                    }, /*                M_PRUNE shift  40 */
  {   9,  36, 0                    }, /*                M_EXACT shift  36 */
  {   4,  14, 0                    }, /*              M_COLLECT shift  14 */
  {   5,  27, 0                    }, /*              M_ELEMENT shift  27 */
  {  22,  21, 0                    }, /*            conditional shift  21 */
  {  11,  16, 0                    }, /*                   M_IF shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {  25,  25, &yyActionTable[ 180] }, /*             match_mode shift  25 */
  {  10,  37, 0                    }, /*                M_FIRST shift  37 */
  {  27,  24, &yyActionTable[ 184] }, /*             tree_match shift  24 */
  {  12,  38, 0                    }, /*                 M_LAST shift  38 */
  {  13,  39, 0                    }, /*                 M_LEAF shift  39 */
  {  14,  22, 0                    }, /*             M_NODENAME shift  22 */
  {  15,  12, 0                    }, /*                  M_NOT shift  12 */
/* State 21 */
  {  17,   6, 0                    }, /*                   M_OR shift  6 */
  {  21,   8, &yyActionTable[ 193] }, /*                  M_XOR shift  8 */
  {   2,  10, 0                    }, /*                  M_AND shift  10 */
  {  19,   2, 0                    }, /*                  M_SEQ shift  2 */
/* State 22 */
  {   1,  23, 0                    }, /*              MATCHTREE shift  23 */
/* State 23 */
  {YYNOCODE,0,0}, /* Unused */
/* State 24 */
  {YYNOCODE,0,0}, /* Unused */
/* State 25 */
  {   1,  26, 0                    }, /*              MATCHTREE shift  26 */
/* State 26 */
  {YYNOCODE,0,0}, /* Unused */
/* State 27 */
  {   9,  36, &yyActionTable[ 205] }, /*                M_EXACT shift  36 */
  {  25,  28, &yyActionTable[ 202] }, /*             match_mode shift  28 */
  {  18,  40, &yyActionTable[ 209] }, /*                M_PRUNE shift  40 */
  {   1,  59, 0                    }, /*              MATCHTREE reduce 17 */
  {  12,  38, 0                    }, /*                 M_LAST shift  38 */
  {  13,  39, 0                    }, /*                 M_LEAF shift  39 */
  {   6,  30, 0                    }, /*           M_ELEMENT_NO shift  30 */
  {  10,  37, 0                    }, /*                M_FIRST shift  37 */
/* State 28 */
  {   1,  29, 0                    }, /*              MATCHTREE shift  29 */
/* State 29 */
  {YYNOCODE,0,0}, /* Unused */
/* State 30 */
  {   9,  36, &yyActionTable[ 215] }, /*                M_EXACT shift  36 */
  {  25,  31, &yyActionTable[ 212] }, /*             match_mode shift  31 */
  {  18,  40, &yyActionTable[ 219] }, /*                M_PRUNE shift  40 */
  {   1,  59, 0                    }, /*              MATCHTREE reduce 17 */
  {  12,  38, 0                    }, /*                 M_LAST shift  38 */
  {  13,  39, 0                    }, /*                 M_LEAF shift  39 */
  {   6,  33, 0                    }, /*           M_ELEMENT_NO shift  33 */
  {  10,  37, 0                    }, /*                M_FIRST shift  37 */
/* State 31 */
  {   1,  32, 0                    }, /*              MATCHTREE shift  32 */
/* State 32 */
  {YYNOCODE,0,0}, /* Unused */
/* State 33 */
  {   9,  36, &yyActionTable[ 225] }, /*                M_EXACT shift  36 */
  {  25,  34, &yyActionTable[ 222] }, /*             match_mode shift  34 */
  {  18,  40, &yyActionTable[ 228] }, /*                M_PRUNE shift  40 */
  {   1,  59, 0                    }, /*              MATCHTREE reduce 17 */
  {  12,  38, 0                    }, /*                 M_LAST shift  38 */
  {  13,  39, 0                    }, /*                 M_LEAF shift  39 */
  {  10,  37, 0                    }, /*                M_FIRST shift  37 */
  {YYNOCODE,0,0}, /* Unused */
/* State 34 */
  {   1,  35, 0                    }, /*              MATCHTREE shift  35 */
/* State 35 */
  {YYNOCODE,0,0}, /* Unused */
/* State 36 */
  {   1,  60, 0                    }, /*              MATCHTREE reduce 18 */
/* State 37 */
  {   1,  61, 0                    }, /*              MATCHTREE reduce 19 */
/* State 38 */
  {   1,  62, 0                    }, /*              MATCHTREE reduce 20 */
/* State 39 */
  {   1,  63, 0                    }, /*              MATCHTREE reduce 21 */
/* State 40 */
  {   1,  64, 0                    }, /*              MATCHTREE reduce 22 */
/* State 41 */
  {YYNOCODE,0,0}, /* Unused */
};

/* The state table contains information needed to look up the correct
** action in the action table, given the current state of the parser.
** Information needed includes:
**
**  +  A pointer to the start of the action hash table in yyActionTable.
**
**  +  A mask used to hash the look-ahead token.  The mask is an integer
**     which is one less than the size of the hash table.  
**
**  +  The default action.  This is the action to take if no entry for
**     the given look-ahead is found in the action hash table.
*/
struct yyStateEntry {
  struct yyActionEntry *hashtbl; /* Start of the hash table in yyActionTable */
  int mask;                      /* Mask used for hashing the look-ahead */
  YYACTIONTYPE actionDefault;    /* Default action if look-ahead not found */
};
static struct yyStateEntry yyStateTable[] = {
  { &yyActionTable[0], 15, 65},
  { &yyActionTable[16], 7, 65},
  { &yyActionTable[24], 15, 65},
  { &yyActionTable[40], 15, 65},
  { &yyActionTable[56], 7, 65},
  { &yyActionTable[64], 0, 43},
  { &yyActionTable[65], 15, 65},
  { &yyActionTable[81], 3, 45},
  { &yyActionTable[85], 15, 65},
  { &yyActionTable[101], 0, 46},
  { &yyActionTable[102], 15, 65},
  { &yyActionTable[118], 1, 47},
  { &yyActionTable[120], 15, 65},
  { &yyActionTable[136], 0, 48},
  { &yyActionTable[137], 15, 65},
  { &yyActionTable[153], 0, 49},
  { &yyActionTable[154], 15, 65},
  { &yyActionTable[170], 3, 53},
  { &yyActionTable[174], 1, 65},
  { &yyActionTable[176], 0, 50},
  { &yyActionTable[177], 15, 65},
  { &yyActionTable[193], 3, 54},
  { &yyActionTable[197], 0, 65},
  { &yyActionTable[198], 0, 51},
  { &yyActionTable[199], 0, 52},
  { &yyActionTable[200], 0, 65},
  { &yyActionTable[201], 0, 55},
  { &yyActionTable[202], 7, 65},
  { &yyActionTable[210], 0, 65},
  { &yyActionTable[211], 0, 56},
  { &yyActionTable[212], 7, 65},
  { &yyActionTable[220], 0, 65},
  { &yyActionTable[221], 0, 57},
  { &yyActionTable[222], 7, 65},
  { &yyActionTable[230], 0, 65},
  { &yyActionTable[231], 0, 58},
  { &yyActionTable[232], 0, 65},
  { &yyActionTable[233], 0, 65},
  { &yyActionTable[234], 0, 65},
  { &yyActionTable[235], 0, 65},
  { &yyActionTable[236], 0, 65},
  { &yyActionTable[237], 0, 44},
};

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int idx;                            /* Index of top element in stack */
  int errcnt;                         /* Shifts left before out of the error */
  struct yyStackEntry *top;           /* Pointer to the top stack element */
  struct yyStackEntry stack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;

/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void CMatchParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}

/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static char *yyTokenName[] = { 
  "$",             "MATCHTREE",     "M_AND",         "M_CLOSE_ROUND",
  "M_COLLECT",     "M_ELEMENT",     "M_ELEMENT_NO",  "M_ELIF",      
  "M_ENDIF",       "M_EXACT",       "M_FIRST",       "M_IF",        
  "M_LAST",        "M_LEAF",        "M_NODENAME",    "M_NOT",       
  "M_OPEN_ROUND",  "M_OR",          "M_PRUNE",       "M_SEQ",       
  "M_UNARY",       "M_XOR",         "conditional",   "error",       
  "match_condition",  "match_mode",    "selection",     "tree_match",  
};
#define YYTRACE(X) if( yyTraceFILE ) fprintf(yyTraceFILE,"%sReduce [%s].\n",yyTracePrompt,X);
#else
#define YYTRACE(X)
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to CMatchParser and CMatchParserFree.
*/
void *CMatchParserAlloc(void *(*mallocProc)(...)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( sizeof(yyParser), __FILE__, __LINE__ );
  if( pParser ){
    pParser->idx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;

  if( pParser->idx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->idx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[pParser->top->major]);
  }
#endif
  yymajor = pParser->top->major;
  yy_destructor( yymajor, &pParser->top->minor);
  pParser->idx--;
  pParser->top--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from CMatchParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void CMatchParserFree(
  void *p,               /* The parser to be deleted */
  void (*freeProc)(...)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->idx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)(pParser, __FILE__, __LINE__);
}

/*
** Find the appropriate action for a parser given the look-ahead token.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_parser_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead             /* The look-ahead token */
){
  struct yyStateEntry *pState;   /* Appropriate entry in the state table */
  struct yyActionEntry *pAction; /* Action appropriate for the look-ahead */
 
  /* if( pParser->idx<0 ) return YY_NO_ACTION;  */
  pState = &yyStateTable[pParser->top->stateno];
  if( iLookAhead!=YYNOCODE ){
    pAction = &pState->hashtbl[iLookAhead & pState->mask];
    while( pAction ){
      if( pAction->lookahead==iLookAhead ) return pAction->action;
      pAction = pAction->next;
    }
  }else if( pState->mask!=0 || pState->hashtbl->lookahead!=YYNOCODE ){
    return YY_NO_ACTION;
  }
  return pState->actionDefault;
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yypParser->idx++;
  yypParser->top++;
  if( yypParser->idx>=YYSTACKDEPTH ){
     yypParser->idx--;
     yypParser->top--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     return;
  }
  yypParser->top->stateno = yyNewState;
  yypParser->top->major = yyMajor;
  yypParser->top->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->idx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->idx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->stack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 24, 1 },
  { 22, 3 },
  { 22, 3 },
  { 22, 3 },
  { 22, 3 },
  { 22, 3 },
  { 22, 2 },
  { 22, 2 },
  { 22, 3 },
  { 22, 2 },
  { 22, 1 },
  { 26, 1 },
  { 26, 3 },
  { 27, 2 },
  { 27, 3 },
  { 27, 4 },
  { 27, 5 },
  { 25, 0 },
  { 25, 1 },
  { 25, 1 },
  { 25, 1 },
  { 25, 1 },
  { 25, 1 },
};

static void yy_accept(
  yyParser *yypParser           /* The parser */
  CMatchParserANSIARGDECL              /* Extra arguments (if any) */
);  /* Forward declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
  CMatchParserANSIARGDECL
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  struct yyStackEntry *yymsp;     /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  yymsp = yypParser->top;
  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **     YYTRACE("<text of the rule>");
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
        YYTRACE("match_condition ::= conditional")
#line 165 "manip/CMatchParser.lem"
{ 
        mstate->value = yymsp[0].minor.yy4; 
    }
#line 877 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        break;
      case 1:
        YYTRACE("conditional ::= M_OPEN_ROUND conditional M_CLOSE_ROUND")
#line 174 "manip/CMatchParser.lem"
{ 
        yygotominor.yy4 = yymsp[-1].minor.yy4;
    }
#line 885 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for M_OPEN_ROUND */
        /* No destructor defined for M_CLOSE_ROUND */
        break;
      case 2:
        YYTRACE("conditional ::= conditional M_SEQ conditional")
#line 178 "manip/CMatchParser.lem"
{   
        /* The sequence or implication. */
        /* A B | seq                    */
        /* ----+-----                   */
        /* 1 1 |  1                     */
        /* 1 0 |  0                     */
        /* 0 1 |  1                     */
        /* 0 0 |  0 (!)                 */
        yygotominor.yy4 = yymsp[0].minor.yy4; 
    }
#line 902 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for conditional */
        /* No destructor defined for M_SEQ */
        break;
      case 3:
        YYTRACE("conditional ::= conditional M_OR conditional")
#line 189 "manip/CMatchParser.lem"
{ 
        /* The alternative. */
        /* A B |  or        */
        /* ----+-----       */
        /* 1 1 |  1         */
        /* 1 0 |  1         */
        /* 0 1 |  1         */
        /* 0 0 |  0         */
        yygotominor.yy4 = (yymsp[-2].minor.yy4 || yymsp[0].minor.yy4) ? 1 : 0; 
    }
#line 919 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for M_OR */
        break;
      case 4:
        YYTRACE("conditional ::= conditional M_XOR conditional")
#line 200 "manip/CMatchParser.lem"
{ 
        /* The exclusive alternative. */
        /* A B | xor                  */
        /* ----+-----                 */
        /* 1 1 |  0                   */
        /* 1 0 |  1                   */
        /* 0 1 |  1                   */
        /* 0 0 |  0                   */
        yygotominor.yy4 = ((yymsp[-2].minor.yy4 && ! yymsp[0].minor.yy4) || (! yymsp[-2].minor.yy4 && yymsp[0].minor.yy4)) ? 1 : 0; 
    }
#line 935 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for M_XOR */
        break;
      case 5:
        YYTRACE("conditional ::= conditional M_AND conditional")
#line 211 "manip/CMatchParser.lem"
{ 
        /* The conjunction. */
        /* A B | and        */
        /* ----+-----       */
        /* 1 1 |  1         */
        /* 1 0 |  0         */
        /* 0 1 |  0         */
        /* 0 0 |  0         */
        yygotominor.yy4 = (yymsp[-2].minor.yy4 && yymsp[0].minor.yy4) ? 1 : 0; 
    }
#line 951 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for M_AND */
        break;
      case 6:
        YYTRACE("conditional ::= M_NOT conditional")
#line 222 "manip/CMatchParser.lem"
{
        /* The negation. */
        /* A | not       */
        /* --+-----      */
        /* 1 |  0        */
        /* 0 |  1        */
        yygotominor.yy4 = ! yymsp[0].minor.yy4; 
    }
#line 965 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for M_NOT */
        break;
      case 7:
        YYTRACE("conditional ::= M_COLLECT conditional")
#line 231 "manip/CMatchParser.lem"
{
        /* The collector. */
        /* A | collect    */
        /* --+-----       */
        /* 1 |  1         */
        /* 0 |  1         */
        yygotominor.yy4 = 1; 
    }
#line 979 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for M_COLLECT */
        /* No destructor defined for conditional */
        break;
      case 8:
        YYTRACE("conditional ::= M_IF selection M_ENDIF")
#line 240 "manip/CMatchParser.lem"
{
        /* The selection.                                 */
        /* E.g.: if <conditional>                         */
        /*       elif <conditional>                       */
        /*       elif <conditional>                       */
        /*       endif                                    */
        /* The conditionals are evaluated till the first  */
        /* true conditional is found. The following elifs */
        /* are skipped and their conditionals are not     */
        /* evaluated anymore.                             */
        yygotominor.yy4 = yymsp[-1].minor.yy4;
        mstate->depth--;
    }
#line 999 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for M_IF */
        /* No destructor defined for M_ENDIF */
        break;
      case 9:
        YYTRACE("conditional ::= M_NODENAME MATCHTREE")
#line 254 "manip/CMatchParser.lem"
{
        /* It's checked whether the root node of the */
        /* current syntax tree has the given name.   */
        /* Regular expressions are allowed, too.     */
        if (mstate->selected[mstate->depth]) 
            yygotominor.yy4 = 0;
        else 
            yygotominor.yy4 = mstate->matcher->matchNodeName (mstate->tree, yymsp[0].minor.yy0);
    }
#line 1015 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for M_NODENAME */
        break;
      case 10:
        YYTRACE("conditional ::= tree_match")
#line 264 "manip/CMatchParser.lem"
{
        yygotominor.yy4 = yymsp[0].minor.yy4;
    }
#line 1024 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        break;
      case 11:
        YYTRACE("selection ::= conditional")
#line 273 "manip/CMatchParser.lem"
{
        if (! mstate->selected[mstate->depth])
            yygotominor.yy4 = mstate->selected[mstate->depth] = yymsp[0].minor.yy4;
        else
            yygotominor.yy4 = 1;
    }
#line 1035 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        break;
      case 12:
        YYTRACE("selection ::= selection M_ELIF conditional")
#line 280 "manip/CMatchParser.lem"
{
        if (! mstate->selected[mstate->depth])
            yygotominor.yy4 = mstate->selected[mstate->depth] = yymsp[0].minor.yy4;
        else
            yygotominor.yy4 = 1;
    }
#line 1046 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for selection */
        /* No destructor defined for M_ELIF */
        break;
      case 13:
        YYTRACE("tree_match ::= match_mode MATCHTREE")
#line 292 "manip/CMatchParser.lem"
{ 
        if (mstate->selected[mstate->depth]) 
            yygotominor.yy4 = 0;
        else 
            yygotominor.yy4 = mstate->matcher->matchTree (yymsp[-1].minor.yy4, *mstate, mstate->tree, yymsp[0].minor.yy0);
    }
#line 1059 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        break;
      case 14:
        YYTRACE("tree_match ::= M_ELEMENT match_mode MATCHTREE")
#line 299 "manip/CMatchParser.lem"
{
        if (mstate->selected[mstate->depth]) 
            yygotominor.yy4 = 0;
        else if (mstate->mode == CTreeMatcher::ANY_LIST)
            yygotominor.yy4 = mstate->matcher->matchList (yymsp[-1].minor.yy4, *mstate, yymsp[0].minor.yy0);
        else
            yygotominor.yy4 = mstate->matcher->matchTree (yymsp[-1].minor.yy4, *mstate, mstate->tree, yymsp[0].minor.yy0);
    }
#line 1072 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for M_ELEMENT */
        break;
      case 15:
        YYTRACE("tree_match ::= M_ELEMENT M_ELEMENT_NO match_mode MATCHTREE")
#line 308 "manip/CMatchParser.lem"
{
        if (mstate->selected[mstate->depth]) 
            yygotominor.yy4 = 0;
        else if (mstate->mode == CTreeMatcher::ANY_LIST)
            yygotominor.yy4 = mstate->matcher->matchList (yymsp[-1].minor.yy4, *mstate, yymsp[0].minor.yy0, yymsp[-2].minor.yy0);
        else
            yygotominor.yy4 = mstate->matcher->matchTree (yymsp[-1].minor.yy4, *mstate, mstate->tree, yymsp[0].minor.yy0);
    }
#line 1086 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for M_ELEMENT */
        break;
      case 16:
        YYTRACE("tree_match ::= M_ELEMENT M_ELEMENT_NO M_ELEMENT_NO match_mode MATCHTREE")
#line 318 "manip/CMatchParser.lem"
{
        if (mstate->selected[mstate->depth]) 
            yygotominor.yy4 = 0;
        else if (mstate->mode == CTreeMatcher::ANY_LIST)
            yygotominor.yy4 = mstate->matcher->matchList (yymsp[-1].minor.yy4, *mstate, yymsp[0].minor.yy0, yymsp[-3].minor.yy0, yymsp[-2].minor.yy0);
        else
            yygotominor.yy4 = mstate->matcher->matchTree (yymsp[-1].minor.yy4, *mstate, mstate->tree, yymsp[0].minor.yy0);
    }
#line 1100 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for M_ELEMENT */
        break;
      case 17:
        YYTRACE("match_mode ::=")
#line 331 "manip/CMatchParser.lem"
{ yygotominor.yy4 = CTreeMatcher::MATCH_ALL; }
#line 1107 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        break;
      case 18:
        YYTRACE("match_mode ::= M_EXACT")
#line 332 "manip/CMatchParser.lem"
{ yygotominor.yy4 = CTreeMatcher::MATCH_EXACT; }
#line 1113 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for M_EXACT */
        break;
      case 19:
        YYTRACE("match_mode ::= M_FIRST")
#line 333 "manip/CMatchParser.lem"
{ yygotominor.yy4 = CTreeMatcher::MATCH_FIRST; }
#line 1120 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for M_FIRST */
        break;
      case 20:
        YYTRACE("match_mode ::= M_LAST")
#line 334 "manip/CMatchParser.lem"
{ yygotominor.yy4 = CTreeMatcher::MATCH_LAST; }
#line 1127 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for M_LAST */
        break;
      case 21:
        YYTRACE("match_mode ::= M_LEAF")
#line 335 "manip/CMatchParser.lem"
{ yygotominor.yy4 = CTreeMatcher::MATCH_LEAF; }
#line 1134 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for M_LEAF */
        break;
      case 22:
        YYTRACE("match_mode ::= M_PRUNE")
#line 336 "manip/CMatchParser.lem"
{ yygotominor.yy4 = CTreeMatcher::MATCH_PRUNE; }
#line 1141 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
        /* No destructor defined for M_PRUNE */
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->idx -= yysize;
  yypParser->top -= yysize;
  yyact = yy_find_parser_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser CMatchParserARGDECL);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
  CMatchParserANSIARGDECL              /* Extra arguments (if any) */
){
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
  CMatchParserANSIARGDECL               /* Extra arguments (if any) */
){
#define TOKEN (yyminor.yy0)
#line 156 "manip/CMatchParser.lem"

    mstate->value = -1;

#line 1188 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/CMatchParser.cc"
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
  CMatchParserANSIARGDECL              /* Extra arguments (if any) */
){
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "CMatchParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void CMatchParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  CMatchParserTOKENTYPE yyminor       /* The value for the token */
  CMatchParserANSIARGDECL
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->idx<0 ){
    /* Olaf: Empty files must be parse too!  if( yymajor==0 ) return; */
    yypParser->idx = 0;
    yypParser->errcnt = -1;
    yypParser->top = &yypParser->stack[0];
    yypParser->top->stateno = 0;
    yypParser->top->major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_parser_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->errcnt--;
      if( yyendofinput && yypParser->idx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE CMatchParserARGDECL);
    }else if( yyact == YY_ERROR_ACTION ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->errcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion CMatchParserARGDECL);
      }
      if( yypParser->top->major==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->idx >= 0 &&
          yypParser->top->major != YYERRORSYMBOL &&
          (yyact = yy_find_parser_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->idx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser CMatchParserARGDECL);
          yymajor = YYNOCODE;
        }else if( yypParser->top->major!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->errcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->errcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion CMatchParserARGDECL);
      }
      yypParser->errcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser CMatchParserARGDECL);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser CMatchParserARGDECL);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->idx>=0 );
  return;
}
