// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Parser__
#define __Parser__

#include "Puma/Unit.h"
#include "Puma/Syntax.h"
#include "Puma/Builder.h"
#include "Puma/Semantic.h"
#include "Puma/CProject.h"

namespace Puma {


class CTranslationUnit;

class Parser {
  Syntax *syntax;
  Builder *builder;
  Semantic *semantic;
  
public:
  Parser (Syntax &x, Builder &b, Semantic &s) :
    syntax (&x), builder (&b), semantic (&s) {}

  CTranslationUnit *parse (Unit &, CProject &, int = 0);

  void configure (Config &);
};


} // namespace Puma

#endif /* __Parser__ */
