// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CSyntax_h__
#define __CSyntax_h__

// Parser for the C programming language (C99)

#include "Puma/Syntax.h"
#include "Puma/CBuilder.h"
#include "Puma/CSemantic.h"
#include "Puma/CTokens.h"

#include <bitset>
using std::bitset;

namespace Puma {


class CSyntax : public Syntax {
public:
  CSyntax (CBuilder &, CSemantic &);
  virtual void configure (Config &);
  
  typedef bitset<TOK_NO> tokenset;

private:
  CBuilder &builder () const { return (CBuilder&)Syntax::builder (); }
  CSemantic &semantic () const { return (CSemantic&)Syntax::semantic (); }

protected:

  // check if the current token is in FIRST set 'ts'
  inline bool predict_1 (const tokenset &ts);

  // tokensets
  tokenset _prim_types;
    
  // FIRST and FOLLOW sets
  tokenset _typedef_name_1;
  tokenset _type_name_1;
  tokenset _class_spec_1;
  tokenset _class_head_1;
  tokenset _class_key_1;
  tokenset _cv_qual_1;
  tokenset _cv_qual_seq_1;
  tokenset _enum_spec_1;
  tokenset _elaborated_type_spec_1;
  tokenset _simple_type_spec_1;
  tokenset _type_spec_1;
  tokenset _decl_spec_1;
  tokenset _misc_spec_1;
  tokenset _storage_class_spec_1;
  tokenset _fct_spec_1;
  tokenset _prim_expr_1;
  tokenset _id_expr_1;
  tokenset _cmpd_literal_1;
  tokenset _postfix_expr1_1;
  tokenset _identifier_1;
  tokenset _literal_1;
  tokenset _cmpd_str_1;
  tokenset _str_literal_1;
  tokenset _direct_declarator1_1;

  // tokenset initialization
  virtual void init_prim_types ();
  
  // FIRST and FOLLOW initialization
  virtual void init_typedef_name ();
  virtual void init_type_name ();
  virtual void init_class_spec ();
  virtual void init_class_head ();
  virtual void init_class_key ();
  virtual void init_cv_qual ();
  virtual void init_cv_qual_seq ();
  virtual void init_enum_spec ();
  virtual void init_elaborated_type_spec ();
  virtual void init_simple_type_spec ();
  virtual void init_type_spec ();
  virtual void init_decl_spec ();
  virtual void init_misc_spec ();
  virtual void init_storage_class_spec ();
  virtual void init_fct_spec ();
  virtual void init_postfix_expr1 ();
  virtual void init_prim_expr ();
  virtual void init_id_expr ();
  virtual void init_cmpd_literal ();
  virtual void init_identifier ();
  virtual void init_literal ();
  virtual void init_cmpd_str ();
  virtual void init_str_literal ();
  virtual void init_direct_declarator1 ();
      
  // Grammar rules

public:
  // A.1 Keywords
  CTree * rule_typedef_name ();
  virtual bool typedef_name ();
  virtual CTree *private_name ();

  // A.2 Lexical conventions
  CTree * rule_identifier ();
  virtual bool identifier ();
  CTree * rule_literal ();
  virtual bool literal ();
  CTree * rule_cmpd_str ();
  virtual bool cmpd_str ();
  CTree * rule_str_literal ();
  virtual bool str_literal ();
  
  // A.3 Basic concepts 
  virtual CTree *trans_unit ();

  // A.4 Expression
  CTree * rule_prim_expr ();
  virtual bool prim_expr ();
  CTree * rule_id_expr ();
  virtual bool id_expr ();
  CTree * rule_cmpd_literal ();
  virtual bool cmpd_literal ();
  virtual CTree *postfix_expr ();
  CTree * rule_postfix_expr1 ();
  virtual bool postfix_expr1 ();
  virtual CTree *expr_list ();
  virtual CTree *unary_expr ();
  virtual CTree *unary_expr1 ();
  virtual CTree *cast_expr ();
  virtual CTree *cast_expr1 ();
  virtual CTree *mul_expr ();
  virtual CTree *add_expr ();
  virtual CTree *shift_expr ();
  virtual CTree *rel_expr ();
  virtual CTree *equ_expr ();
  virtual CTree *and_expr ();
  virtual CTree *excl_or_expr ();
  virtual CTree *incl_or_expr ();
  virtual CTree *log_and_expr ();
  virtual CTree *log_or_expr ();
  virtual CTree *cond_expr ();
  virtual CTree *ass_expr ();
  virtual CTree *ass_expr1 ();
  virtual CTree *expr ();
  virtual CTree *const_expr ();

  // A.5 Statements
  virtual CTree *stmt ();
  virtual CTree *label_stmt ();
  virtual CTree *expr_stmt ();
  virtual CTree *cmpd_stmt ();
  virtual CTree *stmt_seq ();
  virtual CTree *select_stmt ();
  virtual CTree *sub_stmt ();
  virtual CTree *condition ();
  virtual CTree *iter_stmt ();
  virtual CTree *for_init_stmt ();
  virtual CTree *jump_stmt ();
      
  // A.6 Declarations
  virtual CTree *decl_seq ();
  virtual CTree *decl ();
  virtual CTree *block_decl ();
  virtual CTree *simple_decl ();
  CTree * rule_decl_spec ();
  virtual bool decl_spec ();
  virtual CTree *decl_spec_seq ();
  virtual CTree *decl_spec_seq1 ();
  CTree * rule_misc_spec ();
  virtual bool misc_spec ();
  CTree * rule_storage_class_spec ();
  virtual bool storage_class_spec ();
  CTree * rule_fct_spec ();
  virtual bool fct_spec ();
  CTree * rule_type_spec ();
  virtual bool type_spec ();
  CTree * rule_simple_type_spec ();
  virtual bool simple_type_spec ();
  CTree * rule_type_name ();
  virtual bool type_name ();
  CTree * rule_elaborated_type_spec ();
  virtual bool elaborated_type_spec ();
  CTree * rule_enum_spec ();
  virtual bool enum_spec ();
  virtual CTree *enumerator_list ();
  virtual CTree *enumerator_def ();
  virtual CTree *enumerator ();

  // A.7 Declarators
  virtual CTree *init_declarator_list ();
  virtual CTree *init_declarator ();
  virtual CTree *declarator ();
  virtual CTree *direct_declarator ();
  CTree *rule_direct_declarator1 ();
  virtual bool direct_declarator1 ();
  virtual CTree *identifier_list ();
  virtual CTree *array_delim ();
  virtual CTree *ptr_operator ();
  CTree * rule_cv_qual_seq ();
  virtual bool cv_qual_seq ();
  CTree * rule_cv_qual ();
  virtual bool cv_qual ();
  virtual CTree *declarator_id ();
  virtual CTree *type_id ();
  virtual CTree *type_spec_seq ();
  virtual CTree *type_spec_seq1 ();
  virtual CTree *abst_declarator ();
  virtual CTree *direct_abst_declarator ();
  virtual CTree *direct_abst_declarator1 ();
  virtual CTree *param_decl_clause ();
  virtual CTree *param_decl_list ();
  virtual CTree *param_decl ();
  virtual CTree *param_decl1 ();
  virtual CTree *param_decl2 ();
  virtual CTree *fct_def ();
  virtual CTree *arg_decl_seq ();
  virtual CTree *fct_body ();
  virtual CTree *init ();
  virtual CTree *init_clause ();
  virtual CTree *init_list ();
  virtual CTree *init_list_item ();
  virtual CTree *designation ();
  virtual CTree *designator ();

  // A.8 Classes
  CTree * rule_class_spec ();
  virtual bool class_spec ();
  CTree * rule_class_head ();
  virtual bool class_head ();
  CTree * rule_class_key ();
  virtual bool class_key ();
  virtual CTree *member_spec ();
  virtual CTree *member_decl ();
  virtual CTree *member_declarator_list ();
  virtual CTree *member_declarator ();

protected:
  bool is_fct_def ();
  
  virtual void handle_directive ();
};

inline CSyntax::CSyntax (CBuilder &b, CSemantic &s) : Syntax (b, s) {}

// check if the current token is in FIRST set 'ts'
inline bool CSyntax::predict_1 (const tokenset &ts) {
  return ts[look_ahead ()];
}

inline void CSyntax::handle_directive ()
 { Syntax::handle_directive (); }


} // namespace Puma

#endif /* __CSyntax_h__ */
