;;; Fichier .emacs standard
;;; Copyright (c) 1999 Stphane LEVANT <stephane.levant@mailclub.com>
;;; Toute modification ou utilisation non commerciale de ce fichier
;;; est autorise pourvu que ce prsent copyright y figure.

(defvar xemacs-p
  (string-match "XEmacs\\|Lucid"  emacs-version))


;;; Emulation de certaines touches

; Pour supprimer le texte selectionn
(delete-selection-mode t)

; Affectation des touches
(global-set-key [next]		'scroll-haut)
(global-set-key [prior]		'scroll-bas)
(global-set-key "\ew"   	'copier-region)
(global-set-key [end]		'end-of-line)
(global-set-key [home]		'beginning-of-line)
(global-set-key [delete]	'delete-char)
(global-set-key [(shift down)]	'shift-bas)
(global-set-key [(shift up)]	'shift-haut)
(global-set-key [(shift right)]	'shift-droite)
(global-set-key [(shift left)]	'shift-gauche)
(global-set-key [(meta delete)]	'kill-word)
(global-set-key [(control end)]	'end-of-buffer)
(global-set-key [(shift insert)]   'yank)
(global-set-key [(shift delete)]   'kill-region)
(global-set-key [(control home)]   'beginning-of-buffer)
(global-set-key [(control insert)] 'copier-region)

; Dfinition des fonctions
(cond (xemacs-p
       (defun deactivate-mark ()
	 (zmacs-deactivate-region))
       (defalias 'sun-mark 'mark))
      (t
       (defun activate-region()
	 nil)
       (defun sun-mark ()
	 mark-active)))

(defun copier-region()
  (interactive)
  (copy-region-as-kill (point) (mark))
  (deactivate-mark))

(defun scroll-haut()
  (interactive)
  (move-to-window-line -1)
  (condition-case ()
      (scroll-up)
    (error nil)))

(defun scroll-bas()
  (interactive)
  (move-to-window-line 0)
  (condition-case ()
      (scroll-down)
    (error nil)))

(defun shift-droite()
  (interactive)
  (if (sun-mark)
      nil
    (set-mark (point)))
  (activate-region)
  (forward-char))

(defun shift-gauche()
  (interactive)
  (if (sun-mark)
      nil
    (set-mark (point)))
  (activate-region)
  (backward-char))

(defun shift-bas()
  (interactive)
  (if (sun-mark)
      nil
    (set-mark (point)))
  (activate-region)
  (next-line 1))

(defun shift-haut()
  (interactive)
  (if (sun-mark)
      nil
    (set-mark (point)))
  (activate-region)
  (previous-line 1))



;;; Couleur

(require 'font-lock)

(cond (xemacs-p
;       (set-face-background 'default "moccasin")
       )
      (t
       (transient-mark-mode t)			; Rgion en couleur
;       (set-face-background 'region "grey84")	; Couleur d'une rgion
;       (set-background-color "moccasin")	; Couleur du fond
;       (set-face-foreground 'modeline "Yellow") ; texte Barre d'affichage
  ))

(if xemacs-p
    (setq font-lock-auto-fontify t)
  (global-font-lock-mode t))
(condition-case ()
    (make-face-bold font-lock-function-name-face)
  (error nil))


;;; Prfrences

(column-number-mode 1)		       ; numero de colonne dans la barre d'etat
;(setq inhibit-startup-message t)       ; pas de message au demarrage
(standard-display-european t)		; Affichage des accents
(setq display-time-24hr-format t)	; heure au format 24h
(setq auto-save-list-file-name t)	; Empche les .save-*
(setq require-final-newline t)		; Rajoute un \n  la fin des fichiers
(put 'downcase-region 'disabled nil)	; autorise le c-x c-l
(put 'upcase-region 'disabled nil)	; autorise le c-x c-u
(defalias 'yes-or-no-p 'y-or-n-p)	; Pas besoin de taper yes
;; Change la barre de titre et le nom de l'icone :
;;   (Si pas def dans le .Xresources)
;;   affiche le buffer courant
(setq frame-title-format '("Emacs - %b"))
(setq icon-title-format '("Emacs - %b"))
(require 'uniquify)		; deux buffers differents avec le meme nom
(setq uniquify-buffer-name-style 'post-forward)
(if xemacs-p
    (setq minibuffer-max-depth nil))
(setq compile-auto-highlight t)
(setq next-line-add-newlines nil)

(define-key emacs-lisp-mode-map "\^m"	 'newline-and-indent)
(define-key emacs-lisp-mode-map "\^j"	 'newline)



;;; Touches pour le texte

(global-set-key "\eg"    'goto-line)
(global-set-key "\es" 'nonincremental-search-forward)
(global-set-key "\^t"    'transpose-cara)
(global-set-key [f12]    'annuler-mark)

(defun annuler-mark()
  (interactive)
  (deactivate-mark))

(defun transpose-cara ()
  (interactive)
  (transpose-chars -1)
  (forward-char))


;;; Touches de dfilement

;; affectation des touches
(global-set-key [(control tab)]  'other-window)
(global-set-key [(control shift tab)] 'other-frame)
(global-set-key [(meta down)] 'defiler-bas)
(global-set-key [(meta up)]   'defiler-haut)
(global-set-key [(control prior)]'augmenter-fenetre)
(global-set-key [(control next)] 'diminuer-fenetre)
(global-set-key [(control shift up)] 'ligne-au-dessus)
(global-set-key [(control shift down)] 'ligne-en-dessous)
(add-hook 'minibuffer-setup-hook
	  '(lambda ()
	     (local-set-key [(control tab)]  'other-window)))

;; dfinition des fonctions
(defun ligne-au-dessus()
  (interactive)
      (backward-char (- (window-width) 1)))

(defun ligne-en-dessous()
  (interactive)
      (forward-char (- (window-width) 1)))

(defun defiler-bas ()
  (interactive)
  (next-line 1)
  (scroll-up 1))

(defun defiler-haut ()
  (interactive)
  (previous-line 1)
  (scroll-down 1))

(defun diminuer-fenetre()
  (interactive)
  (enlarge-window -1))

(defun augmenter-fenetre()
  (interactive)
  (enlarge-window 1))


;;; buffers
(global-set-key [(meta return)] 'swap-buffer)
(global-set-key [(meta shift right)] 'buffer-select+)
(global-set-key [(meta shift left)] 'buffer-select-)
(global-set-key [(meta right)] 'buffer-select-all+)
(global-set-key [(meta left)] 'buffer-select-all-)

(defun swap-buffer ()
  (interactive)
  (let ((l (cdr (buffer-list))))
    (while (string-match "\\*Minibuf" (buffer-name (car l)))
      (setq l (cdr l)))
    (switch-to-buffer (car l))))

(defun buffer-select+()
  "Selectionne le dernier buffer dans la liste des buffers
N'affiche pas les buffers cres par emacs"
  (interactive)
  (buffer-exclut+ "^ ?\\*.*\\*$"))

(defun buffer-select-()
  "Place le buffer courant en dernire position dans la liste des buffers
donc selectionne le deuxime buffer dans la liste des buffers
N'affiche pas les buffers cres par emacs"
  (interactive)
  (buffer-exclut- "^ ?\\*.*\\*$"))

(defun buffer-select-all+()
  "Slectionne le dernier buffer dans la liste des buffers"
  (interactive)
  (buffer-exclut+ "^ \\*Minibuf.*\\*$"))
  
(defun buffer-select-all-()
  "Place le buffer courant en dernire position dans la liste des buffers
donc selectionne le deuxime buffer dans la liste des buffers"
  (interactive)
  (buffer-exclut- "^ \\*Minibuf.*\\*$"))

(defun buffer-exclut+ (regexp)
  (let ((l (reverse (buffer-list)))
	(buf (current-buffer)))
    (while (progn
	     (if l nil
	       (switch-to-buffer buf)
	       (error "Pas de buffer  afficher"))
	     (switch-to-buffer (car l))
	     (setq l (cdr l))
	     (string-match regexp (buffer-name (current-buffer)))))))

(defun buffer-exclut- (regexp)
  (let ((n (length (buffer-list)))
	(k 0)
	(buf (current-buffer)))
    (while (progn
	     (setq k (1+ k))
	     (if (<= k n) nil
	       (switch-to-buffer buf)
	       (error "Pas de buffer  afficher"))
	     (bury-buffer)
	     (string-match regexp (buffer-name (current-buffer)))))))
