#include <unistd.h>
#include <sys/socket.h>
#include <string.h>
#include <sys/un.h> 

#include "unix.h"

int unix_server_socket(gchar *fname)
{
  struct sockaddr_un name;
  int fd;
  int curstate = 1;

  g_assert(fname);
  
  unlink(fname);

  if ((fd = socket(PF_LOCAL, SOCK_STREAM, 0)) < 0)
    {
      g_message("UNIX: Could not create socket.");
      return -1;
    }

  setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, &curstate, sizeof(curstate));

  name.sun_family = AF_LOCAL;
  strncpy(name.sun_path, fname, sizeof(name.sun_path));

  if (bind(fd, (struct sockaddr *) &name, SUN_LEN(&name)) < 0)
    {
      g_message("UNIX: Could not bind socket.");
      close(fd);
      unlink(fname);
      return -1;
    }

  if (listen(fd, 5) < 0)
    {
      g_message("UNIX: Could not make socket listen.");
      close(fd);
      unlink(fname);
      return -1;
    }
 
  g_message("UNIX: Successfully created server socket '%s'.", fname);

  return fd;
}

int unix_server_accept(int fd)
{  
  struct sockaddr_un client;
  size_t size;
  
  g_message("UNIX: Connection recieved.");

  size = sizeof(client);
  return accept(fd, (struct sockaddr*) &client, &size);
}
