#ifndef conjunctionh
#define conjunctionh

#include <glib.h>


#include <source.h>
#include <sink.h>
#include <block-queue.h>

typedef void (*ConjunctionDeathProc) (gpointer p, BlockQueue *b);

BlockQueue* conjunction_add(gpointer from, ConjunctionDeathProc from_death, gpointer to, ConjunctionDeathProc to_death, guint len, guint hold);
gboolean conjunction_remove(gpointer from, gpointer to);
void conjunction_remove_item(gpointer item);
gboolean conjunction_exists(gpointer from, gpointer to);
void conjunction_reset();

void link_source_sink(Source*, Sink*, guint len, guint hold);
void link_sink_sink(Sink *sink1, Sink* sink2, guint len, guint hold); // Links monitoring output of sink1 to input of sink2

#endif
