#ifndef volumeh
#define volumeh

#include <glib.h>

#include <asddef.h>

typedef struct __attribute__ ((packed))
{
  guint16 factor[ASD_CHANNELS_MAX];
} Volume;

void volume_mute(Volume *v);
void volume_max(Volume *v);
gboolean volume_is_muted(Volume *v);
gboolean volume_is_max(Volume *v);

void volume_from_vb(Volume *v, guint32 volume, gint32 balance);
void volume_from_lr(Volume *v, guint32 l, guint32 r);

void volume_from_le(Volume *v);
void volume_to_le(Volume *v);

void volume_parse(Volume *v, gchar *p);
void volume_to_string(Volume *vol, gchar *s, guint l);

#endif
