#ifndef protocolasdspech
#define protocolasdspech

#include <glib.h>

#include <volume.h>
#include <sample-type.h>

#define PROTOCOL_ASD_VERSION 1

#define PACKED __attribute__ ((packed))

typedef struct PACKED
{
  guint16 id;
  guint8 version;
  guint16 command;
  guint32 length;
} ProtocolAsdRequest;

typedef struct PACKED
{
  gchar version[128];
} ProtocolAsdServerVersionResponse;

typedef struct PACKED
{
  guint32 block_size;                      // Internal block size in bytes
  SampleType sample_type;                  // The internal sample forma
  guint16 alloc_blocks;                    // Currently allocated blocks
  gboolean asd_auth_locked:1;              // ASD protocol locked for foreign acccess
  gboolean esound_auth_locked:1;           // ESOUND -"-
  guint32 average_latency;                 // Average latency in msec. Pretty useless.
  gchar string[128];                       // Server string
  gchar version[128];                      // Server version
} ProtocolAsdServerInfoResponse;

typedef struct PACKED
{
  gchar name[ASD_NAME_LENGTH];
  gchar device[ASD_SHORTNAME_LENGTH];
  SampleType sample_type;
  Volume volume;
  gboolean immediate_stop:1;
  gboolean chunked:1;
  guint8 queue_length;
  guint8 queue_hold;
} ProtocolAsdStreamQuery;

typedef struct PACKED
{
  gchar shortname[ASD_SHORTNAME_LENGTH];
  guint32 block_size;
} ProtocolAsdStreamResponse;

typedef struct PACKED
{
  guint16 error;
} ProtocolAsdError;

typedef struct PACKED
{
  gchar shortname[ASD_SHORTNAME_LENGTH];
} ProtocolAsdVolumeGetQuery;

typedef struct PACKED
{
  Volume volume;
} ProtocolAsdVolumeGetResponse;

typedef struct PACKED
{
  gchar shortname[ASD_SHORTNAME_LENGTH];
  Volume volume;
} ProtocolAsdVolumeSetQuery;

typedef struct PACKED
{
  gchar shortname[ASD_SHORTNAME_LENGTH];
} ProtocolAsdInfoQuery;

typedef struct PACKED
{
  gchar shortname[ASD_SHORTNAME_LENGTH];  // Shortname of the source. e.g. client5
  gchar name[ASD_NAME_LENGTH];            // Long name
  gchar type[ASD_TYPE_LENGTH];            // Short type description
  SampleType sample_type;              
  Volume volume;                       
  SourceMode mode;
  guint32 flags;
  guint32 throughput;                     // Throughput in bytes per second
  guint32 latency;                        // average latency from source to sink
  guint32 byte_counter;                   // byte counter
} ProtocolAsdInfoSourceResponse;

typedef struct PACKED
{
  gchar shortname[ASD_SHORTNAME_LENGTH];       
  gchar name[ASD_NAME_LENGTH];
  gchar type[ASD_TYPE_LENGTH];
  SampleType sample_type;
  Volume volume;
  SinkMode mode;
  guint32 flags;
  guint32 throughput;
  guint32 byte_counter;
} ProtocolAsdInfoSinkResponse;

typedef struct PACKED
{
  gchar shortname[ASD_SHORTNAME_LENGTH];
  gchar name[ASD_NAME_LENGTH];
  gchar type[ASD_TYPE_LENGTH];
} ProtocolAsdListResponse;

#define PROTOCOL_ASD_COMMAND_AUTHENTICATE 0
#define PROTOCOL_ASD_COMMAND_SERVER_VERSION 1
#define PROTOCOL_ASD_COMMAND_SERVER_INFO 2
#define PROTOCOL_ASD_COMMAND_STREAM_PLAY 3
#define PROTOCOL_ASD_COMMAND_STREAM_CAPTURE 4
#define PROTOCOL_ASD_COMMAND_STREAM_MONITOR 5
#define PROTOCOL_ASD_COMMAND_STREAM_SOURCE 6
#define PROTOCOL_ASD_COMMAND_STREAM_SINK 7
#define PROTOCOL_ASD_COMMAND_LOCK 8
#define PROTOCOL_ASD_COMMAND_UNLOCK 9
#define PROTOCOL_ASD_COMMAND_VOLUME_GET 10
#define PROTOCOL_ASD_COMMAND_VOLUME_SET 11
#define PROTOCOL_ASD_COMMAND_INFO_SOURCE 12
#define PROTOCOL_ASD_COMMAND_INFO_SINK 13
#define PROTOCOL_ASD_COMMAND_LIST_SOURCES 14
#define PROTOCOL_ASD_COMMAND_LIST_SINKS 15

#define PROTOCOL_ASD_COMMAND_ACKNOWLEDGE 100
#define PROTOCOL_ASD_COMMAND_ERROR 101

#define PROTOCOL_ASD_ERROR_SUCCESS 0
#define PROTOCOL_ASD_ERROR_VERSION_NOT_SUPPORTED 1
#define PROTOCOL_ASD_ERROR_UNKNOWN_COMMAND 2
#define PROTOCOL_ASD_ERROR_SIZE_MISMATCH 3
#define PROTOCOL_ASD_ERROR_ACCESS_DENIED 4
#define PROTOCOL_ASD_ERROR_AUTH_FAILURE 5
#define PROTOCOL_ASD_ERROR_DEVICE_NOT_FOUND 6
#define PROTOCOL_ASD_ERROR_SAMPLE_TYPE_INVALID 7
#define PROTOCOL_ASD_ERROR_SAMPLE_TYPE_NOT_SUPPORTED 8
#define PROTOCOL_ASD_ERROR_COULD_NOT_REGISTER_NAME 9

#define PROTOCOL_ASD_LOCAL_ERROR_SYSTEM 100
#define PROTOCOL_ASD_LOCAL_ERROR_BROKEN_SERVER_SPEC 101
#define PROTOCOL_ASD_LOCAL_ERROR_PROTOCOL_CORRUPT 102
#define PROTOCOL_ASD_LOCAL_ERROR_NOT_IN_CONTROL_STATE 103
#define PROTOCOL_ASD_LOCAL_ERROR_SAMPLE_TYPE_INVALID 104

#define PROTOCOL_ASD_COOKIE_SIZE 1024

#define PROTOCOL_ASD_INET_PORT 4566


#endif
