/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 11:03:43 GMT 2018
 */

package uk.ac.sanger.artemis.circular;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Color;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import org.biojava.bio.symbol.SymbolList;
import org.emboss.jemboss.JembossParams;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.io.MockFileWriter;
import org.evosuite.runtime.mock.java.io.MockPrintWriter;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.FeaturePredicate;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.circular.DNADraw;
import uk.ac.sanger.artemis.circular.Feature;
import uk.ac.sanger.artemis.circular.Track;
import uk.ac.sanger.artemis.io.BioJavaSequence;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class Track_ESTest extends Track_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Track track0 = new Track(1.01, "yChannelSelector", "## DNA Plot :: track template (created: ", false, true, false, (Entry) null);
      boolean boolean0 = track0.isShowReverse();
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertEquals("## DNA Plot :: track template (created: ", track0.getQualifier());
      assertEquals("yChannelSelector", track0.getKeyStr());
      assertFalse(boolean0);
      assertEquals(1.01, track0.getPosition(), 0.01);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Track track0 = new Track(0.0, "NEXT>", true, true, (Entry) null);
      boolean boolean0 = track0.isShowForward();
      assertTrue(boolean0);
      assertFalse(track0.isAny());
      assertTrue(track0.isNotQualifier());
      assertTrue(track0.isShowReverse());
      assertEquals(10.0F, track0.getSize(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Track track0 = new Track(0.0, "Can't pack with alphabet ", false, false, (Entry) null);
      boolean boolean0 = track0.isNotQualifier();
      assertTrue(boolean0);
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowForward());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeaturePredicate) null, (String) null);
      Entry entry0 = filteredEntryGroup0.createEntry(":");
      Track track0 = new Track(2806.8, ":", (String) null, false, false, true, entry0);
      boolean boolean0 = track0.isAny();
      assertTrue(track0.isShowReverse());
      assertFalse(boolean0);
      assertFalse(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertEquals(2806.8, track0.getPosition(), 0.01);
      assertEquals(10.0F, track0.getSize(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Track track0 = new Track((-1023.916), (Entry) null);
      track0.setQualifier("\"K@R");
      track0.getQualifier();
      assertTrue(track0.isShowReverse());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertEquals((-1023.916), track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Track track0 = new Track((-1459.39364973732), "", " bases_per_line=", false, false, false, (Entry) null);
      assertEquals(" bases_per_line=", track0.getQualifier());
      
      track0.setQualifier("");
      track0.getQualifier();
      assertEquals("", track0.getKeyStr());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Track track0 = new Track(0.25, "large", false, false, (Entry) null);
      double double0 = track0.getPosition();
      assertEquals(0.25, double0, 0.01);
      assertTrue(track0.isNotQualifier());
      assertFalse(track0.isShowReverse());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertFalse(track0.isShowForward());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Track track0 = new Track((-1.0), (Entry) null);
      track0.getKeyStr();
      assertFalse(track0.isAny());
      assertEquals((-1.0), track0.getPosition(), 0.01);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowReverse());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeaturePredicate) null, (String) null);
      Entry entry0 = filteredEntryGroup0.createEntry(":");
      Track track0 = new Track(2806.8, ":", (String) null, false, false, true, entry0);
      String string0 = track0.getKeyStr();
      assertNotNull(string0);
      assertFalse(track0.isNotQualifier());
      assertEquals(2806.8, track0.getPosition(), 0.01);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertFalse(track0.isShowForward());
      assertTrue(track0.isShowReverse());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Track track0 = new Track(2012.690998, (String) null, (String) null, true, true, true, (Entry) null);
      track0.getFeaturePredicate();
      assertTrue(track0.isAny());
      assertTrue(track0.isShowReverse());
      assertEquals(2012.690998, track0.getPosition(), 0.01);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Track track0 = new Track(1460.904672214, "Selection.fireAction () - unknown event", true, true, (Entry) null);
      track0.getEntry();
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertEquals(1460.904672214, track0.getPosition(), 0.01);
      assertTrue(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertTrue(track0.isShowReverse());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.modeVector();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      // Undeclared exception!
      try { 
        Track.writeHeader((Writer) null, dNADraw0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Track", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      MockFileWriter mockFileWriter0 = new MockFileWriter("`aDEDN',joNxvG2<A", false);
      DNADraw dNADraw0 = new DNADraw();
      mockFileWriter0.close();
      try { 
        Track.writeHeader(mockFileWriter0, dNADraw0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      Track track0 = new Track(779.3, "U+003F", false, false, entry0);
      // Undeclared exception!
      try { 
        track0.write((Writer) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Track", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Track track0 = new Track((-1269.6832497029), "# GC Skew Graph: ", false, true, (Entry) null);
      // Undeclared exception!
      try { 
        track0.setPropertiesFromTemplate("(UXN|#wGsJ/$B:A1");
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "");
      Entry entry0 = filteredEntryGroup0.createEntry("^");
      Track track0 = new Track((-1163.93974019326), entry0);
      // Undeclared exception!
      try { 
        track0.isOnTrack((uk.ac.sanger.artemis.Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeaturePredicate) null, (String) null);
      Entry entry0 = filteredEntryGroup0.createEntry(":");
      Track track0 = new Track(2806.8, ":", (String) null, false, false, true, entry0);
      boolean boolean0 = track0.isNotQualifier();
      assertTrue(track0.isShowReverse());
      assertFalse(track0.isShowForward());
      assertFalse(boolean0);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertEquals(2806.8, track0.getPosition(), 0.01);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      Track track0 = new Track((-1901.6668), entry0);
      track0.getEntry();
      assertEquals((-1901.6668), track0.getPosition(), 0.01);
      assertTrue(track0.isShowReverse());
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Track track0 = new Track(2012.690998, (String) null, (String) null, true, true, true, (Entry) null);
      boolean boolean0 = track0.isAny();
      assertTrue(track0.isShowForward());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isNotQualifier());
      assertTrue(boolean0);
      assertTrue(track0.isShowReverse());
      assertEquals(2012.690998, track0.getPosition(), 0.01);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Nonconvert");
      MockPrintWriter mockPrintWriter0 = new MockPrintWriter(mockFile0);
      DNADraw dNADraw0 = new DNADraw();
      Track.writeHeader(mockPrintWriter0, dNADraw0);
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Track track0 = new Track((-1065.54683695), "", "", false, false, false, (Entry) null);
      StringWriter stringWriter0 = new StringWriter();
      track0.write(stringWriter0);
      assertEquals("-1065.54683695\t10.0\tfalse\tfalse\tfalse\tfalse\t\t\tnull\tnull\tnull\n", stringWriter0.toString());
      assertEquals(10.0F, track0.getSize(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Track track0 = new Track((-1065.54683695), "", "", false, false, false, (Entry) null);
      Feature feature0 = new Feature("", 1, 2, 2);
      uk.ac.sanger.artemis.Feature feature1 = feature0.getArtemisFeature();
      boolean boolean0 = track0.isOnTrack(feature1);
      assertFalse(track0.isNotQualifier());
      assertFalse(track0.isShowReverse());
      assertFalse(boolean0);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals((-1065.54683695), track0.getPosition(), 0.01);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("");
      Track track0 = new Track((-1065.54683695), "", "", false, false, false, entry0);
      Feature feature0 = new Feature("", 1, 2, 2);
      uk.ac.sanger.artemis.Feature feature1 = feature0.getArtemisFeature();
      boolean boolean0 = track0.isOnTrack(feature1);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertFalse(track0.isShowReverse());
      assertFalse(boolean0);
      assertFalse(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertEquals((-1065.54683695), track0.getPosition(), 0.01);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      Track track0 = new Track(2012.690998, (String) null, (String) null, true, true, true, (Entry) null);
      boolean boolean0 = track0.isShowReverse();
      assertTrue(boolean0);
      assertTrue(track0.isShowForward());
      assertTrue(track0.isAny());
      assertEquals(2012.690998, track0.getPosition(), 0.01);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isNotQualifier());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Track track0 = new Track((-1065.54683695), "", "", false, false, false, (Entry) null);
      track0.setColour((Color) null);
      assertFalse(track0.isNotQualifier());
      assertFalse(track0.isShowForward());
      assertFalse(track0.isShowReverse());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertEquals((-1065.54683695), track0.getPosition(), 0.01);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Track track0 = new Track(0.0, "%", "%", false, false, false, (Entry) null);
      float float0 = track0.getSize();
      assertEquals(10.0F, float0, 0.01F);
      assertFalse(track0.isShowReverse());
      assertFalse(track0.isAny());
      assertFalse(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Track track0 = new Track(1460.904672214, "Selection.fireAction () - unknown event", true, true, (Entry) null);
      track0.setShowForward(true);
      assertTrue(track0.isShowReverse());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isNotQualifier());
      assertFalse(track0.isAny());
      assertEquals(1460.904672214, track0.getPosition(), 0.01);
      assertTrue(track0.isShowForward());
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      Track track0 = new Track(2012.690998, (String) null, (String) null, true, true, true, (Entry) null);
      track0.setKeyStr((String) null);
      assertTrue(track0.isAny());
      assertTrue(track0.isShowReverse());
      assertEquals(2012.690998, track0.getPosition(), 0.01);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      Track track0 = new Track(2012.690998, (String) null, (String) null, true, true, true, (Entry) null);
      track0.setQualifierValue(")\n");
      track0.getQualifierValue();
      assertTrue(track0.isShowReverse());
      assertEquals(2012.690998, track0.getPosition(), 0.01);
      assertTrue(track0.isAny());
      assertTrue(track0.isNotQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isShowForward());
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeaturePredicate) null, (String) null);
      Entry entry0 = filteredEntryGroup0.createEntry(":");
      Track track0 = new Track(2806.8, ":", (String) null, false, false, true, entry0);
      track0.setShowReverse(true);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertTrue(track0.isShowReverse());
      assertFalse(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertEquals(2806.8, track0.getPosition(), 0.01);
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      Track track0 = new Track(2012.690998, (String) null, (String) null, true, true, true, (Entry) null);
      track0.getColour();
      assertTrue(track0.isShowReverse());
      assertEquals(2012.690998, track0.getPosition(), 0.01);
      assertTrue(track0.isAny());
      assertTrue(track0.isShowForward());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isNotQualifier());
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      Track track0 = new Track(2012.690998, (String) null, (String) null, true, true, true, (Entry) null);
      track0.getQualifierValue();
      assertTrue(track0.isShowForward());
      assertTrue(track0.isNotQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isShowReverse());
      assertEquals(2012.690998, track0.getPosition(), 0.01);
      assertTrue(track0.isAny());
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      Track track0 = new Track((-1901.6668), entry0);
      track0.setSize(0.578F);
      assertEquals(0.578F, track0.getSize(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("");
      Track track0 = new Track((-1065.54683695), "", "", false, false, false, entry0);
      track0.getKeyStr();
      assertFalse(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertEquals((-1065.54683695), track0.getPosition(), 0.01);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertFalse(track0.isShowReverse());
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("");
      Track track0 = new Track((-1065.54683695), "", "", false, false, false, entry0);
      assertEquals((-1065.54683695), track0.getPosition(), 0.01);
      
      track0.setPosition(0.0);
      track0.getPosition();
      assertEquals(10.0F, track0.getSize(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("");
      Track track0 = new Track((-1065.54683695), "", "", false, false, false, entry0);
      double double0 = track0.getPosition();
      assertFalse(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertEquals((-1065.54683695), double0, 0.01);
      assertFalse(track0.isShowReverse());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeaturePredicate) null, (String) null);
      Entry entry0 = filteredEntryGroup0.createEntry(":");
      Track track0 = new Track(2806.8, ":", (String) null, false, false, true, entry0);
      FeaturePredicate featurePredicate0 = track0.getFeaturePredicate();
      track0.setFeaturePredicate(featurePredicate0);
      assertTrue(track0.isShowReverse());
      assertFalse(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertEquals(2806.8, track0.getPosition(), 0.01);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("");
      Track track0 = new Track((-1065.54683695), "", "", false, false, false, entry0);
      track0.setEntry(entry0);
      assertFalse(track0.isAny());
      assertFalse(track0.isShowReverse());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals((-1065.54683695), track0.getPosition(), 0.01);
      assertFalse(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      Track track0 = new Track(779.3, "U+003F", false, false, entry0);
      assertTrue(track0.isNotQualifier());
      
      track0.setNotQualifier(false);
      assertFalse(track0.isNotQualifier());
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      Track track0 = new Track(2012.690998, (String) null, (String) null, true, true, true, (Entry) null);
      boolean boolean0 = track0.isOnTrack((uk.ac.sanger.artemis.Feature) null);
      assertTrue(track0.isAny());
      assertTrue(boolean0);
      assertTrue(track0.isShowReverse());
      assertEquals(2012.690998, track0.getPosition(), 0.01);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      Track track0 = new Track((-1901.6668), entry0);
      track0.getQualifier();
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertEquals((-1901.6668), track0.getPosition(), 0.01);
      assertTrue(track0.isShowReverse());
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence((SymbolList) null);
      Bases bases0 = new Bases(bioJavaSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry();
      Track track0 = new Track((-2388.73726), "", false, false, entry0);
      track0.isShowForward();
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      Track track0 = new Track(0.0, "Can't pack with alphabet ", false, false, (Entry) null);
      track0.setAny(false);
      assertFalse(track0.isShowReverse());
      assertTrue(track0.isNotQualifier());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isShowForward());
  }
}
