/*
   ArrayUtil, program to check and configure a SmartArray controller
   Copyright (C) 1999  Hugo Trippaers

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
   $Header: /home/cvs/cvsroot/array-util/utils.c,v 1.2 2001/08/29 21:51:53 spark Exp $
 */


#include <gtk/gtk.h>

GtkWidget *
mygtk_tree_item_with_label_and_pixmap (char *labeltxt,
				       GdkPixmap * pm,
				       GdkBitmap * bm)
{
  GtkWidget *hbox;
  GtkWidget *pixmap;
  GtkWidget *label;
  GtkWidget *treeitem;

  hbox = gtk_hbox_new (FALSE, 0);
  pixmap = gtk_pixmap_new (pm, bm);
  gtk_box_pack_start (GTK_BOX (hbox), pixmap, FALSE, FALSE, 0);
  gtk_widget_show (pixmap);
  label = gtk_label_new (labeltxt);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  treeitem = gtk_tree_item_new ();
  gtk_container_add (GTK_CONTAINER (treeitem), hbox);

  gtk_widget_show (hbox);

  return treeitem;
}

GtkWidget*
lookup_widget (GtkWidget *widget, const gchar *widget_name)
{
  GtkWidget *parent, *found_widget;

  for (;;)
    {
      if (GTK_IS_MENU (widget))
        parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
      else
        parent = widget->parent;
      if (parent == NULL)
        break;
      widget = parent;
    }

  found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
                                                   widget_name);
  if (!found_widget)
    g_warning ("Widget not found: %s", widget_name);
  return found_widget;
}

