/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "gAIBase.h"
#include "eGrid.h"
#include "eGameObject.h"
//#include "eTess.h"
#include "gWall.h"
#include "gSensor.h"
#include "tConsole.h"
#include "rScreen.h"
#include <stdlib.h>


//#define DEBUG

// which eWall is detected?

REAL gAIPlayer::Think(){
  //  return 1;
	
  // first, find close eWalls and evade them.

  eCoord dir=object->Direction();
  REAL speed=object->speed;
  gSensor front(object,object->Position(),dir);
  gSensor left(object,object->Position(),dir.Turn(eCoord(0,1)));
  gSensor right(object,object->Position(),dir.Turn(eCoord(0,-1)));
  
  REAL range=speed;

  front.detect(range);
  left.detect(range);
  right.detect(range);

  REAL fs=front.hit;
  REAL ls=left.hit;
  REAL rs=right.hit;

  if (left.type==gSENSOR_RIM)
    fs/=2;
  if (right.type==gSENSOR_RIM)
    fs/=2;
  //ls=rs=10;

  REAL lr;   // turn left or right?
  REAL turn; // turn at all?

  lr=REAL(front.lr);

  /*
  if (front.type!=gSENSOR_NONE){
    switch (front.type){
    case gSENSOR_SELF:
      con << "Own line ahead! Direction " << front.lr ;
      break;
    case gSENSOR_ENEMY:
      con << "Enemy line ahead! Direction " << front.lr;
      break;
    case gSENSOR_TEAMMATE:
      con << "Team line ahead! Direction " << front.lr;
      break;
    case gSENSOR_RIM:
      con << "Rim ahead";
      break;
    default:
      break;
    }
    con << " ,distance=" << front.hit << ".\n";
  }
  */

  if (front.type==gSENSOR_SELF) // NEVER close yourself in.
    lr*=-100; 

          // consider
  lr+=ls; // space to the left
  lr-=rs; // space to the right

  REAL tl=ls-fs;
  REAL tr=rs-fs;
  if (tl<0) tl=0;
  if (tr<0) tr=0;

  turn=tl+tr+1/fs;
  turn +=REAL(fabs(lr)/(range*.7));

  // then, consider the other players.

  REAL ed=100; //the distance to the enemy

    
  if (!target || !target->Alive()){
    eCoord enemypos=eCoord(1000,100);

    const List<eGameObject>& gameObjects = object->Grid()->GameObjects();
    
    // find the closest enemy
    for (int i=gameObjects.Len()-1;i>=0;i--){
      eGameObject *other=gameObjects(i);
      if (dynamic_cast<gCycle *>(other) && other->team!=object->team){
	// then, enemy is realy an enemy
	eCoord otherpos=other->Position()-object->Position();
	if (otherpos.Norm_squared()<enemypos.Norm_squared()){
	  // check if the path is clear
	  gSensor p(object,object->Position(),otherpos);
	  p.detect(REAL(.98));
	  if (p.hit>=.98){
	    enemypos=otherpos;
	    target=dynamic_cast<gCycle *>(other);
	  }
	}
      }
    }
  }
  
  if(turn<.5 && target){
  

    const REAL fear=REAL(.1);
    const REAL caution=1;
    const REAL evasive=100;
    const REAL attack=1;
    const REAL seek=REAL(.1);
    const REAL trap=REAL(.1);
    const REAL ffar=20;
    //    const REAL close=1000;
    
    REAL random=10*(rand()/float(RAND_MAX))*(rand()/float(RAND_MAX));

    if (target && target->Alive()){
      eCoord enemypos=target->Position()-object->Position();
      eCoord enemydir=target->Direction();
      REAL enemyspeed=target->speed;
      
      ed=REAL(fabs(enemypos.x)+fabs(enemypos.y));
      ed/=enemyspeed;
      
      // transform coordinates relative to us:
      enemypos=enemypos.Turn(dir.Conj()).Turn(0,1);
      enemydir=enemydir.Turn(dir.Conj()).Turn(0,1);
      
      // now we are at the center of the coordinate system facing
      // in direction (0,1).
      
      // rules are symmetrical: exploit that.
      int side=1;
      if (enemypos.x<0){
	side*=-1;
	enemypos.x*=-1;
	enemydir.x*=-1;
	Swap(ls,rs);
      }
      // now we can even assume the enemy is on our right side.

      // consider his ping and our reaction time
#define REACTION .2


      //REAL enemyspeed=target->speed;
      REAL ourspeed=object->speed;

      REAL enemydist=target->Lag()*enemyspeed;

      // redo the prediction
#ifndef DEDICATED
      if (sn_GetNetState()==nCLIENT && !sr_predictObjects)
#endif
	enemypos=enemypos-enemydir*enemydist;
      enemydist+=2*REACTION *enemyspeed;
      
      REAL ourdist=REACTION*ourspeed;;
      

      // now we consider the worst case: we drive straight on,
      enemypos.y-=ourdist;
      // while the enemy cuts us: he goes in front of us
      REAL forward=-enemypos.y+.01;
      if (forward<0) // no need to go to much ahead
	forward=0;
      if (forward>enemydist)
	forward=enemydist;

      enemypos.y+=forward;
      enemydist-=forward;

      // and then he turns left.
      enemypos.x-=enemydist;

      if (enemypos.y*enemyspeed>enemypos.x*ourspeed){ // he is right ahead of us.
	if (random<fear){ // evade him
#ifdef DEBUG
	  con << "fear!\n";
#endif
	  turn+=1;
	  lr+=side;
	}
	if (enemypos.y<=ffar &&
	    ((enemydir.x<0 && random<evasive) ||
	     (enemydir.y>0 && random<caution) ||
	     (enemydir.y<0 && random<attack))){
#ifdef DEBUG
	  con << "caution!\n";
#endif
	  turn+=1;
	  lr+=side;
	}
      }
      else if (enemypos.y*ourspeed<-enemypos.x*enemyspeed){
	/*
	// good attack position
	if (enemypos.x<rs && rs < range*.99){
#ifdef DEBUG
	  con << "BOX!\n";
#endif
	  turn+=10;
	  lr-=side;
	}

	*/
	if (random<attack){
#ifdef DEBUG
	  con << "attack!\n";
#endif
	  turn+=1;
	  lr-=side;
	}
      }
      else if(enemypos.x>ffar*4){
	if(random<seek){
#ifdef DEBUG
	  con << "seek!\n";
#endif
	  turn+=1;
	  lr-=side;
	}
      }
      else if (enemypos.x<ffar*2 && fabs(enemypos.y)<ffar){
	if(random<trap){
#ifdef DEBUG
	  con << "trap!\n";
#endif
	  turn+=1;
	  lr+=side;
	}
      }
    }
  }
    
  if (turn>=1){
    if (lr>0)
      object->Turn(-1);
    else if(lr<0)
      object->Turn(1);
    else{
      if (rand()%2)
	object->Turn(1);
      else
	object->Turn(-1);
    }
  }
  
  
  REAL mindist=fs;
  if (ls<mindist)
    mindist=ls;
  if (rs<mindist)
    mindist=rs;
  mindist/=object->speed;
  if (target && target->Alive() && ed<mindist)
    mindist=ed;
  return REAL(.8*mindist);
}


const REAL relax=5;

void gAIPlayer::Timestep(REAL time){
  REAL ts=time-lastTime;
  lastTime=time;

  concentration+=ts/relax;
  concentration=concentration/(1+ts/relax);

  if (bool(object) && object->Alive() && nextTime<time){
    REAL nextthought=Think();
    if (nextthought>.9) nextthought=REAL(.9);

    if (nextthought<REAL(.6-concentration)) nextthought=REAL(.6-concentration);

    nextTime=nextTime+nextthought;

    //con << concentration << "\t" << nextthought << '\t' << ts << '\n';

    if(.1+4*nextthought<1)
      concentration*=REAL(.1+4*nextthought);
  }

  
  
}



