/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "tMemManager.h"
#include "tInitExit.h"
#include "nSimulatePing.h"
#include "nConfig.h"
#include "nNetwork.h"
#include "tConsole.h"
#include "nNet.h"
#include "tSysTime.h"
#include <assert.h>
#include <stdlib.h>
#include <fstream.h>

#ifndef WIN32
#include  <netinet/in.h>
#else
#include  <windows.h>
/*
#ifndef DEDICATED
#include <SDL/SDL.h>
#endif
*/
#endif

// #define NO_ACK

tString sn_bigBrotherString;
tString sn_greeting[4];
tString sn_programVersion="UNKNOWN";

bool big_brother=true;
static tConfItem<bool> fs_bb("BIG_BROTHER","Did we already send the big brother information?",big_brother);


int sn_defaultDelay=10000;

int sn_maxRateIn=4; // maximum data rate in kb/s
int sn_maxRateOut=4; // maximum output data rate in kb/s

//tArray<unsigned short> send_buffer[MAXCLIENTS+2];
//REAL planned_rate_control[MAXCLIENTS+2];
//REAL rate_control[MAXCLIENTS+2];
//unsigned short  rate[MAXCLIENTS+2];

// from gGame.C
//extern unsigned short client_gamestate[MAXCLIENTS+2];

bool deb_net=false;

static REAL maxTimeout=1;  // the maximal timeout in seconds
static REAL minTimeout=.01;  // the minimal timeout in seconds
static REAL pingTimeout=2; // the normal timeout in multiples of the ping
static REAL zeroTimeout=.01; // additional timeout

#ifndef DEBUG
static REAL killTimeout=30;
#else
static REAL killTimeout=30;
#endif

static bool send_again_warn=false;

#ifdef DEBUG
static int simulate_loss=0;
#else
//static int simulate_loss=0;
#endif

int sn_maxNoAck=100; // the maximum number of not ack messages
                     // before more are send 

//int sn_ackPending[MAXCLIENTS+2];
// int sn_ackAckPending[MAXCLIENTS+2];

//static nMessage * ack_mess[MAXCLIENTS+2];

static nNetState current_state;
//int sn_sockets[MAXCLIENTS+2];  // server mode:
// elements 1...MAXCLIENTS are the incoming connections,
// client mode: element 0 connects to the server.
// element MAXCLIENTS+1: currently logging in

nConnectionInfo sn_Connections[MAXCLIENTS+2];

static sockaddr peers[MAXCLIENTS+2]; // the same logic for the peer adresses.
static int timeouts[MAXCLIENTS+2];

#define ACKBACK 1000
static unsigned short lastacks[MAXCLIENTS+2][ACKBACK];
static unsigned short lastackPos[MAXCLIENTS+2];
static unsigned short highest_ack[MAXCLIENTS+2];

// REAL sn_ping[MAXCLIENTS+2];

static void reset_last_acks(int i){
  for(int j=ACKBACK-1;j>=0;j--)
    lastacks[i][j]=0;
  lastackPos[i]=0;
  highest_ack[i]=0;
}


//#ifndef DEBUG
int maxclients=MAXCLIENTS;
//#else
//int maxclients=1;
//#endif

int sn_myNetID=0; // our network identification:  0: server
 //                                            1..MAXCLIENTS: client

#define IDS_RESERVED 16		 // number of message IDs reserved for special purposes: id 0 is reserved for no-ack messages.
unsigned short current_id=1; // current running network number


// the classes that are responsible for the queuing of network send tEvents:
class planned_send:public tHeapElement{
protected:
  int peer;
public:
  planned_send(REAL priority,int peer);
  ~planned_send();

  virtual tHeapBase *Heap(); // in wich heap are we?
  
  // change our priority:
  void add_to_priority(REAL diff);

  // what is to be done if the sceduled tEvent is executed?
  virtual void execute()=0;
};

class nMessage_planned_send:public planned_send{
  tCONTROLLED_PTR(nMessage) m;
  bool ack;
public:
  nMessage_planned_send(nMessage *m,REAL priority,bool ack,int peer);
  ~nMessage_planned_send();

  virtual void execute();
};

// *************************************************************

unsigned short nDescriptor::s_nextID(1);

#define MAXDESCRIPTORS 100
static nDescriptor* descriptors[MAXDESCRIPTORS];

static nDescriptor* nDescriptor_anchor;

nDescriptor::nDescriptor(unsigned short identification,
			     nHandler *handle,const char *Name)
  :tListItem<nDescriptor>(nDescriptor_anchor),
  id(identification),handler(handle),name(Name)
{
#ifdef DEBUG
#ifdef LINUX
  con << "Descriptor " << id << ": " << name << '\n';
#endif
#endif
  if (MAXDESCRIPTORS<=id || descriptors[id]!=NULL){
    con << "Descriptor " << id << " already used!\n";
    exit(-1);
  }
  s_nextID=id+1;
  descriptors[id]=this;
}

/*
nDescriptor::nDescriptor(nHandler *handle,const char *Name)
  :id(s_nextID++),handler(handle),name(Name)
{
#ifdef DEBUG
  con << "Descriptor " << id << ": " << name << '\n';
#endif

  if (descriptors.Len()>id && descriptors[id]!=NULL){
    con << "Descriptor " << id << " already used!\n";
    exit(-1);
  }
  descriptors[id]=this;
}
*/

void nDescriptor::HandleMessage(nMessage &message){
  static tArray<bool> warned;

#ifdef DEBUG_X
  if (message.descriptor>1)
    con << "RMT " << message.descriptor << "\n";
#endif

#ifndef NOEXCEPT
  try{
#endif
    nDescriptor *nd=descriptors[message.descriptor];
    if (nd){
      nd->handler(message);
    }
    else
      if (!warned[message.Descriptor()]){
	con << "\n\n\ngot unknown nMessage with descriptor id " 
	    << message.Descriptor()
	    << "\n\nYOU SHOULD PROBABLY UPGRADE ARMAGETRON!!!!\n";
	warned[message.Descriptor()]=true;
      }
#ifndef NOEXCEPT
  }
  catch(nKillHim){
    con << "Network error. ";
    sn_KillUser(message.SenderID());
  }
 
#endif
}



// *************************************************************


void ack_handler(nMessage &m){
  while (!m.End()){
    unsigned short ack;
    m.Read(ack);
    //con << "Got ack:" << ack << ":" << m.SenderID() << '\n';
    nWaitForAck::Ackt(ack,m.SenderID());
  }
}

nDescriptor acknowleEdge(1,ack_handler,"ack");


class nWaitForAck;
static List<nWaitForAck> sn_pendingAcks;

//static eTimer netTimer;
static REAL netTime;

#ifdef NET_DEBUG
static int acks=0;
static int max_acks=0;
#endif

nWaitForAck::nWaitForAck(nMessage* m,int rec)
  :id(-1),message(m),receiver(rec){

  if (!message)
    tERR_ERROR("Null ack!");

  if (message->Descriptor()!=acknowleEdge.ID())
    sn_Connections[receiver].ackPending++;
  else
	assert(false);
//    sn_ackAckPending[receiver]++;
#ifdef NET_DEBUG
  acks++;
#endif

  timeFirstSent=::netTime;
  timeLastSent=::netTime;
  
  timeouts=0;

  REAL timeout=sn_Connections[rec].ping*pingTimeout;
  if (timeout<minTimeout) timeout=minTimeout;
  if (timeout>maxTimeout) timeout=maxTimeout;
  
#ifdef nSIMULATE_PING
  timeSendAgain=::netTime + nSIMULATE_PING; 
#ifndef WIN32
  timeSendAgain+=(nSIMULATE_PING_VARIANT*random())/RAND_MAX;
#endif
#else
  timeSendAgain=::netTime + timeout+zeroTimeout; 
#endif
  sn_pendingAcks.Add(this,id);
  //message->AddRef();
}

nWaitForAck::~nWaitForAck(){
#ifdef NET_DEBUG
  acks--;
  if (acks>max_acks){
    max_acks=acks;
    // con << "MA=" << max_acks << '\n';
  }
#endif

  if (bool(message) && message->Descriptor()!=acknowleEdge.ID())
    sn_Connections[receiver].ackPending--;
  else
	assert(false);
//    sn_ackAckPending[receiver]--;
    
  // message.Release();

  sn_pendingAcks.Remove(this,id);
  tCHECK_DEST;
}

void nWaitForAck::Ackt(unsigned short id,unsigned short peer){
  int success=0;
  for(int i=sn_pendingAcks.Len()-1;i>=0;i--){
    if (sn_pendingAcks(i)->message->messageID==id &&
	sn_pendingAcks(i)->receiver==peer){
      success=1;

#ifdef DEBUG_X
      if (sn_pendingAcks(i)->message->descriptor>1)
	con << "AT  " << sn_pendingAcks(i)->message->descriptor << '\n';
#endif

      // calculate ping
#define PING_AVG 6.0
      REAL ping_avg=PING_AVG;
      REAL thisping=netTime-sn_pendingAcks(i)->timeFirstSent;


      /*
      if (sn_pendingAcks(i]->timeouts) // if we had packet loss,
	ping_avg*=3+sn_pendingAcks(i]->timeouts; // be a little less strict

      if (thisping<sn_ping[peer]*.7) // be more strict if we
	ping_avg/=4;
      if (thisping<sn_ping[peer]*.5) // massively loose ping
	ping_avg/=4;

      */
      if (thisping>sn_Connections[peer].ping*2.5)
	ping_avg*=100;

      /*
      if (netTime-sn_pendingAcks(i]->timeouts)
	ping_avg*=100;
      */

      sn_Connections[peer].ping+=thisping/ping_avg;  // make some average
      sn_Connections[peer].ping/=(1+1/ping_avg);

      sn_pendingAcks(i)->AckExtraAction();
      delete sn_pendingAcks(i);
      ::timeouts[peer]=0;
      if (i<sn_pendingAcks.Len()-1) i++;
    }
  }

#ifdef DEBUG
  /*
  if (!success && peer!=MAXCLIENTS+1){
    con << "Ack " << id << ':' << peer << " was not asked for.\n";
    if (sn_pendingAcks.Len()) con << "Expected:\n";
    for(int i=sn_pendingAcks.Len()-1;i>=0;i--){
      con << i << "\t:" 
	  << sn_pendingAcks(i]->message->messageID << ":"
	  << sn_pendingAcks(i]->receiver << '\n';
    }
    } */
#endif
}

void nWaitForAck::AckAllPeer(unsigned short peer){
  for(int i=sn_pendingAcks.Len()-1;i>=0;i--){
    if (sn_pendingAcks(i)->receiver==peer){
      delete sn_pendingAcks(i);
      if (i<sn_pendingAcks.Len()-1) i++;
    }
  }
}

void nWaitForAck::Resend(){
  for(int i=sn_pendingAcks.Len()-1;i>=0;i--){
	nWaitForAck* pendingAck = sn_pendingAcks(i);

    if (pendingAck->timeSendAgain<=netTime){	     
      //con << net_ticks-sn_pendingAcks[i]->ticks_first_sent << '\n';

	  // update timeout counters
      ::timeouts[pendingAck->receiver]++;
      pendingAck->timeouts++;

      if(netTime - pendingAck->timeFirstSent  >  killTimeout &&
	 ::timeouts[pendingAck->receiver] > 100){
	// total timeout. Kill connection.
	if (pendingAck->receiver<=MAXCLIENTS){
	  con << "User " << pendingAck->receiver 
	       << " timed out.\n";
	  sn_KillUser(pendingAck->receiver);

	  if (i>=sn_pendingAcks.Len())
	    i=sn_pendingAcks.Len()-1; 
	}
	else // it is just in the login slot. Ignore it.
	  delete pendingAck;
      }
      else{
	
	if (sn_Connections[pendingAck->receiver].socket > 0){
//	  if(sn_Connections[].rateControlPlanned[pendingAck->receiver]>-1000)
	  {
	    REAL timeout=sn_Connections[pendingAck->receiver].ping*pingTimeout;
	    if (timeout<minTimeout) timeout=minTimeout;
	    if (timeout>maxTimeout) timeout=maxTimeout;
	
		timeout *= pendingAck->timeouts;
		    
	    pendingAck->timeSendAgain=netTime+timeout;
	    pendingAck->timeLastSent=netTime;
	    
	    if (send_again_warn){
	      con << "sending packet again: " ;
	      deb_net=true;
	    }
	    pendingAck->message->SendImmediately
	      (pendingAck->receiver,false);
	    deb_net=false;
	  }
	}
	else
	  delete pendingAck;
      }
    }
  }
}

 
// defined in netobjec.C
void ClearKnows(int user);


#ifdef NET_DEBUG
static int nMessages=0;
static int max_nMessages=0;
#endif


void nMessage::AddRef(){
#ifdef DEBUG_X
  if (descriptor>1)
    con << "+T  " << descriptor << "\n";
#endif  

  refCtr++;
}

void nMessage::Release(){refCtr--;
#ifdef DEBUG_X
 if (descriptor>1)
   con << "-T  " << descriptor << "\n";
#endif

 if (refCtr==0)
   delete this;
}

nMessage::nMessage(unsigned short*& buffer,short sn_myNetID)
  :refCtr(0),descriptor(ntohs(*(buffer++))),messageID(ntohs(*(buffer++))),
   senderID(sn_myNetID),readOut(0){
#ifdef NET_DEBUG
  nMessages++;
#endif
  unsigned short len=ntohs(*(buffer++));
  for(int i=0;i<len;i++)
    data[i]=ntohs(*(buffer++));
}

nMessage::nMessage(const nDescriptor &d)
:refCtr(0),descriptor(d.id),
senderID(::sn_myNetID), readOut(0){
#ifdef NET_DEBUG
  nMessages++;
#endif

 current_id++;
 if (current_id <= IDS_RESERVED)
  current_id = IDS_RESERVED + 1;

 messageID = current_id;
}


nMessage::~nMessage(){
#ifdef NET_DEBUG
  nMessages--;
  if (nMessages>max_nMessages){
    max_nMessages=nMessages;
    con << "MN=" << max_nMessages <<'\n';
  }
#endif

#ifdef DEBUG_X
  if (descriptor>1)
    con << "DMT " << descriptor << "\n";
#endif

  if (refCtr>0)
     con << "Warning! Deleting used nMessage!\n";
  tCHECK_DEST;
}




void nMessage::BroadCast(bool ack){
  AddRef();
  if (sn_GetNetState()==nCLIENT)
    Send(0,ack);
  
  if (sn_GetNetState()==nSERVER){
    for(int i=MAXCLIENTS;i>0;i--){
      if (sn_Connections[i].socket>0)
	Send(i,ack);
    }
  }
  Release();
}


void nMessage::operator << (const tString &s){
  unsigned short len=s.Len();
  Write(len);
  for(int i=0;i<len;i+=2)
    Write(s[i]+(s[i+1] << 8));
}

void nMessage::operator >> (tString &s){
  s.Clear();
  unsigned short w,len;
  Read(len);
  for(int i=0;i<len;i+=2){
    Read(w);
    s[i]=w & 255;
    if (i+1<len)
      s[i+1]=(w-s[i]) >> 8;
  }
}

#define MANT 26
#define EXP (32-MANT)
#define MS (MANT-1)


typedef struct{
  int mant:MANT;
  unsigned int exp:EXP;
} myfloat;


void nMessage::operator<<(const REAL &x){


#ifdef DEBUG
  // con << "write x= " << x;


  if(sizeof(myfloat)!=sizeof(int))
    tERR_ERROR_INT("floating ePoint format does not work!");
#endif
  /*
  REAL nachkomma=x-floor(x);
  Write(short(x-nachkomma));
  Write(60000*nachkomma);
  */
  // no fuss. Read and write floats in binary format.
  // will likely cause problems for systems other than i386.

  //Write(((short *)&x)[0]);
  //Write(((short *)&x)[1]);

  // right. Caused severe problems with the AIX port.

  // new way: own floating ePoint format that is not good with small numbers
  // (we do not need them anyway)
  REAL y=x;

  unsigned int negative=0;
  if (y<0){
    y=-y;
    negative=1;
  }

  unsigned int exp=0;
  while (fabs(y)>=64){
    exp +=6;
    y/=64;
  }
  while (fabs(y)>=1){
    exp++;
    y/=2;
  }
  // now x=y*2^exp
  unsigned int mant=int(y*(1<<MS));
  // now x=mant*2^exp * (1/ (1<<MANT))

  // cutoffs:
  if (mant<0)
    mant=0;
  if (mant>((1<<MS))-1)
    mant=(1<<MS)-1;
  
  if (exp>(1<<EXP)-1){
    exp=(1<<EXP)-1;
    if (mant>0)
      mant=(1<<MS)-1;
  }

  // put them together:

  unsigned int trans=(mant & ((1<<MS)-1)) | (negative << MS) | (exp << MANT);
  /*
  myfloat trans;
  trans.exp=exp;
  trans.mant=mant;
  */

  operator<<(reinterpret_cast<int &>(trans));
  
#ifdef DEBUG
  /*
  con << "mant: " << mant
     << ", exp: " << exp
     << ", negative: " << negative;
  */

  unsigned int mant2=trans & ((1 << MS)-1);
  unsigned int negative2=(trans >> MS) & 1;
  unsigned int nt=trans-mant-(negative << MS);
  unsigned int exp2=nt >> MANT;

  if (mant2!=mant || negative2!=negative || exp2!=exp)
    tERR_ERROR_INT("Floating ePoint tranfer failure!");

  /*
  con << ", x: " << x;

  con << ", mant: " << mant
     << ", exp: " << exp
     << ", negative: " << negative;
  */

  // check:

  REAL z=REAL(mant)/(1<<MS);
  if (negative)
    z=-z;

  while (exp>=6){
    exp-=6;
    z*=64;
  }
  while (exp>0){
    exp--;
    z*=2;
  }

  if (fabs(z-x)>(fabs(x)+1)*.001)
    tERR_ERROR_INT("Floating ePoint tranfer failure!");
    
  //con << ", z: " << z << '\n';
#endif
}

void nMessage::operator>>(REAL &x){
  /*
  short vorkomma;
  unsigned short nachkomma;
  Read((unsigned short &)vorkomma);
  Read(nachkomma);
  x=vorkomma+nachkomma/60000.0;
  
  Read(((unsigned short *)&x)[0]);
  Read(((unsigned short *)&x)[1]);
  */

  unsigned int trans;
  operator>>(reinterpret_cast<int &>(trans));

  int mant=trans & ((1 << MS)-1);
  unsigned int negative=(trans >> MS) & 1;
  unsigned int exp=(trans-mant-(negative << MS)) >> MANT;

  x=REAL(mant)/(1<<MS);
  if (negative)
    x=-x;

#ifdef DEBUG
  //  con << "read mant: " <<mant << ", exp: " << exp;
#endif

  while (exp>=6){
    exp-=6;
    x*=64;
  }
  while (exp>0){
    exp--;
    x*=2;
  }

#ifdef DEBUG
#ifndef WIN32
  if (!finite(x))
    st_Breakpoint();
  // con << " , x= " << x << '\n';
#endif
#endif
}

void nMessage::operator<< (const short &x){
  Write((reinterpret_cast<const short *>(&x))[0]);
}

void nMessage::operator>> (short &x){
  Read(reinterpret_cast<unsigned short *>(&x)[0]);
}

void nMessage::operator<< (const int &x){
  unsigned short a=x & (0xFFFF);
  short b=(x-a) >> 16;

  Write(a);
  operator<<(b);
}
void nMessage::operator>> (int &x){
  unsigned short a;
  short b;
  
  Read(a);
  operator>>(b);

  x=(b << 16)+a;
}

void nMessage::operator<< (const bool &x){
  if (x)
    Write(1);
  else
    Write(0);
}

void nMessage::operator>> (bool &x){
  unsigned short y;
  Read(y);
  x= (y!=0);
}


void nMessage::Read(unsigned short &x){
  if (End()){
    con << "User "<<senderID<< "'s message was too short. Killing him.\n";
    sn_KillUser(senderID);
    nReadError();
  }
  else
    x=data(readOut++);
}


// **********************************************
//  Basic communication classes: login
// **********************************************

static bool login_failed=false;
static bool login_succeeded=false;

static nHandler *real_req_info_handler=NULL;

void req_info_handler(nMessage &m){
  if (real_req_info_handler)
    (*real_req_info_handler)(m);
  if (m.SenderID()==MAXCLIENTS+1)
    sn_KillUser(MAXCLIENTS+1);
}

static nDescriptor req_info(2,req_info_handler,"req_info");

void RequestInfoHandler(nHandler *handle){
  real_req_info_handler=handle;
}


void login_deny_handler(nMessage &m){
  if (!login_failed)
    con << "Got login denial..\n";
  if (sn_GetNetState()!=nSERVER){
    login_failed=true;
    login_succeeded=false;
    sn_SetNetState(nSTANDALONE);
  }
}

static nDescriptor login_deny(3,login_deny_handler,"login_deny");

extern nDescriptor logout,login;

void login_ignore_handler(nMessage &m){
  if (sn_GetNetState()!=nSERVER && !login_succeeded){
    /*
    login_failed=true;
    login_succeeded=false;

    // kicking the one who uses our place
    // (he is probably timing out anyway..)
    nMessage *lo=new nMessage(logout);
    lo->Write((unsigned short)sn_myNetID);
    lo->Send(0);

    sn_Sync(10);
    
    (new nMessage(login))->Send(0);
    */
  }

  
}

static nDescriptor login_ignore(4,login_ignore_handler,"login_ignore");


void first_fill_ids();

void login_accept_handler(nMessage &m){
   if (sn_GetNetState()!=nSERVER){
     login_succeeded=true;
     unsigned short id=0;
     m.Read(id);
     sn_myNetID=id;
     
     first_fill_ids();
   }
}

static nDescriptor login_accept(5,login_accept_handler,"login_accept");



static unsigned short new_id=0;





void login_handler(nMessage &m){
   bool success=false;
   
   if (m.SenderID()!=MAXCLIENTS+1){
     //con << "Ignoring second login from " << m.SenderID() << ".\n";
     (new nMessage(login_ignore))->Send(m.SenderID());
   }
   else if (sn_Connections[m.SenderID()].socket>0) 
     {
      con << "Received login from "
	  << ANET_AddrToString(&peers[m.SenderID()]) << ".\n";

      for(int i=1;!success && i<=maxclients;i++)
	if(sn_Connections[i].socket<=0){
	  
	  sn_Connections[i].socket=sn_Connections[MAXCLIENTS+1].socket; // the new connection has number MC+1
	  peers[i]=peers[MAXCLIENTS+1];
	  timeouts[i]=0;
	  //sn_Connections[].socket[MAXCLIENTS+1]=-1;
	  success=true;
	  new_id=i;
	  sn_Connections[MAXCLIENTS+1].socket=-1;
	  peers[MAXCLIENTS+1].sa_family=0;
	  nCallbackLoginLogout::UserLoggedIn(i);
	}
   }
   if (success){
      con << "New user: " << new_id << '\n';
      tString s;
      s << "User " << new_id << " logged in.\n";

      nCallbackLoginLogout::UserLoggedIn(new_id);
      
      sn_Connections[new_id].ping=1;
      sn_Connections[new_id].rateControl=20;
      reset_last_acks(new_id);
      m.Read(sn_Connections[new_id].rate);
      
      if (!m.End()){ // we get a big brother message
	tString rem_bb;
	m >> rem_bb;
	ofstream s("big_brother",ios::app);
	s << rem_bb << '\n';
#ifdef DEDICATED
#endif
      }

      if (sn_Connections[new_id].rate>sn_maxRateOut)
	sn_Connections[new_id].rate=sn_maxRateOut;

      nWaitForAck::AckAllPeer(MAXCLIENTS+1);
      reset_last_acks(MAXCLIENTS+1);
      if (sn_Connections[MAXCLIENTS+1].ackMess){
	delete sn_Connections[MAXCLIENTS+1].ackMess;
       sn_Connections[MAXCLIENTS+1].ackMess=NULL;
      }
      nMessage *rep=new nMessage(login_accept);
      rep->Write(new_id);
      rep->Send(new_id);

      nConfItemBase::s_SendConfig(true, new_id);

//      ANET_Listen(false);
//      ANET_Listen(true);
   }
   else if (m.SenderID()==MAXCLIENTS+1){
     (new nMessage(login_deny))->SendImmediately(MAXCLIENTS+1);
     sn_KillUser(MAXCLIENTS+1);
   }
}

nDescriptor login(6,login_handler,"login");


void logout_handler(nMessage &m){
  unsigned short id;
  m.Read(id);

  if (sn_Connections[id].socket>0)
    con << "received logout from " << id << ".\n";

  nWaitForAck::AckAllPeer(id);

  if (0<id && id<=maxclients)
    sn_KillUser(id);
}

nDescriptor logout(7,logout_handler,"logout");


#define MAX_MESS_LEN 300
#define OVERHEAD 32

static REAL sn_OrderPriority = 0;

// statistics
int sn_SentBytes        = 0;
int sn_SentPackets      = 0;
int sn_ReceivedBytes    = 0;
int sn_ReceivedPackets  = 0;
REAL sn_StatsTime		= 0;


void send_collected(int peer){
  if (peer<0 || peer > MAXCLIENTS+1)
    tERR_ERROR("Invalid peer!");

  if (sn_Connections[peer].sendBuffer.Len()){
	sn_SentPackets++;
	sn_SentBytes  += sn_Connections[peer].sendBuffer.Len() * 2 + OVERHEAD;

    // store our id
    sn_Connections[peer].sendBuffer[sn_Connections[peer].sendBuffer.Len()]=htons(::sn_myNetID);

    //    if (rand() > RAND_MAX/4)
    ANET_Write(sn_Connections[peer].socket,reinterpret_cast<int8 *>(&(sn_Connections[peer].sendBuffer[0])),
	       2*sn_Connections[peer].sendBuffer.Len(),&peers[peer]);

    /*
    con << "sending " << 2*sn_Connections[].sendBuffer[peer].Len() << " bytes";
    con << " to user " << peer << ".\n";
    */

    sn_Connections[peer].rateControl-=OVERHEAD;

    for(int i=sn_Connections[peer].sendBuffer.Len()-1;i>=0;i--)
      sn_Connections[peer].sendBuffer(i)=0;
    sn_Connections[peer].sendBuffer.SetLen(0);
  }
}

// TODO_NOACK
void nMessage::SendImmediately(int peer,bool ack){
  if (ack)
  {
#ifdef NO_ACK
    assert(messageID);
#endif
	new nWaitForAck(this,peer);
  }
#ifdef DEBUG  
    /*
    if (descriptor>1)
      con << "SMT " << descriptor << "\n";
    */

  /*
#ifdef DEBUG
    if (sn_Connections[].rate_control[peer]<-2000)
      tERR_ERROR("Heavy network overflow.");
#endif
  */

    if (peer==0 && sn_GetNetState()==nSERVER)
      tERR_ERROR("talking to yourself, eh?");
    
    if (peer==MAXCLIENTS+1){
      if(descriptor==login_deny.id)
	con << "Sending login_deny to login slot.\n";
      else if(descriptor==acknowleEdge.id)
	con << "Sending ack to login slot.\n";
      else
	tERR_ERROR("the last user only should receive denials or acks.");
    }
#endif
    
    if (sn_Connections[peer].sendBuffer.Len()+data.Len()+3 > MAX_MESS_LEN/2){
      send_collected(peer);
      //con << "Overflow packets sent to " << peer << '\n';
    }
    
    if (sn_Connections[peer].socket>0){
      sn_Connections[peer].sendBuffer[sn_Connections[peer].sendBuffer.Len()]=htons(descriptor);
      sn_Connections[peer].sendBuffer[sn_Connections[peer].sendBuffer.Len()]=htons(messageID);
      sn_Connections[peer].sendBuffer[sn_Connections[peer].sendBuffer.Len()]=htons(data.Len());
      int len=data.Len();
      for(int i=0;i<len;i++)
	sn_Connections[peer].sendBuffer[sn_Connections[peer].sendBuffer.Len()]=htons(data(i));
      
      sn_Connections[peer].rateControl-=2*(len+3);
      
      /*
	if (sn_Connections[].rate_control[peer]>0)
	send_collected(peer);
	
	unsigned short *b=new (unsigned short)[data.Len()+3];
	
	b[0]=htons(descriptor);
	b[1]=htons(messageID);
	b[2]=htons(data.Len());
	int len=data.Len();
	for(int i=0;i<len;i++)
	b[3+i]=htons(data(i));
	
	
	ANET_Write(sn_Connections[].socket[peer],(int8 *)b,
	2*(data.Len()+3),&peers[peer]);
	
	//cerr << "Sent " << 2*len+6 << " bytes.\n";
	sn_Connections[].rate_control[peer]-=2*(len+3)+OVERHEAD;
	
	delete b;
      */
      
      if (deb_net)
	con << "Sent " <<descriptor << ':' << messageID << ":" 
	    << peer << '\n'; 
    }
    
    AddRef();
    Release(); // delete this message if nobody is interested in it any more
}

REAL sent_per_messid[100];

void nMessage::Send(int peer,REAL priority,bool ack){
#ifdef NO_ACK
  if (!ack)
    messageID = 0;
#endif

#ifdef DEBUG_X
  if (descriptor>1)
    con << "PMT " << descriptor << "\n";
#endif

  sn_Connections[peer].rateControlPlanned-=2*(data.Len()+3);
  sent_per_messid[descriptor]+=2*(data.Len()+3);
  
  assert(Descriptor()!=acknowleEdge.ID() || !ack);

  new nMessage_planned_send(this,priority+sn_OrderPriority,ack,peer);
  sn_OrderPriority += .0001; // to roughly keep the relative order of netmessages
}


// receive and acknowleEdge the recently reveived network messages



static void rec_peer(unsigned int peer){
  
#define maxrec 2000
   unsigned short buff[maxrec];
   if (sn_Connections[peer].socket>0){
     int count=0;
     int len=1;
     while (len>0 && sn_Connections[peer].socket>0){
       len=ANET_Read(sn_Connections[peer].socket,reinterpret_cast<int8 *>(buff),maxrec*2,&peers[peer]);


       unsigned short *b=buff;
       unsigned short *bend=buff+(len/2-1);
       if (len>0){

		
     sn_ReceivedPackets++;
     sn_ReceivedBytes  += len + OVERHEAD;

	 unsigned short claim_id=ntohs(*bend);
	 /*
	 cerr << "Received " << len << " bytes";
	 con << " from user " << claim_id << '\n';
	 */
	 count ++;
	 unsigned int id=peer;
	 //	 for(unsigned int i=1;i<=(unsigned int)maxclients;i++)
	 int comp=ANET_AddrCompare(&peers[peer],&peers[claim_id]);
	 if (-1!=comp){
	     id=claim_id;

	     if (ANET_GetSocketPort(&peers[claim_id])
		 !=
		 ANET_GetSocketPort(&peers[peer])){
	       con << "changing port of user " << id << " from " 
		   << ANET_GetSocketPort(&peers[claim_id])
		   << " to "
		   << ANET_GetSocketPort(&peers[peer])
		   << ".\n";
	       peers[claim_id]=peers[peer];
	     }
	 }
	 else if (peer!=MAXCLIENTS+1){
	   con << comp << ":Peer claims to be user " << claim_id 
 	       << " (" << ANET_AddrToString(&peers[claim_id])
	       << "), but is user " << peer
	       << " (" << ANET_AddrToString(&peers[peer])
	       << ").\n";
	 }
	 else // look for a match
	   for(int i=MAXCLIENTS;i>=0;i--){
	     if (ANET_AddrCompare(&peers[peer],&peers[i])!=-1
		 && ANET_GetSocketPort(&peers[peer]) ==
		 ANET_GetSocketPort(&peers[i]))
	       id=i;
	   }

	 //	 if (peer!=id)
	 //  con << "Changed incoming address.\n";
	 while(reinterpret_cast<int>(b) < reinterpret_cast<int>(bend)){
	   nMessage mess(b,id);

	   bool mess_is_new=true;
	   // see if we have got this packet before
	   unsigned short mess_id=mess.MessageID();
	

#ifdef DEBUG
	   if ( (simulate_loss && rand()%simulate_loss==0)){
	     // simulate packet loss
	     //con << "Loosing packet " << mess_id << ":" << id << ".\n";
	   }else
#endif
	     if((id==MAXCLIENTS+1 && mess.Descriptor()!=login.ID() &&
		 mess.Descriptor()!=req_info.ID()) &&
		// do not accept normal packages from the login
		// slot; just login and information packets are allowed.
		(id==0 && !login_succeeded && mess.Descriptor()!=login_accept.ID()
		 && mess.Descriptor()!=login_deny.ID())
		// if we are not yet logged in, accept only login and login_deny.
		)
	       {
		 //con << "Ignoring packet " << mess_id << ":" << id << ".\n";
	       }
	     else 
	       {
		 if (mess_id != 0)  // messages with ID 0 are non-ack messages and come really often. they are always new.
	       {
    		 unsigned short diff=mess_id-highest_ack[id];
    		 if (diff>0 && diff<10000 || 
		       ((
		          mess.Descriptor() == login_accept.ID() ||
		          mess.Descriptor() == login_deny.ID()   ||
		          mess.Descriptor() == login.ID()
		          ) && highest_ack[id] == 0)
		         ){
		   // the message has a more recent id than anything before.
		   // it is surely new.
		       highest_ack[id]=mess_id;
		     }
		     else{
		       // do a better check
		       for(int i=ACKBACK-1;i>=0;i--)
		         if (mess_id==lastacks[id][i])
		           mess_is_new=false;
			 }
		   }


		 // acknowledge the message, even if it was old (the sender
		 // then thinks it got lost the first time)
		   
		 // special situation: logout. Do not sent ack any more.
		 if ((sn_Connections[id].socket<0)){
		   if (sn_Connections[id].ackMess)
		     delete sn_Connections[id].ackMess;
		   sn_Connections[id].ackMess=NULL;
		 }
		 else if (sn_Connections[id].ackMess && 
#ifdef NO_ACK
			   (mess.MessageID()) && 
#endif
			  (mess.Descriptor()!=login_ignore.ID() || 
			   login_succeeded)){
		   // do not ack the login_ignore packet that did not let you in.
		   sn_Connections[id].ackMess->Write(mess.MessageID()); 
		   if (sn_Connections[id].ackMess->DataLen()>100){
		     sn_Connections[id].ackMess->Send(id, 0, false);
		     sn_Connections[id].ackMess=NULL;
		   }
		 }
		 
		 if (mess_is_new){
		   // mark the message as old
		   if (mess_id > 0)
		   {
			   lastacks[id][lastackPos[id]]=mess_id;
			   if(++lastackPos[id]>=ACKBACK) lastackPos[id]=0;
			}   
		   
		   // special situation: login. Change peer number permanently
		   if (peer==MAXCLIENTS+1 && new_id>0){
		     id=peer=new_id;
		   }
	   
		   if (sn_GetNetState() != nSTANDALONE)
		     nDescriptor::HandleMessage(mess);
		 }
		 //else
		 //con << "Message " << mess_id << ":" << id << " was not new.\n";
	       }
	 } 
       }
     }
   }
}


void sn_Receive(){
  /*
  static bool reentry=false;
  if (reentry)
    return;
  reentry=true;
  */

   netTime=tSysTimeFloat();
   new_id=0;
   sn_Connections[MAXCLIENTS+1].ping=1;
   
   // create the ack messages
    int i;
   for(i=0;i<=MAXCLIENTS+1;i++)
     if(sn_Connections[i].ackMess==NULL)
       sn_Connections[i].ackMess=new nMessage(acknowleEdge);


   switch (current_state){
   case nSERVER:{
      peers[MAXCLIENTS+1].sa_family=0;
      for(int i=13;i>=0;i--)
	peers[MAXCLIENTS+1].sa_data[i]=0;

      if((sn_Connections[MAXCLIENTS+1].socket = ANET_CheckNewConnections())>0)
	rec_peer(MAXCLIENTS+1);
   }
   break;

   case nCLIENT:
     rec_peer(0);
     break;
     
   case nSTANDALONE:
   default:
      break;
   }

   nWaitForAck::Resend();
   sn_SendPlanned();

   // send the acks
   for(i=0;i<=MAXCLIENTS+1;i++)
     if(sn_Connections[i].socket>0 && sn_Connections[i].ackMess && !sn_Connections[i].ackMess->End()
//	&& sn_ackAckPending[i] <= 1+sn_Connections[].ackMess[i]->DataLen()
	&& sn_Connections[i].rateControlPlanned>250
	){
       sn_Connections[i].ackMess->Send(i,0, false);
       sn_Connections[i].ackMess=NULL;
     }
   
   //reentry=false;
}



nNetState sn_GetNetState(){
  return current_state;
}

void clear_owners();

void sn_SetNetState(nNetState x){
  static bool reentry=false;
  if(!reentry && x!=current_state){
    reentry=true;
    if (x!=nSTANDALONE){
      if (x==nCLIENT){
	for(int i=MAXCLIENTS+1;i>0;i--){
	  if(sn_Connections[i].socket>0){
	    sn_KillUser(i);
	  }
	}
      }
      else
	sn_myNetID=0;
      
      if (sn_Connections[0].socket<=0)
	sn_Connections[0].socket=ANET_Init();
      ANET_Listen(x==nSERVER);
    }
    else{
      clear_owners();
      for(int i=MAXCLIENTS+1;i>=0;i--){
	if(sn_Connections[i].socket>0){
	  if (i==0 && current_state!=nSERVER){ // logout
	    con << "Logging out...\n";
	    for(int j=3;j>=0;j--){ // just to make sure
	      nMessage *lo=new nMessage(logout);
	      lo->Write(static_cast<unsigned short>(sn_myNetID));
	      lo->SendImmediately(0);
	      sn_Receive();
	      usleep(1000);
	    }
	    // wait for logout return

	    /* Naaa. you have to stop making checks somewhere.
	    double timeout=tSysTimeFloat()+5;
	    while(sn_Connections[].socket[0]>0 && login_succeeded && tSysTimeFloat()<timeout){
	      sn_Receive();
	      usleep(10000);
	    }
	    */
	    con << "Done!\n";
	    
	  }
	}
	sn_KillUser(i);
      }
      if (current_state!=nSTANDALONE)
      ANET_Shutdown();
	  sn_Connections[0].socket = 0;
    }
    
    current_state=x;
    reentry=false;
  }
}



// go to client mode and connect to server


void sn_Connect(const tString &server){
   sn_SetNetState(nSTANDALONE);
   sn_SetNetState(nCLIENT);

   sn_Connections[0].ping=1;
   
   ANET_GetAddrFromName(server,&peers[0]);

   reset_last_acks(0);   
   nCallbackLoginLogout::UserLoggedOut(0);
   sn_Connections[0].sendBuffer.SetLen(0);

   ANET_Connect(sn_Connections[0].socket,&peers[0]); //useless
   sn_Connections[0].rate=sn_maxRateOut;

   sn_myNetID=0; // reset network id

   // first, get all pending messages
   sn_Receive();
   sn_Receive();
   sn_Receive();

   // Login stuff.....
   nMessage *mess=new nMessage(login);
   mess->Write(sn_maxRateIn);

   if (big_brother){
     (*mess) << sn_bigBrotherString;
     big_brother=false;
   }

   mess->Send(0);
   
   con << "Login information sent. Waiting for reply..\n";
   
   login_failed=false;
   login_succeeded=false;
   
   REAL timeout=tSysTimeFloat()+10;

   while(sn_GetNetState()==nCLIENT && tSysTimeFloat()<timeout && 
	 !login_failed && !login_succeeded){
      usleep(100000);
      sn_Receive();
      //if (repeat%100==0) con << repeat/100 << '\n';
      //con << repeat << '\n';
   }
   if (login_failed){
      con << "Login failed: Server is full.\n";
      sn_SetNetState(nSTANDALONE);
   }
   else if (tSysTimeFloat()>=timeout || sn_GetNetState()!=nCLIENT){
      con << "Login failed: Timeout.\n";
      sn_SetNetState(nSTANDALONE);
   }
   else{
     nCallbackLoginLogout::UserLoggedIn(0);

     con << "Login Succeeded. User Nr. " << sn_myNetID << '\n';
      con << "syncing with server...\n";
      sn_Sync(40);
      con << "Relabeling NetObjects...\n";
      con << "syncing again...\n";
      sn_Sync(40,true);
      con << "Done!\n";
   }
}


void nReadError(){
#ifndef NOEXCEPT
	throw nKillHim();
#else
	con << "\nI told you not to use PGCC! Now we need to leave the\n"
	     << "system in an undefined state. The progam will crash now.\n"
	     << "\n\n";
#endif
}



static void sn_ConsoleOut_handler(nMessage &m){
  if (sn_GetNetState()!=nSERVER){
    tString s;
    m >> s;
    con << s;
  }
}

static nDescriptor sn_ConsoleOut_nd(8,sn_ConsoleOut_handler,"sn_ConsoleOut");

// causes the connected clients to print a message
void sn_ConsoleOut(const tString &message,int client){
  nMessage *m=new nMessage(sn_ConsoleOut_nd);
  *m << message;
  if (client<0){
    m->BroadCast();
    con << message;
  }
  else if (client==sn_myNetID)
    con << message;
  else
    m->Send(client);
}

static void client_cen_handler(nMessage &m){
  if (sn_GetNetState()!=nSERVER){
    tString s;
    m >> s;
    con.CenterDisplay(s);
  }
}

static nDescriptor client_cen_nd(9,client_cen_handler,"client_cen");

// causes the connected clients to print a message in the center of the screeen
void sn_CenterMessage(const tString &message,int client){
  nMessage *m=new nMessage(client_cen_nd);
  *m << message;
  if (client<0){
    m->BroadCast();
    con.CenterDisplay(message);
  }
  else if (client==sn_myNetID)
    con.CenterDisplay(message);
  else
    m->Send(client);
}






// ****************************************************************
//                    Send Queue
// ****************************************************************

// the network stuff planned to send:
tHeap<planned_send> send_queue[MAXCLIENTS+2];

planned_send::planned_send(REAL priority,int Peer){
  peer=Peer;
  value=priority;
  send_queue[peer].Insert(this);
}

planned_send::~planned_send(){
  send_queue[peer].Remove(this);
}

tHeapBase *planned_send::Heap(){return &send_queue[peer];}
  
  // change our priority:
void planned_send::add_to_priority(REAL diff){
  value+=diff;
  send_queue[peer].Replace(this);
}

// **********************************************

nMessage_planned_send::nMessage_planned_send
(nMessage *M,REAL priority,bool Ack,int Peer)
  :planned_send(priority,Peer),m(M),ack(Ack){
  //if (m)
  //m->AddRef();
}

nMessage_planned_send::~nMessage_planned_send(){
  //m.Release();
}

void nMessage_planned_send::execute(){
  if (value<-killTimeout-10){
    con << "User " << peer << " is unable to keep up with the network traffic.\n";
    sn_KillUser(peer);
  }
  if (m)
    m->SendImmediately(peer,ack);
}


// **********************************************

void sn_SendPlanned(){
  sn_OrderPriority = 0;

  // if possible, send waiting messages
  static double lastTime=-1;
  double time=tSysTimeFloat();
  if (lastTime<0)
    lastTime=time;
  
  if (time<lastTime-.01 || time>lastTime+1000)
#ifdef DEBUG
    tERR_ERROR("Timer hickup!");
#else
  {
    tERR_WARN("Timer hickup!");
    lastTime=time;
  }
#endif

  //for(int i=MAXCLIENTS+1;i>=0;i--){
  for(int i=0;i<=MAXCLIENTS+1;i++){
    sn_Connections[i].rateControl+=(sn_Connections[i].rate*1000)*(time-lastTime);

    while (sn_Connections[i].ackPending<sn_maxNoAck &&
	   sn_Connections[i].rateControl>OVERHEAD     && 
	   send_queue[i].Len())
      {
	send_queue[i](0)->execute();
	delete send_queue[i](0);
      }

    if (sn_Connections[i].rateControl>1000)
      sn_Connections[i].rateControl=1000;
    
    // make everything a little more urgent:
    for(int j=send_queue[i].Len()-1;j>=0;j--)
      send_queue[i](j)->add_to_priority(lastTime-time);


    if (sn_Connections[i].sendBuffer.Len()>0 && sn_Connections[i].rateControl>0)
      send_collected(i);

    sn_Connections[i].rateControlPlanned=sn_Connections[i].rateControl;

  }
  lastTime=time;
}



void sn_KillUser(int i){
  // don't kill the server!
  if (sn_GetNetState()==nSERVER && i==0)
    return;

  static bool reentry=false;
  if (reentry)
    return;
  reentry=true;

  nWaitForAck::AckAllPeer(i);

  if (sn_Connections[i].socket>0){
    con << "Killing user " << i << ", ping " << sn_Connections[i].ping << ".\n";
    send_collected(i);
  }

   // to make sure...
  if (i!=0){
    for(int j=2;j>=0;j--){
      (new nMessage(login_deny))->SendImmediately(i, false);
      sn_Receive();
    }
  }


  nWaitForAck::AckAllPeer(i);
  
  if(sn_Connections[i].ackMess){
    delete sn_Connections[i].ackMess;
    sn_Connections[i].ackMess=NULL;
  }
  
  if (i==0 && sn_GetNetState()==nCLIENT)
    sn_SetNetState(nSTANDALONE);
  
  reset_last_acks(i);

  peers[i].sa_family=0;
  sn_Connections[i].socket=-1;
  
  sn_Connections[i].ackPending=0;
//  sn_ackAckPending[i]=0;
  
  while (send_queue[i].Len())
    delete (send_queue[i](0));

  nCallbackLoginLogout::UserLoggedOut(i);
  sn_Connections[i].sendBuffer.SetLen(0);

  reentry=false;
}


int sn_QueueLen(int user){
  return send_queue[user].Len();
}


static tCallback* s_loginoutAnchor;
int  nCallbackLoginLogout::user;
bool nCallbackLoginLogout::login;

nCallbackLoginLogout::nCallbackLoginLogout(VOIDFUNC *f)
  :tCallback(s_loginoutAnchor,f){}

void nCallbackLoginLogout::UserLoggedIn(int u){
  login = true;
  user = u; 
  Exec(s_loginoutAnchor);
}

void nCallbackLoginLogout::UserLoggedOut(int u){
  login = false;
  user = u; 
  Exec(s_loginoutAnchor);
}


void net_exit(){
  for (int i=MAXCLIENTS+1;i>=0;i--)
    {
      tDESTROY(sn_Connections[i].ackMess);
      while (send_queue[i].Len())
	delete send_queue[i].Remove(0);
    }
}

static tInitExit net_ie(NULL, &net_exit);



void sn_Statistics()
{
	REAL time = tSysTimeFloat();
	REAL dt = time - sn_StatsTime;
	sn_StatsTime = time;
	
	if (dt > 0 && (sn_SentPackets || sn_SentBytes))
	{
		con << "Time:     " << dt << " seconds\n";
		con << "Sent:     " << sn_SentBytes     << " bytes in " << sn_SentPackets     << " packets (" << sn_SentBytes    /dt << " bytes/s)\n"; 
		con << "Received: " << sn_ReceivedBytes << " bytes in " << sn_ReceivedPackets << " packets (" << sn_ReceivedBytes/dt << " bytes/s)\n"; 
	}
	
	sn_SentPackets = 0;
	sn_SentBytes   = 0;
	sn_ReceivedPackets = 0;
	sn_ReceivedBytes   = 0;
}






nConnectionInfo::nConnectionInfo(){}
nConnectionInfo::~nConnectionInfo(){}

void nConnectionInfo::Clear(){}
