/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "eWall.h"
#include "rRender.h"
#include "rTexture.h"
#include "eGameObject.h"
#include "eTess2.h"

/* ***************************************************
   eWall:
   *************************************************** */



tHeap<eWallView> se_wallsVisible[MAX_VIEWERS];
// List<eWall> se_wallsNotYetInserted;

tHeapBase *eWallView::Heap(){
  return &(se_wallsVisible[viewer]);
}


void eWallView::SetValue(REAL v){
  tHeapElement::value=v;
  se_wallsVisible[viewer].Replace(this);
}

eWall::eWall(eGrid *g):edge(NULL), grid(g), flipped(0){
  id = -1;
  //Remove();
  //initialize viewers
  for(int i=MAX_VIEWERS-1;i>=0;i--){
    view[i].Set(i,this);
    se_wallsVisible[i].Insert(&view[i]);
  }
}

eWall::~eWall(){
  if (edge)
    edge->wall = NULL;
  for(int i=MAX_VIEWERS-1;i>=0;i--)
    se_wallsVisible[i].Remove(&view[i]);
  tCHECK_DEST;

  Insert();
}

void eWall::CalcLen(){
  len = sqrt(edge->Vec().Norm_squared());

  //  Insert();
}




#ifdef DEDICATED_XXX
void eWall::Render_helper(eWall *w,REAL tBeg,REAL tEnd,REAL h,REAL hfrac,REAL bot){
  glDisable(GL_CULL_FACE);

  const eCoord *p1 = &w->EndPoint(0);
  const eCoord *p2 = &w->EndPoint(1);
  
  BeginQuads();
  IsEdge(false);
  TexVertex(p1->x, p1->y, bot,
	    tBeg        , hfrac);


  IsEdge(false);
  TexVertex(p1->x, p1->y, h*hfrac,
	    tBeg        , 0);


  IsEdge(false);
  TexVertex(p2->x, p2->y, h*hfrac,
	    0           , 0);

  TexVertex(p2->x, p2->y, bot,
	    0           , hfrac);

  RenderEnd();

  if (TextureMode[rTEX_WALL]<0){
    Color(1,1,1);
    
    Line(p1->x,p1->y,h*hfrac,
	 p2->x,p2->y,h*hfrac);

  }
}

void eWall::Render(){
  return;
  /*
  if (edge){
    const eCoord *p1 = &EndPoint(0);
    const eCoord *p2 = &EndPoint(1);
    
    Color(0,0,1,.5);
    
    eWall::Render_helper(this,(p1->x+p1->y)/40,(p2->x+p2->y)/40,4,1);
  }
  */
}
#endif

//ArmageTron_eWalltype eWall::type(){return ArmageTron_GENERIC_WALL;}

//void eWall::Flip(){}

bool eWall::Splittable() const {return 0;}
bool eWall::Deletable() const {return 0;}

void eWall::Split(eWall *& s1,eWall *& s2,REAL){
  s1=tNEW(eWall)(*this);
  s2=tNEW(eWall)(*this);
}

void eWall::PassingGameObject(eGameObject *pass,REAL,REAL,int){
  pass->Kill();
}

void eWall::SetVisHeight(int v,REAL h){
  if (h>=SeeHeight()-EPS)
    view[v].SetValue(h);
  else
    view[v].SetValue(-1000);
}


void eWall::Insert(){
  if (grid)
    grid->wallsNotYetInserted.Remove(this,id);
}


void eWall::Remove(){
  if (grid)
    grid->wallsNotYetInserted.Add(this,id);
}

const eCoord& eWall::EndPoint(int i) const{
  if (edge)
    {
      if (flipped != i)
	return *edge->Other()->Point();
      else
	return *(edge->Point());
    }
  else
    return se_zeroCoord;
}

eCoord eWall::Vec() const{
  if (edge)
    return (edge->Vec())*((1 - 2*flipped)*.5f);
  else
    return eCoord(0,0);
}


