-- $Id: quest.lua,v 1.25 2003/03/23 11:17:13 mrq Exp $
-- Arkhart RPG - An Ark-based roleplaying game.
-- Copyright (C) 2001 The Contributors of the Arkhart Project
-- Please see the file "AUTHORS" for a list of contributors
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

ark:require("{game}/world/demo/quest-tr.lua")

ingredient0 = 0;
ingredient1 = 0;
remede = 0;

dummy = {}

function dummy.on_create(self)
	ark.world:set_time_of_day(0.30);	
	self:add_timer(0, 1);

end;

function dummy.on_timer(self)
	local t = ark.world:get_time_of_day();
	t = t + 0.00014
	if (1 < t) then  t = t - 1 end
	ark.world:set_time_of_day(t);
	self:add_timer(0, 0.1);
end;


cauldron = {}

function cauldron.on_create (self)
   self:psys_set (0,
		  "(0.0,-.80,.10)(0.0,0.0,1.0)(.2)",
		  "(G,G,G)(R,G,G)",
		  "(150, {particles}/smoke.akp");
end;

fermiere = {};

function fermiere.on_create(self)
 	self:play_anim (ark.play_loop, "idle");
	self.state = 1;
end;

function carre(x)
	return (x*x);
end

function find_player(bouh)
	player = ark.world:get_entity_by_name("Player0");
	return (player);
end

function distance(entity)
	position = entity:get_position();
	player = find_player(0);
	player_position = player:get_position();
	bouh = sqrt(carre(position.x - player_position.x) + carre(position.z - player_position.z)
	            + carre(position.y - player_position.y));
	return (bouh);
end

daphyring_ferme = {}

function daphyring_ferme.on_create(self)
	self.state = 1;
end

daphyring_busy = {}

function daphyring_busy.on_create(self)
	self.state = 1;
end

olddaphy = {}

function olddaphy.on_create(self)
	self.state = 1;
end

fleur = {}

function fleur.on_create(self)
	self.state = 1;
end

function fleur.on_tell(self, ent, msg)
	if (msg == "MOUSEHIT") then
		if (distance(self) > 2) then
			return 1;
		end
		self:set_visible(0);
		ingredient1 = 1;
		self:add_message(ent, 
		"Vous venez de recuperer une tournavelle jubilire !",
		{});
	end
	return 1;
end

pancarte_village = {}

peon = {}

function peon.on_create(self)
	self.state = 1;
end

pancarte_village = {}

function pancarte_village.on_tell(self)
	if (msg == "MOUSEHIT") then
		if (distance(self) > 10) then
			return 1;
		end
		self:add_message(ent,
		"Village d'Elunsra",
		{});
	end
	return 1;	
end

pancarte_enclos = {}

function pancarte_village.on_tell(self)
	if (msg == "MOUSEHIT") then
		if (distance(self) > 10) then
			return 1;
		end
		self:add_message(ent,
		"Enclos a Cogres",
		{});
	end
	return 1;
end

pancarte_ferme = {}

function pancarte_ferme.on_tell(self)
	if (msg == "MOUSEHIT") then
		if (distance(self) > 10) then
			return 1;
		end
		self:add_message(ent,
		"Ferme de Memh",
		{});
	end
	return 1;
end

function peon.on_tell(self, ent, msg)
	if (msg == "MOUSEHIT") then
		if (distance(self) > 7) then
			return 1;
		end
		if (self.state == 1) then -- on lui a jamais parle
			self.state = 2;
			self:add_message (ent,
			tr("Salut, moi c'est Memh. T'est nouvelle dans le coin on dirait ?"),
			{tr("GENS|- Oui, je dcouvre ce village. Pourquoi y'a-t-il si peu de gens ?"),
			 tr("FERME|- Et oui. C'est  vous cette belle ferme ?"),
			 tr("CIAO|- Euh, en effet. Je dois y aller !")});
		elseif (self.state == 2) then -- on lui a deja parle un peu
			self:add_message (ent,
			tr("Tiens te revoila ! Qu'est ce que tu voulais savoir d'autre ?"),
			{tr("GENS|- Pourquoi y'a-t-il aussi peu de gens ici ?"),
			 tr("CIAO|- Rien, je m'en vais en fait")});
		elseif (self.state == 3) then -- on lui a deja parle un peu plus
			self:add_message (ent,
			tr("Que veux tu ?"),
			{tr("NUWATA|- Tu as mentionn un nom... Nuwata... Qui est ce ?"),
			 tr("CIAO|- Rien en fait")});
		elseif (self.state == 4) then -- on lui a deja parle beaucoup... trop :)
			self:add_message (ent,
			tr("Dsol, Je n'ai plus rien d'interessant a te dire, et je dois m'occuper de mes cogres..."),
			{tr("CIAO|- Salut")});
		end
	elseif (msg == "FERME") then
		self:add_message (ent,
		tr("Oui, et c'est une des plus prospres de la valle ! " ..
		"Regardez moi un peu la sant de ces cogres ! " ..
		"a fait pas plaisir  voir ? Si vous voulez je peux vous faire " ..
		"visiter les tables, je vous assure qu'elles vous surprendront !"),
		{tr("GENS|- Je vous crois sur parole. Expliquez moi plutt pourquoi ce " ..
		         "village est si peu peupl ?"),
		 tr("DAPHYS|- J'ai vu que vous aviez des daphys qui travaillent ici ...")});
	elseif (msg == "GENS") then
		self.state = 3;
		self:add_message (ent,
		tr("Ben, tout le monde est descendu a Halsiff pour le carnaval. J'aurais " ..
		"bien aim y aller aussi mais il faut que je m'occupe de mes cogres. " ..
		"Une femelle va mettre bas, il faut que je sois l. " ..
		"Il reste aussi la pauvre Nuwata et son fils, qui est malade."),
		{tr("NUWATA|- Nuwata ?"),
		 tr("CARNAVAL|- Et ce carnaval, il est intressant ?")});
	elseif (msg == "NUWATA") then
		self.state = 4;
		self:add_message (ent,
		tr("C'est la femme en train de se lamenter dans le village, l-bas. Son fils " ..
		"s'est fait mordre par une Zourde enrage lors d'une partie de chasse. " ..
		"Son mari est all au carnaval avec les autres enfants, et elle a peur " ..
		"que son fils nous ait quitt avant mme de revoir son pre. "),
		{tr("AIDER|- La pauvre femme ... et il n'y a pas moyen de l'aider ?")});
	elseif (msg == "AIDER") then
		self:add_message (ent,
		tr("Je ne pense pas, personne ici ne connait la maladie de son fils. " ..
		"Le mdecin est pass il y a quelques jours, mais c'est un incapable " .. 
		"doubl d'un gringalet... Allez discutez un peu avec elle sait on jamais..."),
		{tr("CIAO|- D'accord j'y vais.")});	
	elseif (msg == "CARNAVAL") then
		self:add_message(ent,
		tr("Oui, il s'y passe beaucoup de choses ! C'est une crmonie annuelle  o " ..
		"tous les villages des environs se runissent a Halsiff. Mais il faut bien " ..
		"que quelques personnes restent aussi au village pour s'occuper des animaux."),
		{tr("CIAO|- Effectivement. Au revoir.")});
	elseif (msg == "DAPHYS") then
		self:add_message(ent,
		tr("Oui, ils sont senss m'aider a la ferme, mais ils ne valent rien. Ces satanes " ..
		"bestioles ne sont vraiment que des feignasses.	"),
		{tr("GENS|- Revenons en au village lui mme... Pourquoi aussi peu de monde ?")});
	end
	return 1;
end;

function daphyring_busy.on_tell(self, ent, msg)
	if (msg == "MOUSEHIT") then
		if (distance(self) > 7) then
			return 1;
		end
		self:add_message (ent,
  			tr("Dsol, J'ai du travail... Tente ta chance avec quelqu'un d'autre..."),
			{tr("CIAO|- D'accord")});
	end
	return 1;
end;

function olddaphy.on_tell(self, ent, msg)
	if (msg == "MOUSEHIT") then
		if (distance(self) > 7) then
			return 1;
		end
		if (self.state == 1) then
			self:add_message (ent,
  			tr("Qu'est-ce que vous venez faire ici vous ? et vous tes qui au fait ? Je " ..
			"n'ai jamais vu votre tte."),
			{tr("EUH|- Euh, je suis une trangre, je ne fais que passer dans ce village.")});
		elseif (self.state == 2 and (ingredient0 < 1 or ingredient1 < 1)) then
			self:add_message (ent,
  			tr("Tant que n'aurez pas tous les ingrdients, ca servira pas a grand chose de revenir " ..
			"me voir..."),
			{tr("CTQUOI|- Euh, il fallait quoi dj ?"),
			 tr("CIAO|- Je reviendrais.")});
		elseif (self.state == 2 and (ingredient0 > 0 and ingredient1 > 0)) then
			self.state = 3;
			self:add_message (ent,
  			tr("Des feuilles d'aiquerelle sches et une tournivalle jubilire ? " ..
			"qu'est-ce que vous voulez que j'en foute ???"), 
			{tr("BAH|- Ben, euh, vous m'aviez dit que vous me feriez un cataplasme")});	 
		elseif (self.state == 3) then
			self:add_message(ent,
			tr("Tu crois pas que tu m'as assez drang comme ca ?"), 
			{tr("CIAO|- Roh, c'est bon, j'y vais...")});
		end
	elseif (msg == "EUH") then
		self:add_message (ent,
  		tr("Aah, de mon temps les gens taient plus respectueux. Moi qu'ait perdu mes pattes antrieures " ..
		"durant la guerre, moi qu'ai pas mal train dans le monde, j'vous l'dit, y'a pu d'respect."),
		{tr("ONDIT|- On m'a dit que vous connaissiez des remdes pour humain ...")});
	elseif (msg == "ONDIT") then
		self:add_message (ent,
  		tr("Ouaip ! probablement plus que pas mal de soi-disant mdecins qu'on " ..
		"trouve par ici ! Faut dire que dans mes jeunes annes, j'ai appris bien des choses, " ..
		"oh oui, bien des choses. " ..
		"J'accompagnais les lgions de Liveyz en tant qu'aide de camp puis en tant que mdecin " ..
		"militaire. Ah y'avait pas beaucoup de daphyrings dans l'arme mais ils taient braves ! " ..
		"Le corps des Halimarliers  accompli de vritables prouesses !"),
		{tr("DONC|- Donc vous connatriez peut-tre un remde contre les morsures de Zourdes ?")});
	elseif (msg == "DONC") then
		self:add_message (ent,
		tr("Et puis, lors du sige de la forteresse de Mandurn, tenue par " ..
		"l'hrsiarque Katumuni Pavolnyah, on a eu une pidmie de scubolite violace, " ..
		"c'tait un drame ! Comme la scubolite ne  " ..
		"s'attaque qu'aux humains, c'est surtout les mdecins daphys qui bossaient. " ..
		"Et on avait pas le temps de se reposer ! C'tait cet ignoble Pavolnyah qui nous " ..
		"avait lanc des cadavres contamins, " ..
		"et bien sur dans son camp personne n'a t atteint. Le jour o on a mont sa " ..
		"tte sur une pique au milieu des cendres de sa forteresse, on tait bien content " ..
		"d'en finir, mme si ces histoires de religion a me concerne pas trop."),
		{tr("ZOURDE|- Pour en revenir a mon problme de morsure de Zourde...")});	
	elseif (msg == "ZOURDE") then
		self:add_message(ent,
		tr("Hmm, une morsure pas trop mchante devrait pas prsenter trop de risques " ..
		"d'infection si on prend bien soin de la plaie. " .. 
		"Ah c'est dans les marais du Soumlarj qu'on a eu des cas graves ! Les " ..
		"zourdes normales taient pas trop un problme, mais il y en avait des " ..
		"malades, souvent solitaires, qui transmettaient le fivre scalopienne " ..
		"a nos hommes. C'est une maladie bien moins grave que la rage des montagnes " ..
		"qui svit aussi chez les zourdes, mais elle est bien moins connue. "),
		{tr("SYMPTOMES|- La fivre scalopienne ? Ca donne quels symptmes ?")});
	elseif (msg == "SYMPTOMES") then
		self:add_message(ent,
		tr("Au dbut pas grand chose, des fois a s'aggrave pas. Mais le plus " ..
		"souvent au bout de quelques jours, la maladie s'installe ... " ..
		"on tient plus debout, on est faible ... a a fait des ravages " ..
		"dans les rangs des soldats, parce qu'on avait peu de moyens pour les " ..
		"soigner, et on tait pas familiariss avec la maladie. " ..
		"Mais les gens de la rgion nous ont aids et on a fini par bien savoir soigner a."),
		{tr("SOIGNER|- Hum, et comment a peut se soigner ?")});
	elseif (msg == "SOIGNER") then
		self:add_message(ent,
		tr("Bien sur, on peut gurir le fivre scalopienne. Quand j'tais dans " ..
		"l'arme du seigneur Liveyz Trannat, lors de la campagne de Snattorie " ..
		"orientale, on avait eu pas mal de cas. Il suffisait de leur faire un " ..
		"cataplasme  base d'aiquerelle sches et de tournavelle jubilire."),
		{tr("AHA|- Ah, et vous pourriez m'en faire un ?")});
	elseif (msg == "AHA") then
		self.state = 2;
		self:add_message(ent,
		tr("Hum, c'est bien parceque vous m'tes sympathique... Mais il me faut les ingrdients !"),
		{tr("CHERCHER|- Je pars de suite les chercher"),
		 tr("CTQUOI|- C'etait quoi deja ?")});
	elseif (msg == "CTQUOI") then
		self:add_message(ent,
		tr("Des aiquerelles sches et de la tournavelle jubilire. Demandez dans le village, " ..
		"c'est plutot commun comme ingrdients..."),
		{tr("CHERCHER|- D'accord, j'y vais.")});
	elseif (msg == "BAH") then
		remede = 1;
		self:add_message(ent,
		tr("Ah oui c'est vrai... Bon, le voil. Maintenant deguerpissez j'ai du travail !"),
		{tr("CIAO|- Merci pour tout.")});
	end
	return 1;
end;

function daphyring_ferme.on_tell(self, ent, mesg)
	mypeon = ark.world:get_entity_by_name("Peon0");
	myfermiere = ark.world:get_entity_by_name("Fermiere0");
	old = ark.world:get_entity_by_name("OldDaphy0");
	if (mesg == "MOUSEHIT") then
		if (distance(self) > 7) then
			return 1;
		end
		if (mypeon.state == 1 and (mypeon.state < 1 and myfermiere.state < 1)) then
			self:add_message(ent,
			tr("Nous on est que des pauvres daphys bwana, on sait rien ... " ..
			"Si tu veux des informations sur le village, vas voir Memh, l'homme " ..
			"responsable de cette ferme. Ou la jeune femme en pleurs la bas, Nuwata"),
			{tr("CIAO|- D'accord je reviendrais vous voir a un autre moment...")});
		elseif (self.state == 1 and (mypeon.state > 1 or myfermiere.state > 1)) then
			self:add_message(ent,
			tr("Salut, ou tu vas ou comme ca?"),
			{tr("BALLADE|- Euh, j'me ballade..."),
			 tr("INSECTE|- Ca te concerne pas, insecte."),
			 tr("ZOURDE|- Je cherche un remde contre les morsures de Zourdes enrages ...")});
		elseif (self.state == 2) then -- on lui a deja parle, mais pas de la zourde enrage.
			self:add_message(ent,
			tr("Oui ?"),
			{tr("ZOURDE|- Vous auriez un remde contre les morsures de Zourde enrage ?"),
			 tr("CIAO|- Non rien, au revoir")});
		elseif (self.state == 3 and old.state == 1) then -- on lui a parle de la zourde et pas au vieux
			self:add_message(ent,
			tr("Je n'ai plus rien d'interessant a te dire j'en ai peur. Vas voir le vieux daphy " ..
			"qui traine un plus loin, il t'en dira peut tre plus..."),
			{tr("CIAO|- J'y vais")});
		elseif 	(self.state == 3 and old.state > 1) then -- on lui a parle de la zourde et au vieux
			self:add_message(ent,
			tr("Encore toi ?"),
			{tr("REUH|- Je suis all voir l'ancien... Il est un peu bizarre, non ?")});		
		elseif (self.state == 4) then -- ras le bol
			self:add_message(ent,
			tr("Dsol, je t'ai deja dit tout ce que je savais."),
			{tr("CIAO|- D'accord j'y vais")});
		end
	elseif (mesg == "BALLADE") then
		self.state = 2;
		self:add_message(ent,
		tr("Drle d'endroit pour faire du tourisme, y'a rien que des daphys et " ..
		"cogres puants ici."),
		{tr("ZOURDE|- Non, en fait je suis  la recherche d'un remde contre les morsures de " ..
		 "Zourdes enrages ..."),
		 tr("CIAO|- Je vais aller voir ailleurs alors")});
	elseif (mesg == "INSECTE") then
		self:add_message(ent,
		tr("Tu t'est pas vue, sac a sueur malodorant ! Moi au moins je suis pas en " ..
		"train de suinter des fluides nausabonds partout o je vais !"),
		{tr("EXCUSE|- Excuse moi, je plaisantais.")});
	elseif (mesg == "EXCUSE") then
		self.state = 2;
		self:add_message(ent,
		tr("Hmmm ... donc t'est venue ici pour nous insulter ?"),
		{tr("ZOURDE|- Non, en fait je suis  la recherche d'un remde contre les morsures de " ..
		"Zourdes enrages ..."),
		tr("BOULAY|- Memh m'a dit que vous travaillez comme des gorets. c'est vrai ?"),
		tr("CIAO|- Bon pas la peine, au revoir.")});
	elseif (mesg == "ZOURDE") then
		self.state = 3;
		self:add_message(ent,
		tr("Pour gurir quelqu'un qui s'es fait mordre par une zourde enrage, il " ..
		"faut lui mettre du jus de Goubille sous la carapace  l'endroit de la morsure, " ..
		"en lui mettant les antennes dans de la vapeur de svirnielle jusqu' ce que ses " ..
		"mandibules s'ouvrent toutes grandes."),
		{tr("HUMAINS|- Je vois le genre ... et pour les humains ?"),
		 tr("CIAO|- Euh merci beaucoup, j'essaierai, promis !")});
	elseif (mesg == "REUH") then
		self:add_message(ent,
		tr("Hihihi, mme nous on le frquente pas trop. Il est vachement susceptible " ..
		"mais heureusement, il se souvient de rien. L'aut'jour, il tait convaincu " ..
		"que l'impratrice Frazzilia reignait encore. Il a une perception ... diffrente " ..
		"... de la ralit."),
		{tr("PLANTE|- Il m'a parl de pousses de tournivaille jubilire ... C'est quoi ?")});
	elseif (mesg == "PLANTE") then
		self:add_message(ent,
		tr("C'est une plante qui pousse surtout sur un sol fertilis par les " ..
		"bouses de Cogres. A mon avis vous devriez pouvoir en trouver dans l'enclos prs de la ferme."),
		{tr("CIAO|- Merci beaucoup, au revoir !")});
	elseif (mesg == "HUMAINS") then
		self:add_message(ent,
		tr("Pff, les cogres c'est limite mais alors les humains ... Je suis pas mdecin moi."),
		{tr("OUIN|- Ah, vous ne connaissez personne qui puisse m'aider ?")});
	elseif (mesg == "OUIN") then
		self.state = 3; -- inutile en theorie car on est passe par zourde, mais sait on jamais.
		self:add_message(ent,
		tr("Hmm, Peut-tre bien. Je connais un vieux Daphyring qui dit entre autres " ..
		"avoir travaill comme mdecin militaire. Il s'y connait surement mieux... Il doit traner " ..
		"pas loin d'ici..."),
		{tr("CIAO|- Merci je pars a sa recherche")});
	elseif (mesg == "BOULAY") then
		self:add_message(ent,
		tr("Ben, on est pas fait pour le travail de ferme, nous. Qu'est-ce qu'on en " ..
		"a  faire des cogres, nous ? Y' qu'un humain pour avoir besoin de quelque chose " ..
		"d'aussi gros, on mangerait pas de ce genre de truc. "),
		{tr("FAITESQUOI|- Ben qu'est-ce que vous faites ici alors ?"),
		 tr("MANGER|- Et, euh, vous mangez quoi d'habitude si ce n'est pas indiscret ?")});
	elseif (mesg == "FAITESQUOI") then
		self:add_message(ent,
		tr("Ben on s'occupe des cogres pendant que la plupart des humains sont descendus voir le " ..
		"carnaval, il reste que Memh, qui nous paye pour qu'on s'occupe de ses cogres."),
		{tr("CARNAVAL|- Vous tes pas interesss par le carnaval ?"),
		 tr("CIAO|- Au revoir")});
	elseif (mesg == "CARNAVAL") then
		self:add_message(ent,
		tr("Quelques daphys y sont alls, parce que nous respectons les crmonies religieuses. " ..
		"Mais le carnaval est avant tout pour les humains d'avoir des contacts sexuels et de " ..
		"consommer de grandes quantits d'alcool de Pertuiche, ce qui ne nous concerne pas. "),
		{tr("CIAO|- Ah, je comprends. Au revoir.")});
	elseif (mesg == "MANGER") then
		self:add_message(ent,
		tr("Y' pas de daphys dans ta ville ? Tu dois venir de loin alors ... " ..
		"Pour nous, la nourriture n'est pas importante, je trouve toujours tonnant " ..
		"le temps qu'un humain peut passer  table, et l'attention qu'il porte  sa " ..
		"nourriture. Je manges l mme chose tous les jours depuis plus de trente ans : " ..
		"une bouillie de farnimente aux herbes et du suc d'yrteithe. On a pas besoin d'aller " ..
		"massacrer des animaux pour manger, nous."),
		{tr("CIAO|- Mmm, mettons. Au revoir.")});
	end
	return 1;
end

function fermiere.on_tell(self, ent, msg)
	old = ark.world:get_entity_by_name("OldDaphy0");
	if (msg == "MOUSEHIT") then -- click soit initial soit si on est sorti/revenu du dialogue
		if (distance(self) > 7) then
			return 1;
		end
		if (self.state == 1) then
			self.state = 2;
			self:add_message(ent,
			tr("*Snif* Bonjour."),
			{tr("VILLAGE|- Quel est ce village ?"),
			 tr("VAPABIEN|- Quelque chose ne va pas ?"),
			 tr("CIAO|- A plus tard")});
		elseif (self.state == 2) then
			self:add_message(ent,
			tr("*snif* tiens, Vous revoil !"),
			{tr("VILLAGE|- Parlez-moi du village ..."),
			tr("VAPABIEN|- Ca ne va pas ?"),
			tr("CIAO|- mmm, non en fait je repars...")});
		elseif (self.state == 3 and old.state == 1) then
			self:add_message(ent,
			tr("Ah !  vous voil ! Vous avez le remde pour mon fils ? " ..
			"Son tat ne s'est pas amlior ..."),
			{tr("PASENCORE|- Non, dsol, pas encore.")});
		elseif (self.state == 3 and old.state > 1 and remede < 1) then
			self:add_message(ent,
			tr("Ah !  vous revoil ! Alors, ce remde ?"),
			{tr("PASENCORE|- Il n'est pas encore prt."),
			 tr("CUISINE|- Vous n'auriez pas des aiquerelle sches par hazard ?")});
		elseif (self.state == 3 and remede > 0) then
			self:add_message(ent,
			tr("Alors vous avez le remde ? Son tat s'empire !"),
			{tr("VOILA|- Oui, le voila !")});
		end
	elseif (msg == "VILLAGE") then
		self:add_message(ent,
		tr("C'est Elunsrail. Ici, il n'y a que des gens hontes et dvts."),
		{tr("DESERT|- Le village me semble assez dsert ... pourquoi ?")});
	elseif (msg == "DESERT") then
		self:add_message(ent,
		tr("La plupart des habitants sont descendus  Halsiff pour le carnaval du " ..
		"printemps, mais je n'ai pas pu y aller parce que mon enfant est malade. " ..
		"Oh mon dieu bouhouhousnif le pauvre il va mourir ! " ..
		"Les dieux nous ont abandonns, alors que nous avons toujours t trs pieux ! " ..
		"Quand avons nous faut ?"),
		{tr("AIDER|- Je peux peut-tre aider votre fils ?"),
		 tr("NON|- Je suis dsole pour vous. Au revoir !")});
	elseif (msg == "VAPABIEN") then
		self:add_message(ent,
		tr("Oui ... les dieux nous ont punis, et mon fils est malade ! je prie jour " ..
		"et nuit, mais son tat ne s'amliore pas ..."),
		{tr("AIDER|- Je peux peut-tre aider votre fils ?"),
		 tr("CIAO|- Je suis dsole pour vous, mais je vois pas ce que je pourrais y faire.")});
	elseif (msg == "AIDER") then
		self:add_message(ent,
		tr("Vous feriez a ?"),
		{tr("BIENSUR|- Bien sur, je suis gurisseuse !"),
		 tr("DEPEND|- Ca dpend, il a quoi comme maladie ?"),
		 tr("PTET|- Euh, je verrai ce que je peux faire..."),
		 tr("NON|- Finalement, peut-tre pas.")});
	elseif (msg == "BIENSUR") then
		self.state = 3;
		self:add_message(ent,
		tr("Vraiment ? Ah, faites quelque chose pour nous alors ! je vous en supplie !"),
		{tr("CIAO|- Pas de problmes, je *hum*, vais me prparer...")});
	elseif (msg == "DEPEND") then
		self.state = 3;
		self:add_message(ent,
		tr("Il s'est fait mordre par une zourde, la semaine dernire. La blessure " ..
		"avait pas l'air grave au dbut, mais ensuite il est tomb malade ... " ..
		"maintenant il est au lit, trs faible; et il ne veut plus manger, il " ..
		"a de la fivre. Il s'affaiblit de jour en jour. Je suis trs inqute !"),
		{tr("MEDECIN|- Vous avez un mdecin dans le village ?"),
		tr("VAISVOIR|- Hmm, je vais voir si je peux vous aider ...")});
	elseif (msg == "MEDECIN") then
		self.state = 3;
		self:add_message(ent,
		tr("Il y a un jeune mdecin qui fait le tour des villages, il est pass ici " ..
		"hier mais n'avait pas l'air de savoir quoi faire. Il lui a donn un peu " ..
		"de liqueur mais a n'a rien chang. Il a dit qu'il reviendrait la semaine " ..
		"prochaine mais j'ai peur que ce soit trop tard."),
		{tr("PTET|- Bon ben c'est a moi de m'en occuper alors."),
		 tr("NON|- Je suis dsole, mais je ne suis pas mdecin.")});
	elseif (msg == "PTET") then
		self.state = 3;
		self:add_message(ent,
		tr("Oh, je vous en prie sauvez mon fils ! je serais trs reconnaissante ! " ..
		"Je sens que vous y arriverez, vos cheveux m'indiquent que vous tes une " ..
		"favorite de Moujell!"),
		{tr("CIAO|- Je vais essayer, mais je ne promets rien. Je reviendrai ! ")});	
	elseif (msg == "NON") then
		self.state = 3;
		self:add_message(ent,
		tr("Oh, s'il vous plait, vous tes mon dernier espoir... *snif*"),
		{tr("CIAO|- Bon, je vais voir ce que je peux faire, mais je ne promets rien ...")});
	elseif (msg == "CUISINE") then
		self:add_message(ent,
		tr("Je dois en avoir dans ma cuisine. C'est pour faire une saute aux jorbilles ?"),
		{tr("GUERIR|- Non, c'est pour gurir votre fils madame.")});
	elseif (msg == "GUERIR") then
		ingredient0 = 1;
		self:add_message(ent,
		tr("Vraiment ? Tenez en voila, je m'apprtais a les mettre dans ma marmite, vous avez de la chance !"),
		{tr("CIAO|-  Je vous remercie. Je reviens bientt avec un remde...")});
	elseif (msg == "VOILA") then
		self.state = 666;
		self:add_message(ent,
		tr("Vous tes une envoye de Moujell lui-mme ! Merci encore pour tout."),
		{tr("CIAO|- Mais de rien. Je suis content d'avoir reussi a finir cette dmo :-)")});	
	end
	return 1;
end
