/*
 * Copyright (c) 2000-2001 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

/* ArgusOutput.h */
/* ArgusOutput.h  is an amalgum of declarations, defines and routines from
 * interface.h, cons_sockets.c, 
 *
 */


#ifndef ArgusOutput_h
#define ArgusOutput_h

#define PARENTSIDE		0
#define CLIENTSIDE		1

#define ARGUS_MONITORPORT	561
#define ARGUS_MAXLISTEN		5


#include <unistd.h>
#include <stdlib.h>
#include <limits.h>

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <strings.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>

#if defined(__NetBSD__)
#include <sys/sched.h>
#else
#include <sched.h>
#endif

#include <fcntl.h>
#include <signal.h>

#include <pcap.h>
#include <argus_filter.h>

#ifdef ARGUS_SASL
#include <sasl.h>
#endif

struct ArgusClientData {
   int fd, pid;
   int pipe[2];
   struct ArgusSocketStruct *sock;
#ifdef ARGUS_SASL
   sasl_conn_t *sasl_conn;
#endif
};

struct ArgusOutputStruct {
   pid_t pid;
   int clienttags;
   struct ArgusClientData client[ARGUS_MAXLISTEN];
};

struct ArgusWfileStruct {
   char *filename;
   char *filter;
};


#if defined(ArgusOutput)

struct ArgusOutputStruct *ArgusOutputTask = NULL;

struct ArgusRecord ArgusSystemMarBuffer;
struct ArgusRecord *ArgusSystemMar = &ArgusSystemMarBuffer;

struct ArgusListStruct *ArgusWfileList = NULL;

struct timeval ArgusReportTime = {0, 0};
struct timeval ArgusMarReportInterval = {0, 0};
struct timeval ArgusLastMarUpdateTime = {0, 0};

int ArgusOutputPipe[2] = {-1, -1};

char *ArgusWfile = NULL;
//int ArgusPortNum = ARGUS_MONITORPORT;
int ArgusPortNum = 0;
char *ArgusBindIP = NULL;
int ArgusLfd = -1;
int ArgusOutfd = -1;
unsigned int ArgusOutputSequence = 1;

struct ArgusOutputStruct * ArgusNewOutput (void);
void ArgusDeleteOutput (void);
 
void ArgusInitOutput (void);
void ArgusInitOutputProcess(void);

void ArgusGenerateInitialMar (void);
void ArgusGenerateStatusMar (void);
void ArgusGenerateClosingMar (unsigned char);

void ArgusSendOutputData(int, struct ArgusRecord *);
int ArgusHandleData(struct ArgusSocketStruct *, unsigned char *, int, void *);
int ArgusHandleClientData(struct ArgusSocketStruct *, unsigned char *, int, void *);

void ArgusSendInitialMar (int);
void ArgusSendStatusMar (int);
void ArgusSendClosingMar (int, unsigned char);

void ArgusOutputProcess(void);
void *ArgusClientProcess(struct ArgusClientData *, struct ArgusWfileStruct *);

int getArgusLfd(void);
char *getArgusWfile(void);
int getArgusPortNum(void);

struct timeval *getArgusMarReportInterval(void);
  
void clearArgusWfile(char *, char *); 
void setArgusLfd(int);
void setArgusWfile(char *, char *);
void setArgusPortNum(int, char *);
void setArgusMarReportInterval(char *);
 
void ArgusCheckClientStatus (void);
 
int  ArgusEstablishListen(int, char *, char *);
int  ArgusTcpWrapper (int, struct sockaddr *);
 
void ArgusCloseSocket (int);
void ArgusCloseClients (void);

void ArgusUsr1Sig (int);
void ArgusUsr2Sig (int);
void ArgusChildExit (int);

void ArgusClientError(void);
void ArgusInitClientProcess(struct ArgusClientData *, struct ArgusWfileStruct *);

extern int ArgusFilterCompile(pcap_t *, struct bpf_program *, char *, int, unsigned int);
extern unsigned int argus_filter (struct bpf_insn *, unsigned char *);


#else

extern struct timeval ArgusReportTime;
extern struct ArgusRecord *ArgusSystemMar;
extern struct ArgusListStruct *ArgusWfileList;
extern int ArgusOutputPipe[2];

extern char *ArgusWfile;
extern int ArgusPortNum;
extern char *ArgusBindIP;
extern int ArgusLfd;
extern int ArgusOutfd;
extern unsigned int ArgusOutputSequence;

extern struct ArgusOutputStruct *ArgusOutputTask;
extern struct ArgusOutputStruct * ArgusNewOutput (void);
extern void ArgusDeleteOutput (void);

extern void ArgusInitOutput (void);
extern void ArgusInitOutputProcess(void);

extern void ArgusGenerateInitialMar (void);
extern void ArgusGenerateStatusMar (void);
extern void ArgusGenerateClosingMar (unsigned char);

extern void ArgusSendOutputData(int, struct ArgusRecord *);
extern int ArgusHandleData(struct ArgusSocketStruct *, unsigned char *, int, void *);
extern int ArgusHandleClientData(struct ArgusSocketStruct *, unsigned char *, int, void *);

extern void ArgusSendInitialMar (int);
extern void ArgusSendStatusMar (int);
extern void ArgusSendClosingMar (int, unsigned char);

extern void ArgusOutputProcess(void);
extern void *ArgusClientProcess(struct ArgusClientData *, struct ArgusWfileStruct *);

extern int getArgusLfd(void);
extern void setArgusLfd(int);

extern char *getArgusWfile(void);
extern void setArgusWfile(char *, char *);

extern int getArgusPortNum(void);
extern struct timeval *getArgusMarReportInterval(void);
extern void setArgusPortNum(int, char *);
extern void setArgusMarReportInterval(char *);

extern void ArgusCheckClientStatus (void);

extern int  ArgusEstablishListen(int, char *, char *);
extern int  ArgusTcpWrapper (int, struct sockaddr *);

extern void ArgusCloseSocket (int);
extern void ArgusCloseClients (void);

extern void ArgusUsr1Sig (int);
extern void ArgusUsr2Sig (int);

extern void ArgusClientError(void);
extern void ArgusInitClientProcess(struct ArgusClientData *, struct ArgusWfileStruct *);



#endif
#endif /* #ifndef ArgusOutput_h */

