/*
 * Copyright (c) 2000-2001 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef RaSort_h
#define RaSort_h

#include <stdlib.h>

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <netinet/in.h>
#include <argus-namedb.h>
#include <argus_filter.h>
 

struct ArgusQueueHeader {
   int status, index;
   struct timeval lasttime, logtime;
};

struct RaQueueStruct {
   int head, tail, count, size;
   struct ArgusQueueHeader **array;
};


struct ArgusRecordStore {
   struct ArgusQueueHeader qhdr;
   int status;
   struct ArgusRecord *argus;
};

int RaInitialized = 0;

void RaSendArgusRecord(struct ArgusRecordStore *);
struct ArgusRecord *RaCopyArgusRecord (struct ArgusRecord *);

struct RaQueueStruct *RaNewQueue (int);
void RaDeleteQueue (struct RaQueueStruct *);

int RaGetQueueCount(struct RaQueueStruct *);

void RaPushQueue(struct RaQueueStruct *, struct ArgusQueueHeader *);
void RaAddToQueue(struct RaQueueStruct *, struct ArgusQueueHeader *);

struct ArgusQueueHeader *RaPopQueue(struct RaQueueStruct *);
struct ArgusQueueHeader *RaRemoveFromQueue(struct RaQueueStruct *, struct ArgusQueueHeader *);

void RaEmptyQueue(struct RaQueueStruct *);

void RaPackQueue (struct RaQueueStruct *);
void RaSortQueue (struct RaQueueStruct *);

struct RaQueueStruct *RaArgusRecordQueue = NULL;

long long RaGetActiveDuration (struct ArgusRecord *);
long long RaGetuSecDuration (struct ArgusRecord *);

#endif
