/*
 * Copyright (c) 2000 QoSient, LLC
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of QoSient not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * QOSIENT, LLC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL QOSIENT, LLC BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * parsePortNum
 *       this module parses an IANA file to generate the port number
 *       file used by rasrvstats() and others.
 *
 * written by Carter Bullard
 * QoSient, LLC
 *
 */


#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>

#include <netinet/in.h>
#include <string.h>
#include <sys/stat.h>

char *portNumFile = NULL;
char *ProgramName = NULL;

void usage (void);
void parsePortNumInit (void);
void parsePortNums (char *);
void printOutPortNums (void);


void
usage ()
{
   fprintf (stderr, "usage: %s -f input\n", ProgramName);
   _exit (1);
}

void
parsePortNumInit ()
{

}


char *getoptStr = "f:";
int
main (int argc, char **argv)
{
   int op;
   extern char *optarg;
   extern int optind, opterr;

   opterr = 0;
   ProgramName = argv[0];

   while ((op = getopt (argc, argv, getoptStr)) != EOF) {
      switch (op) {
         case 'f': portNumFile = optarg; break;
          default:  usage ();
            /* NOTREACHED */
      }
   }
 
   if (portNumFile == NULL)
      portNumFile = "-";

   parsePortNumInit ();
   parsePortNums (portNumFile);
   printOutPortNums();

   _exit (0);
}

#define MAXSTRLEN	1024
#include <stdlib.h>
#include <ctype.h>

void
parsePortNums (char *file)
{
   int lines = 0, len = 0;
   char *strend;

   char buf[MAXSTRLEN], *str = buf;
   char *srvname = NULL;
   char *port = NULL;
   char *proto = NULL;
   char *desc = NULL;
   char *ptr, *tmp;
   FILE *fd;

   if (file) {
      if ((fd = fopen (file, "r")) != NULL) {
         while ((fgets(str, MAXSTRLEN, fd)) != NULL)  {
            lines++;

/*
dbbrowse        47557/tcp  Databeam Corporation
*/

            if (*str && (*str != '#') && (*str != '\n') && (*str != '!')) {
               if (strstr (str, "/udp") || strstr (str, "/tcp")) {
                  len = strlen(str);
                  strend = str + len;

                  ptr = str;
                  while  (!isspace(*ptr)) ptr++;
                  *ptr++ = '\0';
                  srvname = str;
                  while  (isspace(*ptr)) ptr++;
                  port = ptr;
                  if ((proto = strchr (port, '/')) != NULL) {
                     *proto++ = '\0';
                     ptr = proto;
                     while  (!isspace(*ptr)) ptr++;
                     *ptr++ = '\0';
                  }

                  if (ptr < strend) {
                     while (isspace(*ptr)) ptr++;
                     desc = ptr;
                     tmp = NULL;
                     while (*ptr != '\n') {
                        if (isspace(*ptr)) {
                           if (tmp == NULL)
                              tmp = ptr;
                        } else
                           tmp = NULL;
                        ptr++;
                     }
                     if (tmp != NULL)
                        *tmp = '\0';
                     else
                        *ptr = '\0';
                  }

                  if ((port == NULL) || (proto == NULL))
                     printf ("parse error line %d\n", lines);
                  else {
                     int start, end, i;

                     proto = (strcmp (proto, "tcp")) ? "6" : "17";

                     if (srvname == NULL)
                        srvname = "";
                     if (desc == NULL)
                        desc = "";

                     if ((ptr = strchr(port, '-')) != NULL) {
                        start = atoi(port);
                        end   = atoi(ptr + 1);
                     } else {
                        start = atoi(port);
                        end   = atoi(port);
                     }

                     for (i = start; i < (end + 1); i++) {
                        printf ("0 0 %-2s %-5d \"%s\" \"%s\"\n", proto, i, srvname, desc);
                        fflush(stdout);
                     }
                  }

                  srvname = NULL; port = NULL; proto = NULL; desc = NULL;
               }
            }
         }

      } else 
         fprintf (stdout, "input file '%s' %s\n", file, strerror(errno));
   }
}

void
printOutPortNums()
{

}
