/*

   Argante virtual OS
   ------------------

   Compiler - language specification file.

   Status: done

   Author:     Michal Zalewski <lcamtuf@ids.pl>
   Maintainer: Michal Zalewski <lcamtuf@ids.pl>
   Bugfix:     Mariusz Woloszyn (Kil3r) <kil3r@dione.ids.pl>

*/

struct op_desc {
  char  name[40];
  char  bcode;  // Was buggy...
  int   params;
  char  imm1,ureg1,sreg1,freg1,immptr1,uptr1;
  char  imm2,ureg2,sreg2,freg2,immptr2,uptr2;
};

#define OPS (sizeof(op)/sizeof(struct op_desc))

struct op_desc op[] =
{ 

// mnemonic     opcode	params	1:i,u,s,f,I,U	2:i,u,s,f,I,U

  {"nop",	0,	0,	  0,0,0,0,0,0,	  0,0,0,0,0,0},
  {"jmp",	1,	1,	  1,1,0,0,1,1,	  0,0,0,0,0,0},
  {"ifeq",	2,	2,	  1,1,1,1,1,1,	  1,1,1,1,1,1},
  {"ifneq",	3,	2,	  1,1,1,1,1,1,	  1,1,1,1,1,1},
  {"ifabo",	4,	2,	  1,1,1,1,1,1,	  1,1,1,1,1,1},
  {"ifbel",	5,	2,	  1,1,1,1,1,1,	  1,1,1,1,1,1},
  {"call",	6,	1,	  1,1,0,0,1,1,	  0,0,0,0,0,0},
  {"ret",	7,	1,	  1,1,0,0,1,1,	  0,0,0,0,0,0},
  {"halt",	8,	0,	  0,0,0,0,0,0,	  0,0,0,0,0,0},
  {"syscall",	9,	1,	  1,1,0,0,1,1,	  0,0,0,0,0,0},
  {"add",	10,	2,	  0,1,1,1,1,1,	  1,1,1,1,1,1},
  {"sub",	11,	2,	  0,1,1,1,1,1,	  1,1,1,1,1,1},
  {"mul",	12,	2,	  0,1,1,1,1,1,	  1,1,1,1,1,1},
  {"div",	13,	2,	  0,1,1,1,1,1,	  1,1,1,1,1,1},
  {"mod",	14,	2,	  0,1,1,0,1,1,	  1,1,1,0,1,1},
  {"xor",	15,	2,	  0,1,1,0,1,1,	  1,1,1,0,1,1},
  {"rev",	16,	1,	  0,1,1,0,1,1,	  0,0,0,0,0,0},
  {"not",	17,	1,	  0,1,1,0,1,1,	  0,0,0,0,0,0},
  {"and",	18,	2,	  0,1,1,0,1,1,	  1,1,1,0,1,1},
  {"or",	19,	2,	  0,1,1,0,1,1,	  1,1,1,0,1,1},
  {"mov",	20,	2,	  0,1,1,1,1,1,	  1,1,1,1,1,1},
  {"cwait",	21,	1,	  1,1,1,0,1,1,	  0,0,0,0,0,0},
  {"twait",	22,	1,	  1,1,1,0,1,1,	  0,0,0,0,0,0},
  {"alloc",	23,	2,	  1,1,1,0,1,1,	  1,1,1,0,1,1},
  {"realloc",	24,	2,	  1,1,1,0,1,1,	  1,1,1,0,1,1},
  {"dealloc",	25,	1,	  1,1,1,0,1,1,	  0,0,0,0,0,0},
  {"cmpcnt",	26,	2,	  1,1,1,0,1,1,	  1,1,1,0,1,1},
  {"cpcnt",	27,	2,	  1,1,1,0,1,1,	  1,1,1,0,1,1},
  {"onfail",	28,	1,	  1,1,0,0,1,1,	  0,0,0,0,0,0},
  {"nofail",	29,	0,	  0,0,0,0,0,0,	  0,0,0,0,0,0},
  {"loop",	30,	1,	  1,1,0,0,1,1,	  0,0,0,0,0,0},
  {"raise",	31,	1,	  1,1,0,0,1,1,	  0,0,0,0,0,0},
  {"ldb",	32,	2,	  0,1,1,1,1,1,	  1,1,1,0,1,1},
  {"setstack",	33,	2,	  1,1,0,0,1,1,	  1,1,0,0,1,1},
  {"pushs",	34,	1,	  1,1,1,1,1,1,	  0,0,0,0,0,0},
  {"pops",	35,	1,	  0,1,1,1,1,1,	  0,0,0,0,0,0},
  {"stob",	36,	2,	  0,1,1,0,1,1,	  1,1,1,0,1,1},
};
