# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman, Enno Cramer, 2005 Thomas Gerigk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.006;
use strict;
use warnings;

package ArchWay::MainWindow::Graph;

use base 'ArchWay::MainWindow::Base';

use Glib qw(TRUE FALSE);
use Gtk2;

use ArchWay::Widget::PartnerVersions_indexed;
use ArchWay::Util::RevisionCollector;
use ArchWay::Util::RenderNodes_AA;
use ArchWay::Util::TreeVersions;

sub init ($) {
	my $self = shift;

	$self->SUPER::init;

	# init ui
	$self->set_default_size(800, 600);
	$self->main_widget->set_position(180);
}

sub main_widget ($) {
	my $self = shift;
	
	if (! exists $self->{main_widget}) {
		$self->_prepare_main_window;
		
		my $scwin = Gtk2::ScrolledWindow->new;
		$scwin->set_policy('automatic', 'automatic');
		$scwin->add($self->partners_view());
		
		my $tbuffer = Gtk2::TextBuffer->new();
		$tbuffer->set_text($self->{renderer}->render());
		my $tview = Gtk2::TextView->new_with_buffer($tbuffer);
		$tview->set_cursor_visible(FALSE);
		$tview->set_wrap_mode("none");
		$tview->set_editable(FALSE);
		my $fontdesc = Gtk2::Pango::FontDescription->new();
		# use "Courier" to avoid a hole in the drawing vertical line
		my $ff = $ENV{ARCHWAY_GRAPH_DRAWING_CHARS}
			? "Courier, monospace"
			: "monospace";
		$fontdesc->set_family($ff);
		$tview->modify_font($fontdesc);
		my $scwin2 = Gtk2::ScrolledWindow->new();
		$scwin2->set_policy("automatic", "automatic");
		$scwin2->add($tview);
		
		my $vpaned = Gtk2::VPaned->new();
		$vpaned->pack1($scwin, TRUE, TRUE);
		$vpaned->pack2($scwin2, TRUE, TRUE);
		
		$self->{main_widget} = $vpaned;
	}
	
	return $self->{main_widget};
}

sub partners_view ($) {
	my $self = shift;
	my $treeversions = $self->{version_store};
	
	if (! exists $self->{partners_view}) {
		my $partners_view = ArchWay::Widget::PartnerVersions_indexed->new(
			$treeversions, $self
		);
		
		$self->{partners_view} = $partners_view;
		
		# set indizes
		foreach my $version ( keys %{$self->{renderer}->{nodes}} ) {
			$partners_view->set_index($self->{renderer}->{kon}->{$version}->{letter} , $version);
		}
	}
	
	return $self->{partners_view};
}

sub _prepare_main_window {
	my $self = shift;
	
	my $version;
	
	my $version_store = ArchWay::Util::TreeVersions->new($self->tree);
	$self->{version_store} = $version_store;
	
	my $collector = ArchWay::Util::RevisionCollector->new();
	
	# add related versions to collector
	foreach $version ( keys %{$version_store->all()} ) {
		$collector->add_version_for_read ($version);
	}
	$collector->read_tree($self->tree->root());
	# XXX possibly add button to reread from
	#     local (only) or (all) remote archives
	$collector->reread_from_local_archives();
	
	$collector->reduce_merges();
	my $renderer = ArchWay::Util::RenderNodes_AA->new($collector);
	# 1 = ascii-chars
	# 2 = box-drawing-chars
	$renderer->set_graph_char_set($ENV{ARCHWAY_GRAPH_DRAWING_CHARS});
	$self->{renderer} = $renderer;
	
	# add possibly yet unknown version to treeversions
	# XXX (is this a problem?)
	foreach $version ( keys %{$renderer->{nodes}} ) {
		$version_store->set($version);
	}
	$version_store->sync();
}

sub tree ($) {
	my $self = shift;
	
	return $self->{tree};
}

1;

__END__
