/* tag: Tom Lord Tue Dec  4 14:41:26 2001 (unit-reply.c)
 */
/* unit-reply.c -
 *
 ****************************************************************
 * Copyright (C) 2001  Tom Lord
 * 
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/cmd/main.h"
#include "ftp-utils/client/reply.h"



static t_uchar * program_name = "unit-reply";
static t_uchar * usage = "USAGE STRING NOT PROVIDED";
static t_uchar * version_string = "VERSION STRING NOT PROVIDED";

#define OPTS(OP, OP2) \
  OP (opt_help_msg, "h", "help", 0, \
      "Display a help message and exit.") \
  OP (opt_version, "V", "version", 0, \
      "Display a release identifier string") \
  OP2 (opt_version, 0, 0, 0, "and exit.")

enum options
{
  OPTS (OPT_ENUM, OPT_IGN)  
};

struct opt_desc opts[] = 
{
  OPTS (OPT_DESC, OPT_DESC)
    {-1, 0, 0, 0, 0}
};



int
main (int argc, char * argv[])
{
  int o;
  struct opt_parsed * option;

  option = 0;

  while (1)
    {
      o = opt_standard (lim_use_must_malloc, &option, opts, &argc, argv, program_name, usage, version_string, 0, opt_help_msg, opt_none, opt_version);
      if (o == opt_none)
	break;
      switch (o)
	{
	default:
	  safe_printfmt (2, "unhandled option `%s'\n", option->opt_string);
	  panic ("internal error parsing arguments");

	usage_error:
	  opt_usage (2, argv[0], program_name, usage, 1);
	  panic_exit ();

	/* bogus_arg: */
	  safe_printfmt (2, "ill-formed argument for `%s' (`%s')\n", option->opt_string, option->arg_string);
	  goto usage_error;
	}
    }


  {
    int code;
    t_uchar * text;
    long text_len;
    int errn;
    
    if (0 > ftp_client_read_reply (0, &errn, &code, &text, &text_len, 0))
      {
	safe_printfmt (2, "ftp_client_read_reply error (%d)\n", errn);
      }
    else
      {
	safe_printfmt (1, "%d\n", code);
	safe_write (1, text, text_len);
      }
  }
  
  return 0;
}

