/***************************************************************************
 $RCSfile: pinmanager.h,v $
                             -------------------
    cvs         : $Id: pinmanager.h,v 1.3 2003/05/18 03:02:12 aquamaniac Exp $
    begin       : Thu Apr 03 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/



#ifndef PINMANAGER_H
#define PINMANAGER_H


#include <openhbci.h>
#include "globals.h"
using namespace HBCI;

#include <string>
#include <list>
#include <stdio.h>
using namespace std;


class  PinManager:public HBCI::Auth {
private:
  Hbci *_hbci;
  list<string> _pinList;

  HBCI::Error readLine(FILE *f, string &s);

public:
  /**
   * Constructor.
   * @author Martin Preuss<openhbci@aquamaniac.de>
   * @param hbci pointer to central HBCI object
   */
  PinManager(Hbci *hbci);

  virtual ~PinManager();

  /**
   * This method retrieves a PIN and writes it into the string
   * reference argument 'secret'.
   *
   * The default implementation calls @ref
   * Interactor::msgInputPin().  If you want to retrieve the PIN
   * by any other means, you can provide your own derivation of
   * Auth and override this method.  You may use the given token
   * to identify the secret.
   *
   * @author Martin Preuss<openhbci@aquamaniac.de>
   *
   * @return returns a Error object to show the result. Call
   * "isOk()" on it, to see if any error occurred.
   *
   * @param user pointer to the user for whom the secret is to be retrieved
   * From this user object you can get all information you might need to
   * show an explanatory dialog.
   *
   * @param token A string providing additional information to
   * identify the PIN OpenHBCI is asking for. When a MediumDDV
   * (chip card) asks for a pin, it shows here the "cardnumber",
   * whereas a MediumRDH presents the "path/filename" of the
   * medium to be accessed.
   *
   * @param secret reference to a string to receive the secret
   * (e.g. the pin).
   *
   * @param createSecret if true then a new secret is to be created.
   * In this case the user should be asked to enter the pin twice.  */
  virtual HBCI::Error getSecret(Pointer<HBCI::User> user,
			  const string &token,
			  string &secret,
			  bool createSecret=false);

  HBCI::Error readPinList(FILE *f);

  HBCI::Error addSecret(const string &token,
		  const string &secret);
};


#endif



