/***************************************************************************
 $RCSfile: pinmanager.cpp,v $
                             -------------------
    cvs         : $Id: pinmanager.cpp,v 1.6 2003/06/05 18:11:40 aquamaniac Exp $
    begin       : Thu Apr 03 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "pinmanager.h"



PinManager::PinManager(Hbci *hbci)
  :HBCI::Auth(hbci)
  ,_hbci(hbci)
{

}


PinManager::~PinManager(){
}


HBCI::Error PinManager::getSecret(HBCI::Pointer<HBCI::User> user,
				  const string &token,
				  string &secret,
				  bool createSecret){
  list<string>::iterator it;

  if (_pinList.size() & 1) {
    return HBCI::Error("PinManager::readPinList",
		       ERROR_LEVEL_CRITICAL,
		       HBCI_ERROR_CODE_PIN_ABORTED,
		       ERROR_ADVISE_SHUTDOWN,
		       "Bad pin list");
  }
  for (it=_pinList.begin();
       it!=_pinList.end();
       it++) {
    if ((*it)==token) {
      it++;
      secret=*it;
      return HBCI::Error();
    }
    it++;
  } // for

  if (_hbci->debugLevel()>0)
    fprintf(stderr,"Secret for token \"%s\" not found.\n", token.c_str());
  return HBCI::Error("PinManager::readPinList",
		     ERROR_LEVEL_CRITICAL,
		     HBCI_ERROR_CODE_PIN_ABORTED,
		     ERROR_ADVISE_SHUTDOWN,
		     "Pin not found");
}


HBCI::Error PinManager::readLine(FILE *f, string &s){
  char *p;
  char buffer[512];
  int j;
  int i;
  char c;

  j=0;
  p=buffer;
  while (j<(int)(sizeof(buffer)-1)) {
    i=read(0, &c, 1);
    if (i==0) {
      return HBCI::Error();
    }
    else if (i<0) {
      return HBCI::Error("PinManager::readPinList",
			 ERROR_LEVEL_CRITICAL,
			 HBCI_ERROR_CODE_PIN_ABORTED,
			 ERROR_ADVISE_SHUTDOWN,
			 "No pin list");
    }
    if (c==10)
      break;
    *p=c;
    p++;
    j++;
  }
  *p=0;

  s=buffer;
  return HBCI::Error();
}


HBCI::Error PinManager::readPinList(FILE *f){
  HBCI::Error err;
  string str;
  string token;
  string secret;
  unsigned int i;

  // check for "PINLIST"
  err=readLine(f, str);
  if (!err.isOk())
    return err;
  if (str!="PINLIST") {
    return HBCI::Error("PinManager::readPinList",
		       ERROR_LEVEL_CRITICAL,
		       HBCI_ERROR_CODE_PIN_ABORTED,
		       ERROR_ADVISE_SHUTDOWN,
		       "No pin list found");
  }

  // read pin lines
  while(1) {
    err=readLine(f, str);
    if (!err.isOk())
      return err;
    if (str.empty()) {
      // done
      break;
    }

    /*  remove comments */
    i=str.rfind("#");
    if (i!=string::npos) {
      str=str.substr(0,i);
    }

    i=str.find("=");
    if (i==string::npos) {
      return HBCI::Error("PinManager::readPinList",
			 ERROR_LEVEL_CRITICAL,
			 HBCI_ERROR_CODE_PIN_ABORTED,
			 ERROR_ADVISE_SHUTDOWN,
			 "Missing \"=\"");
    }
    // ok, we have a "="
    token="";
    secret="";
    if (i>0)
      // read token
      token=str.substr(0,i);
    if (i+1<str.length())
      // read secret
      secret=str.substr(i+1);

    // check
    if (secret.empty() || token.empty()) {
      return HBCI::Error("PinManager::readPinList",
			 ERROR_LEVEL_CRITICAL,
			 HBCI_ERROR_CODE_PIN_ABORTED,
			 ERROR_ADVISE_SHUTDOWN,
			 "Missing secret/token");
    }

    //save both
    _pinList.push_back(token);
    _pinList.push_back(secret);
  } // while

  return HBCI::Error();
}


HBCI::Error PinManager::addSecret(const string &token,
				  const string &secret){
  // check
  if (secret.empty()||token.empty()) {
    return HBCI::Error("PinManager::readPinList",
		       ERROR_LEVEL_CRITICAL,
		       HBCI_ERROR_CODE_PIN_ABORTED,
		       ERROR_ADVISE_SHUTDOWN,
		       "Missing secret/token");
  }
  //save both
  _pinList.push_back(token);
  _pinList.push_back(secret);
  return HBCI::Error();
}



