/***************************************************************************
 $RCSfile: dump.cpp,v $
                             -------------------
    cvs         : $Id: dump.cpp,v 1.16 2003/06/13 22:41:20 aquamaniac Exp $
    begin       : Sun Jan 27 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <string>
#include "xactionmatcher.h"
#include "dump.h"


#define ROWS 20
#define COLS 4

#define SIZE_DATE    12
#define SIZE_TEXT    16
#define SIZE_NAME    30
#define SIZE_PURPOSE 30
#define SIZE_VALUE   30
#define SIZE_ALL (SIZE_DATE+SIZE_TEXT+SIZE_NAME+SIZE_VALUE+9)



HBCI::Value convertValue(const HBCI::Value &v,const string &curr) {
    if (v.getCurrency()==curr)
        return v;

    if (curr=="EUR") {
        if (v.getCurrency()=="DEM")
            return HBCI::Value(v.getValue()*1.95583,"EUR");
    }
    else if (curr=="DEM") {
        if (v.getCurrency()=="EUR")
            return HBCI::Value(v.getValue()*0.511292,"DEM");
    }

    fprintf(stderr,
            "Cannot convert currency (%s -> %s)\n",
            v.getCurrency().c_str(),
            curr.c_str());
    return HBCI::Value(0,curr);
}


bool _xactionToEntry(const AQMTransaction &t,
		     string *e,
		     int &height) {
  string tmp1;
  string date;
  list<string> text;
  list<string>name;
  list<string>purpose;
  string value;
  list<string>::const_iterator iter;
  int i;
  HBCI::Date tdate;

  height=0;
  // date
  tdate=t.valutaDate();
  if (!tdate.isValid())
    tdate=t.date();
  date=HBCI::String::num2string(tdate.day());
  date+=".";
  date+=HBCI::String::num2string(tdate.month());
  date+=".";
  date+=HBCI::String::num2string(tdate.year());

  // text (and status)
  if (t.transactionText().empty()) {
    if (t.transactionCode()==51)
      text.push_back("Ueberweisung");
    else if (t.transactionCode()==5 || t.transactionCode()==6)
      text.push_back("Lastschrift");
    else {
      text.push_back(String::num2string(t.transactionCode()));
    }
  }
  else {
    text.push_back(t.transactionText().substr(0,SIZE_TEXT));
  }
#if 0
  if (t.status().result()!=-1) {
    text.push_back("");
    tmp1="(";
    if (t.status().resultText().empty()) {
      tmp1+=String::num2string(t.status().result());
    }
    else {
      tmp1+=t.status().resultText();
    }
    tmp1+=")";
    text.push_back(tmp1);
  }
#endif

  // name
  for (iter=t.otherName().begin();
       iter!=t.otherName().end();
       iter++) {
    name.push_back(*iter);
  }

  // purpose
  for (iter=t.description().begin();
       iter!=t.description().end();
       iter++) {
    purpose.push_back(*iter);
  }

  // value
  if (t.value().getValue()>=0)
    value=" ";
  value+=t.value().toReadableString();

  // now put it together
  e[0]=date;

  i=0;
  for (iter=text.begin();
       iter!=text.end() && i<(ROWS-1);
       iter++) {
    e[1+(COLS*i)]=*iter;
    i++;
  }
  if (i>height)
    height=i;

  i=0;
  for (iter=name.begin();
       iter!=name.end() && i<(ROWS-1);
       iter++) {
    e[2+(COLS*i)]=*iter;
    i++;
  }
  e[2+(COLS*i)]="";
  i++;
  for (iter=purpose.begin();
       iter!=purpose.end() && i<(ROWS-1);
       iter++) {
    e[2+(COLS*i)]=*iter;
    i++;
  }
  if (i>height)
    height=i;
  if (!height)
    height=1;
  e[3]=value;

  return true;
}


string _entryToTable(string *e,int height, int row) {
    string result;
    string tmp;
    int i;

    if (row & 1)
        result="<TR bgcolor=\"white\">";
    else
        result="<TR bgcolor=\"lightyellow\">";
    // date
    result+="<TD>"+e[0]+"</TD>";
    // text
    result+="<TD ALIGN=\"center\">"+e[1]+"</TD>";

    // name/purpose
    tmp.erase();
    for (i=0; i<height; i++) {
        if (i)
            tmp+="<BR>";
        tmp+=e[i*COLS+2];
    }
    result+="<TD ALIGN=\"center\">"+tmp+"</TD>";

    // value
    result+="<TD ALIGN=\"right\">"+e[3]+"</TD>";

    result+="</TR>\n";
    return result;
}



string dumpXactionTXT(const AQMTransaction &t) {
    string e[COLS*ROWS];
    int i;
    string result;
    string tmp;
    int height;

    if (!_xactionToEntry(t,e,height))
        return "";
    for (i=0; i<(height*COLS); i+=COLS) {
        // date
        tmp=e[i+0];
        tmp=tmp.substr(0,SIZE_DATE);
        if (tmp.length()<SIZE_DATE)
            tmp+=string(SIZE_DATE-tmp.length(),' ');
        result+=tmp;
        result+=" | ";
        // text
        tmp=e[i+1];
        tmp=tmp.substr(0,SIZE_TEXT);
        if (tmp.length()<SIZE_TEXT)
            tmp+=string(SIZE_TEXT-tmp.length(),' ');
        result+=tmp;
        result+=" | ";
        // name / purpose
        tmp=e[i+2];
        tmp=tmp.substr(0,SIZE_NAME);
        if (tmp.length()<SIZE_NAME)
            tmp+=string(SIZE_NAME-tmp.length(),' ');
        result+=tmp;
        result+=" | ";
        // value
        tmp=e[i+3];
        tmp=tmp.substr(0,SIZE_VALUE);
        if (tmp.length()<SIZE_VALUE)
            tmp+=string(SIZE_VALUE-tmp.length(),' ');
        result+=tmp;
        result+="\n";
    } // for
    return result;
}


string dumpStandingOrderTXT(const HBCI::StandingOrder &sto) {
  string result;
  list<string>::iterator iter;

  result+="Dauerauftrag\n";
  result+=string(SIZE_ALL,'-')+"\n";
  result+="Auftragsnummer     : ";
  result+=sto.jobIdentification()+"\n";

  result+="Empfnger\n";
  result+="  Konto            : ";
  result+=sto.otherAccountId()+"\n";

  result+="  Lndercode       : ";
  result+=HBCI::String::num2string(sto.otherCountryCode())+"\n";
  result+="  Bankleitzahl     : ";
  result+=sto.otherBankCode()+"\n";
  result+="  Name             : ";
  list<string> name = sto.otherName();
  for (iter = name.begin(); iter != name.end(); iter++)
    result += (*iter) + "\n";
  result+="Betrag             : ";
  result+=sto.value().toReadableString()+"\n";

  result+="Verwendungszweck   : ";
  list<string> purpose = sto.description();
  if (purpose.empty())
    result+="\n";
  else
    for (iter = purpose.begin(); iter != purpose.end(); iter++)
      result += (*iter)+ "\n";

  result+="Textschlssel      : ";
  result+=sto.transactionCode();
  result+="\n";
  result+="Erste Ausfhrung   : ";
  result+=sto.firstExecutionDate().toString()+"\n";
  result+="Letzte Ausfhrung  : ";
  result+=sto.lastExecutionDate().toString()+"\n";
  result+="Nchste Ausfhrung : ";
  result+=sto.executionDate().toString()+"\n";
  result+="Zyklus             : ";
  if (sto.period()==HBCI::StandingOrder::EXECUTE_MONTHLY) {
    if (sto.cycle()==1)
      result+="jeden Monat";
    else {
      result+="alle ";
      result+=HBCI::String::num2string(sto.cycle())+" ";
      result+="Monate";
    }
  }
  else {
    if (sto.cycle()==1)
      result+="jede Woche";
    else {
      result+="alle ";
      result+=HBCI::String::num2string(sto.cycle())+" ";
      result+="Wochen";
    }
  }
  result+="\n";

  return result;
}


string dumpStandingOrderHTML(const HBCI::StandingOrder &sto) {
  string result;
  list<string>::iterator iter;

  result+="<h5>Dauerauftrag</h5>\n";
  result+="<TABLE BORDER=1>";
  result+="<tr><td>Auftragsnummer</td><td>";
  result+=sto.jobIdentification()+"</td></tr>\n";

  result+="<tr><td>Empf&auml;nger</td><td>\n";
  result+=sto.otherAccountId()+"</td></tr>\n";

  result+="<tr><td>Konto</td><td>";
  result+=HBCI::String::num2string(sto.otherCountryCode())+"</td></tr>\n";
  result+="<tr><td>Bankleitzahl</td><td>";
  result+=sto.otherBankCode()+"</td></tr>\n";
  result+="<tr><td>Name</td><td>";
  list<string> name = sto.otherName();
  for (iter = name.begin(); iter != name.end(); iter++)
    result += (*iter) + "<br>\n";
  result+="</td></tr>";
  result+="<tr><td>Betrag</td><td>";
  result+=sto.value().toReadableString()+"</td></tr>\n";

  result+="<tr><td>Verwendungszweck</td><td>";
  list<string> purpose = sto.description();
  for (iter = purpose.begin(); iter != purpose.end(); iter++)
    result += (*iter)+ "<br>\n";
  result += "</td></tr>\n";

  result+="<tr><td>Textschl&uuml;ssel</td><td>";
  result+=sto.transactionCode();
  result+="</td></tr>\n";
  result+="<tr><td>Erste Ausf&uuml;hrung</td><td>";
  result+=sto.firstExecutionDate().toString();
  result+="</td></tr>\n";
  result+="<tr><td>Letzte Ausf&uuml;hrung</td><td>";
  result+=sto.lastExecutionDate().toString();
  result+="</td></tr>\n";
  result+="<tr><td>N&auml;chste Ausf&uuml;hrung</td><td>";
  result+=sto.executionDate().toString();
  result+="</td></tr>\n";
  result+="<tr><td>Zyklus</td><td>";
  if (sto.period()==HBCI::StandingOrder::EXECUTE_MONTHLY) {
    if (sto.cycle()==1)
      result+="jeden Monat";
    else {
      result+="alle ";
      result+=HBCI::String::num2string(sto.cycle());
      result+=" Monate";
    }
  }
  else {
    if (sto.cycle()==1)
      result+="jede Woche";
    else {
      result+="alle ";
      result+=HBCI::String::num2string(sto.cycle());
      result+=" Wochen";
    }
  }
  result+="</td></tr>\n";

  result+="</table><br>";
  return result;
}


string condensedString(const string &s) {
  bool lastWasBlank;
  unsigned int i;
  string result;

  lastWasBlank=false;
  for (i=0; i<s.length(); i++) {
    if (s[i]==32 || s[i]==9) {
      if (!lastWasBlank) {
	result+=s[i];
      }
      lastWasBlank=true;
    }
    else {
      result+=s[i];
      lastWasBlank=false;
    }
  } // for
  return result;
}


string breakString(const string &s, unsigned int brk) {
  string result;
  unsigned int i;
  unsigned int lastBlankPos;
  unsigned int cnt;

  lastBlankPos=0;
  cnt=0;
  for (i=0; i<s.length(); i++) {
    if (s[i]==32 || s[i]==9)
      lastBlankPos=i;
    result+=s[i];
    cnt++;

    if (cnt>=brk && lastBlankPos) {
      result[lastBlankPos]='\n';
      lastBlankPos=0;
      cnt=0;
    }
  } // for
  return result;
}


string indentString(const string &s, unsigned int ins) {
  string result;
  unsigned int i;

  for (i=0; i<s.length(); i++) {
    result+=s[i];
    if (s[i]=='\n')
      result+=string(ins, ' ');
  } // for
  return result;
}


string dumpBankMessageTXT(const HBCI::instituteMessage &m) {
  string result;

  result+="Mitteilung vom ";
  result+=HBCI::String::num2string(m.date().day());
  result+=".";
  result+=HBCI::String::num2string(m.date().month());
  result+=".";
  result+=HBCI::String::num2string(m.date().year());
  result+=" um ";
  result+=HBCI::String::num2string(m.time().hour(),true,2);
  result+=":";
  result+=HBCI::String::num2string(m.time().minute(),true,2);
  result+=":";
  result+=HBCI::String::num2string(m.time().second(),true,2);
  result+="\n";
  result+=string(SIZE_ALL,'-')+"\n";
  result+="Betreff : ";
  result+=m.subject()+"\n";
  result+="Text    : ";
  result+=indentString(breakString(condensedString(m.text())+"\n",
				   SIZE_ALL-10),10);

  result+="\n";
  return result;
}


string dumpBankMessageHTML(const HBCI::instituteMessage &m) {
  string result;

  result+="<h5>Institutsmitteilung</h5>\n";
  result+="<table>";
  result+="<tr><td>";
  result+="<b>Datum</b>";
  result+="</td><td>";
  result+=m.date().toString()+"\n";
  result+="</td></tr>";
  result+="<tr><td>";
  result+="<b>Uhrzeit</b> ";
  result+="</td><td>";
  result+=m.time().toString()+"\n";
  result+="</td></tr>\n";
  result+="<tr><td>";
  result+="<b>Betreff</b> ";
  result+="</td><td>";
  result+=m.subject()+"\n";
  result+="</td></tr>";
  result+="<tr><td>";
  result+="<b>Text</b> ";
  result+="</td><td>";
  result+=condensedString(m.text());
  result+="\n";
  result+="</td></tr>\n";
  result+="</table>\n";
  result+="<br>\n";

  return result;
}


string dumpBalanceTXT(const HBCI::AccountBalance &b, 
		      const HBCI::Value &vin,
		      const HBCI::Value &vout) {
  string result;
  HBCI::Value tmpval;

  if (vin.getValue() || vout.getValue()) {
    result+="Einnahmen: ";
    result+=vin.toReadableString()+"  ";
    result+="Ausgaben : ";
    result+=vout.toReadableString()+"  ";
    result+="Saldo    : ";
    tmpval=HBCI::Value(vin.getValue()-vout.getValue(),vin.getCurrency());
    result+=tmpval.toReadableString()+" ";
    result+="\n";
  }
  if (!b.notedBalance().date().isValid()) {
    result+=" --- kein notierter Saldo ---";
  }
  else {
    result+="Notierter Saldo vom ";
    result+=HBCI::String::num2string(b.notedBalance().date().day());
    result+=".";
    result+=HBCI::String::num2string(b.notedBalance().date().month());
    result+=".";
    result+=HBCI::String::num2string(b.notedBalance().date().year());
    result+=" um ";
    result+=HBCI::String::num2string(b.notedBalance().time().hour(),true,2);
    result+=":";
    result+=HBCI::String::num2string(b.notedBalance().time().minute(),true,2);
    result+=":";
    result+=HBCI::String::num2string(b.notedBalance().time().second(),true,2);
    result+=" : ";
    result+=(b.notedBalance().isDebit())?"-":"+";
    result+=b.notedBalance().value().toReadableString();
    result+=" ";
    result+=b.currency();
  }
  result+="\n";
  if (!b.bookedBalance().date().isValid()) {
    result+=" --- kein gebuchter Saldo ---";
  }
  else {
    result+="Gebuchter Saldo vom ";
    result+=HBCI::String::num2string(b.bookedBalance().date().day());
    result+=".";
    result+=HBCI::String::num2string(b.bookedBalance().date().month());
    result+=".";
    result+=HBCI::String::num2string(b.bookedBalance().date().year());
    result+=" um ";
    result+=HBCI::String::num2string(b.bookedBalance().time().hour(),true,2);
    result+=":";
    result+=HBCI::String::num2string(b.bookedBalance().time().minute(),true,2);
    result+=":";
    result+=HBCI::String::num2string(b.bookedBalance().time().second(),true,2);
    result+=" : ";
    result+=(b.bookedBalance().isDebit())?"-":"+";
    result+=b.bookedBalance().value().toReadableString();
    result+=" ";
    result+=b.currency();
  }
  result+="\n";
  return result;
}


string dumpBalanceHTML(const HBCI::AccountBalance &b,
		       const HBCI::Value &vin,
		       const HBCI::Value &vout) {
  string result;
  HBCI::Value tmpval;

  result+="<h4>Saldo</h4>";
  if (vin.getValue() || vout.getValue()) {
    result+="<table><tr>";
    result+="<td><b>Einnahmen</b></td><td> ";
    result+=vin.toReadableString()+"</td> ";
    result+="<td><b>Ausgaben</b></td><td>";
    result+=vout.toReadableString()+"</td>";
    result+="<td><b>Saldo</b></td><td> ";
    if (vout<vin)
      result+="<font color=green>";
    else
      result+="<font color=red>";
    tmpval=HBCI::Value(vin.getValue()-vout.getValue(),vin.getCurrency());
    result+=tmpval.toReadableString()+"</font></td></tr>\n";
    result+="</table>\n";
  }
  if (!b.notedBalance().date().isValid()) {
    result+="<font color=red> --- kein notierter Saldo ---</font>";
  }
  else {
    result+="Notierter Saldo vom ";
    result+=HBCI::String::num2string(b.notedBalance().date().day());
    result+=".";
    result+=HBCI::String::num2string(b.notedBalance().date().month());
    result+=".";
    result+=HBCI::String::num2string(b.notedBalance().date().year());
    result+=" um ";
    result+=HBCI::String::num2string(b.notedBalance().time().hour(),true,2);
    result+=":";
    result+=HBCI::String::num2string(b.notedBalance().time().minute(),true,2);
    result+=":";
    result+=HBCI::String::num2string(b.notedBalance().time().second(),true,2);
    result+=" : ";
    result+=(b.notedBalance().isDebit())?"-":"+";
    if (b.notedBalance().isDebit())
      result+="<font color=red>";
    else
      result+="<font color=green>";
    result+=b.notedBalance().value().toReadableString();
    result+="</font> ";
    result+=b.currency();
  }
  result+="<br>\n";
  if (!b.bookedBalance().date().isValid()) {
    result+="<font color=red> --- kein gebuchter Saldo ---</font>";
  }
  else {
    result+="Gebuchter Saldo vom ";
    result+=HBCI::String::num2string(b.bookedBalance().date().day());
    result+=".";
    result+=HBCI::String::num2string(b.bookedBalance().date().month());
    result+=".";
    result+=HBCI::String::num2string(b.bookedBalance().date().year());
    result+=" um ";
    result+=HBCI::String::num2string(b.bookedBalance().time().hour(),true,2);
    result+=":";
    result+=HBCI::String::num2string(b.bookedBalance().time().minute(),true,2);
    result+=":";
    result+=HBCI::String::num2string(b.bookedBalance().time().second(),true,2);
    result+=" : ";
    result+=(b.bookedBalance().isDebit())?"-":"+";
    if (b.bookedBalance().isDebit())
      result+="<font color=red>";
    else
      result+="<font color=green>";
    result+=b.bookedBalance().value().toReadableString();
    result+="</font> ";
    result+=b.currency();
  }
  result+="<br>\n";
  return result;
}


string dumpAccountTXT(HBCI::Pointer<AQMAPI> hbciif,
		      HBCI::Pointer<HBCI::Account> acc,
		      unsigned int flags,
		      const HBCI::Date &fromdate,
		      const HBCI::Date &todate){
  string result;
  string tmp;
  HBCI::Pointer<HBCI::Bank> bank;
  HBCI::Balance bal;
  double vin=0.0;
  double vout=0.0;
  HBCI::Value tmpval;
  list<HBCI::StandingOrder>::const_iterator stit;
  TransactionMatcher tm;

  result+="Konto ";
  result+=acc.ref().accountId();
  // get institute name
  bank=acc.ref().bank();

  result+=" bei ";
  result+=bank.ref().name();

  result+=" (BLZ: ";
  result+=bank.ref().bankCode();
  result+=")\n";
  tm=TransactionMatcher(0,
			"*",
			"*",
			fromdate,
			todate,
			flags & 0xffff);

  if (flags & AQM_DUMP_FLAGS_XACTIONS) {
    if (acc.ref().transactions().empty())
      result+=" --- keine Umstze ---\n";
    else {
      result+="\nUmstze\n";
      result+=string(SIZE_ALL,'=')+"\n";
      for (list<HBCI::Transaction>::const_iterator i2=acc.ref().transactions().begin();
	   i2!=acc.ref().transactions().end(); i2++) {
	AQMTransaction aqmxa;

	aqmxa=*i2;
	if (!tm.match(aqmxa))
	  continue;
	// dump

	result+=dumpXactionTXT(aqmxa);
	result+=string(SIZE_ALL,'-');

	// compute values
	tmpval=convertValue((*i2).value(),"EUR");
	if (tmpval.getValue()<0)
	  vout+=-(tmpval.getValue());
	else
	  vin+=tmpval.getValue();

	result+="\n";
      } // for
    } // if there are xactions
  } // if wantXactions

  // show balance
  if (flags & AQM_DUMP_FLAGS_BALANCE) {
    result+="\nSaldo\n";
    result+=string(SIZE_ALL,'=')+"\n";
    result+=dumpBalanceTXT(acc.ref().balance(),
			   HBCI::Value(vin,acc.ref().currency()),
			   HBCI::Value(vout,acc.ref().currency()));
  }

  // show standing orders
  if (flags & AQM_DUMP_FLAGS_STO) {
    result+="\nDauerauftrge\n";
    result+=string(SIZE_ALL,'=')+"\n";
    if (acc.ref().standingOrders().empty()) {
      result+="--- keine ---\n";
    }
    else {
      for (stit=acc.ref().standingOrders().begin();
	   stit!=acc.ref().standingOrders().end();
	   stit++) {
	result+="\n";
	result+=dumpStandingOrderTXT(*stit);
      }
    }
  }

  return result;
}


string dumpAccountHTML(HBCI::Pointer<AQMAPI> hbciif,
                       HBCI::Pointer<HBCI::Account> acc,
		       unsigned int flags,
                       const HBCI::Date &fromdate,
                       const HBCI::Date &todate){
    list<HBCI::Transaction>::const_iterator iter;
    list<HBCI::StandingOrder>::const_iterator stit;
    string e[COLS*ROWS];
    int height;
    string result;
    string name;
    string descr;
    int row;
    HBCI::Pointer<HBCI::Bank> bank;
    double vin=0.0;
    double vout=0.0;
    HBCI::Value tmpval;
    TransactionMatcher tm;

    result+="<H2>Konto <i>";
    if (acc.ref().accountName().empty())
      result+=acc.ref().accountId();
    else
      result+=acc.ref().accountName();
    result+="</i> bei <i>";

    // get institute name
    bank=acc.ref().bank();

    result+=bank.ref().name();
    result+="</i></H2><BR>\n";
    tm=TransactionMatcher(0,
			  "*",
			  "*",
			  fromdate,
			  todate,
			  flags & 0xffff);

    if (flags & AQM_DUMP_FLAGS_XACTIONS) {
      if (acc.ref().transactions().empty())
	result+=" --- keine Ums&auml;tze ---<BR>\n";
      else {
	result+="<h4>Ums&auml;tze</h4>\n";
	result+="<TABLE BORDER=\"1\" WIDTH=\"100%\">\n";
	result+="<TR>";
	result+="<TH>Datum</TH>";
	result+="<TH>Text</TH>";
	result+="<TH>Name/Verwendungszweck</TH>";
	result+="<TH>Betrag</TH>";
	result+="</TR>\n";

	row=0;
	for (iter=acc.ref().transactions().begin();
	     iter!=acc.ref().transactions().end();
	     iter++) {
	  AQMTransaction aqmxa;

	  aqmxa=*iter;
	  // match transaction
	  if (!tm.match(aqmxa))
	    continue;

	  // dump
	  height=0;
	  if (!_xactionToEntry(aqmxa,e,height))
	    return "";
	  result+=_entryToTable(e,height,row);
	  result+="\n";

	  // compute values
	  tmpval=convertValue(aqmxa.value(),"EUR");
	  if (tmpval.getValue()<0)
	    vout+=-(tmpval.getValue());
	  else
	    vin+=tmpval.getValue();

	  row++;
	} // for
	result+="</TABLE>\n";
      }
    } // if wantXActions
    if (flags & AQM_DUMP_FLAGS_BALANCE)
      result+=dumpBalanceHTML(acc.ref().balance(),
			      HBCI::Value(vin,acc.ref().currency()),
			      HBCI::Value(vout,acc.ref().currency()));
    // show standing orders
    if (flags & AQM_DUMP_FLAGS_STO) {
      result+="<h4>Dauerauftr&auml;ge</h4>\n";
      for (stit=acc.ref().standingOrders().begin();
	   stit!=acc.ref().standingOrders().end();
	   stit++)
	result+=dumpStandingOrderHTML(*stit);
    }
    result+="<BR><BR>\n";
    return result;
}



string dumpUserTXT(HBCI::Pointer<HBCI::User> u) {
  list<HBCI::Pointer<HBCI::Customer> >::const_iterator cit;
  string result;

  result+="Benutzername   : ";
  result+=u.ref().userName();
  result+="\n";
  result+="Benutzerkennung: ";
  result+=u.ref().userId();
  result+="\n";
  if (!(u.ref().customers().empty())) {
    for (cit=u.ref().customers().begin();
	 cit!=u.ref().customers().end();
	 cit++) {
      result+=" Kunde\n";
      result+="  Kundenrolle  : ";
      result+=(*cit).ref().custName();
      result+="\n";
      result+="  Kundenkennung: ";
      result+=(*cit).ref().custId();
      result+="\n";
    }
  }
  return result;
}


string dumpUserHTML(HBCI::Pointer<HBCI::User> u) {
  list<HBCI::Pointer<HBCI::Customer> >::const_iterator cit;
  string result;

  result+="<table>\n";
  result+="<tr><td>Benutzername</td><td>";
  result+=u.ref().userName();
  result+="</td></tr>\n";
  result+="<tr><td>Benutzerkennung</td><td>";
  result+=u.ref().userId();
  result+="</td></tr>\n";
  if (!(u.ref().customers().empty())) {
    result+="<tr><td>";
    result+=" Kundenliste\n";
    result+="<table>";
    for (cit=u.ref().customers().begin();
	 cit!=u.ref().customers().end();
	 cit++) {
      result+="<tr><td>Kundenrolle</td><td>";
      result+=(*cit).ref().custName();
      result+="</td></tr>\n";
      result+="<tr><td>Kundenkennung</td><td>";
      result+=(*cit).ref().custId();
      result+="</td></tr>\n";
    }
    result+="</table>";
  }
  result+="</table>";
  return result;
}


string dumpTransfersTXT(const list<AQMTransaction> &xa,
			unsigned int flags,
			const HBCI::Date &fromdate,
			const HBCI::Date &todate){
  list<AQMTransaction>::const_iterator it;
  string result;
  TransactionMatcher tm;
  int xanum;

  tm=TransactionMatcher(0,
			"*",
			"*",
			fromdate,
			todate,
			flags & 0xffff);

  result+="\nberweisungen und Lastschriften\n";
  xanum=0;
  result+=string(SIZE_ALL,'=')+"\n";
  for (it=xa.begin();
       it!=xa.end();
       it++) {
    if (!tm.match(*it))
      continue;
    // dump
    xanum++;
    result+=dumpXactionTXT(*it);

    // add status
    result+="Status: ";
    if ((*it).status().result()!=-1) {
      if ((*it).status().resultText().empty()) {
	result+="[Noch nicht ermittelt, verwenden Sie \"getstatus\"]";
      }
      else {
	result+=(*it).status().resultText();
      }
      result+=" (";
      result+=String::num2string((*it).status().result());
      result+=")";
    }
    else
      result+="unbekannt";
    result+="\n";

    result+=string(SIZE_ALL,'-');

    result+="\n";
  } // for

  if (xanum==0)
    result+=" --- keine berweisungen/Lastschriften ---\n";

  return result;
}


HBCI::Error dump(HBCI::Pointer<AQMAPI> hbciif,
		 HBCI::SimpleConfig &opt){
  HBCI::Tree<HBCI::ConfigNode>::iterator var;
  int country;
  string instid;
  string userid;
  string accnr;
  list<HBCI::Pointer<HBCI::Account> > accounts;
  list<HBCI::Pointer<HBCI::Account> >::const_iterator iter;
  HBCI::Error err;
  unsigned int flags=0;
  string result;
  string tmp;
  string fdate;
  string tdate;
  HBCI::Date fromdate;
  HBCI::Date todate;
  list<HBCI::Pointer<HBCI::Bank> > banks;
  list<HBCI::Pointer<HBCI::Bank> >::const_iterator bit;
  list<HBCI::instituteMessage>::const_iterator mit;
  int first;

  country=opt.getIntVariable("country",0,opt.root());
  instid=opt.getVariable("instid","*",opt.root());
  userid=opt.getVariable("user","*",opt.root());
  accnr=opt.getVariable("accnr","*",opt.root());
  if (opt.findVariable("balance",opt.root(),false).isValid())
    flags|=AQM_DUMP_FLAGS_BALANCE;
  if (opt.findVariable("xactions",opt.root(),false).isValid())
    flags|=AQM_DUMP_FLAGS_XACTIONS;
  if (opt.findVariable("users",opt.root(),false).isValid())
    flags|=AQM_DUMP_FLAGS_USERS;
  if (opt.findVariable("transfers",opt.root(),false).isValid())
    flags|=AQM_DUMP_FLAGS_TRANSFERS;

  fdate=opt.getVariable("fromdate","",opt.root());
  tdate=opt.getVariable("todate","",opt.root());
  tmp=opt.getVariable("outformat",
		      opt.getVariable("output","txt",opt.root()),
		      opt.root());
  if (-1!=HBCI::parser::cmpPattern(tmp,
				   "html",
				   false))
    flags|=AQM_DUMP_FLAGS_HTML;

  if (opt.findVariable("sto",opt.root(),false).isValid())
    flags|=AQM_DUMP_FLAGS_STO;
  if (opt.findVariable("msg",opt.root(),false).isValid())
    flags|=AQM_DUMP_FLAGS_MESSAGE;

  flags|=TM_FLAGS_POSITIVE;
  flags|=TM_FLAGS_NEGATIVE;
  if (opt.findVariable("pos",opt.root(),false).isValid())
    flags&=~TM_FLAGS_NEGATIVE;
  if (opt.findVariable("neg",opt.root(),false).isValid())
    flags&=~TM_FLAGS_POSITIVE;

  if (opt.findVariable("open",opt.root(),false).isValid())
    flags|=TM_FLAGS_OPEN;
  if (opt.findVariable("failed",opt.root(),false).isValid())
    flags|=TM_FLAGS_FAILED;
  if (opt.findVariable("done",opt.root(),false).isValid())
    flags|=TM_FLAGS_DONE;
  if (opt.findVariable("nounknown",opt.root(),false).isValid())
    flags|=TM_FLAGS_NO_UNKNOWN;

  if ((flags & (TM_FLAGS_OPEN |
		TM_FLAGS_FAILED |
		TM_FLAGS_DONE))==0)
    flags|=(TM_FLAGS_OPEN |
	    TM_FLAGS_FAILED |
	    TM_FLAGS_DONE);

  // set from date
  if (!fdate.empty()) {
    fromdate=HBCI::Date(fdate,4);
    if (!fromdate.isValid())
      return HBCI::Error("dump()",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "error in date format (use YYYYMMDD).");
  }
  // set todate
  if (!tdate.empty()) {
    todate=HBCI::Date(tdate,4);
    if (!todate.isValid())
      return HBCI::Error("dump()",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "error in date format.");
  }

  // get accounts
  accounts=hbciif.ref().getAccounts(country,instid,accnr);

  // create head
  if (flags & AQM_DUMP_FLAGS_HTML) {
    result+="<!DOCTYPE HTML PUBLIC \"";
    result+="-//W3C//DTD HTML 4.01 Transitional//EN\">";
    result+="<HTML>";
    result+="<meta name=\"Generator\" ";
    result+="content=\"AqMoney "k_AQMONEY_VERSION_STRING"\">\n";
    result+="<meta name=\"Author\" content=\"Martin Preuss\">\n";
    result+="<meta http-equiv=\"Content-Type\"";
    result+="content=\"text/html; charset=ISO-8859-1\">\n";
    result+="<title>Transactions</title>\n";
    result+="</head>\n";
    result+="<BODY>\n";
  }
  else
    result.erase();

  if (flags & AQM_DUMP_FLAGS_USERS) {
    list<HBCI::Pointer<HBCI::User> > users;
    list<HBCI::Pointer<HBCI::User> >::iterator uit;

    users=hbciif.ref().getUsers(country,instid, userid);
    if (!users.empty()) {
      if (flags & AQM_DUMP_FLAGS_HTML) {
	result+="<h4>Benutzerliste</h4>\n";
	for (uit=users.begin();
	     uit!=users.end();
	     uit++) {
	  result+=dumpUserHTML(*uit);
	}
      }
      else {
	result+="Benutzerliste\n";
	result+=string(SIZE_ALL,'=')+"\n";
	for (uit=users.begin();
	     uit!=users.end();
	     uit++) {
	  result+=dumpUserTXT(*uit);
	  result+=string(SIZE_ALL,'-')+"\n";
	} // for
      }
      result+="\n";
    }
  }

  first=1;
  for (iter=accounts.begin();
       iter!=accounts.end();
       iter++) {
    if (first)
      first=0;
    else
      result+="\n";
    if (flags & AQM_DUMP_FLAGS_HTML)
      result+=dumpAccountHTML(hbciif,
			      *iter,
                              flags,
			      fromdate,
			      todate)+"<br>\n";
    else
      result+=dumpAccountTXT(hbciif,
			     *iter,
                             flags,
			     fromdate,
			     todate);
  } // for


  if (flags & AQM_DUMP_FLAGS_TRANSFERS) {
    if (flags & AQM_DUMP_FLAGS_HTML) {
    }
    else
      result+=dumpTransfersTXT(hbciif.ref().transfers(),
			       flags,
			       fromdate,
			       todate);
  }

  // show institute messages
  if (flags & AQM_DUMP_FLAGS_MESSAGE) {
    banks=hbciif.ref().banks();
    if (flags & AQM_DUMP_FLAGS_HTML)
      result+="<h4>Institutsmitteilungen</h4>\n";
    else {
      result+="\nInstitutsmitteilungen\n";
      result+=string(SIZE_ALL,'=')+"\n";
    }
    for (bit=banks.begin();
	 bit!=banks.end();
	 bit++) {
      if ((*bit).ref().messages().empty())
	break;

      if (flags & AQM_DUMP_FLAGS_HTML) {
	result+="<h5>Mitteilungen von ";
	result+=(*bit).ref().name();
	result+=" (BLZ: ";
	result+=(*bit).ref().bankCode();
	result+=")</h5>\n";
      }
      else {
	result+="\nMitteilungen von ";
	result+=(*bit).ref().name();
	result+=" (BLZ: ";
	result+=(*bit).ref().bankCode();
	result+=")\n\n";
      }
      for (mit=(*bit).ref().messages().begin();
	   mit!=(*bit).ref().messages().end();
	   mit++) {
	if (flags & AQM_DUMP_FLAGS_HTML)
	  result+=dumpBankMessageHTML(*mit);
	else
	  result+=dumpBankMessageTXT(*mit);
      } // for message
    } // for bank
  } // if wantMSG

  if (flags & AQM_DUMP_FLAGS_HTML)
    result+="</BODY></HTML>\n";

  // print result
  fprintf(stdout,"%s",result.c_str());
  return HBCI::Error();
}





