/***************************************************************************
 $RCSfile: aqmconverterdta.h,v $
                             -------------------
    cvs         : $Id: aqmconverterdta.h,v 1.1 2003/05/29 15:37:48 aquamaniac Exp $
    begin       : Sun May 18 2003
    copyright   : (C) 2003 by Werner Partner & Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef CONVERTERDTA_H
#define CONVERTERDTA_H


#include "aqmconverter.h"


/**
 * @author Werner Partner, Martin Preuss
 */
class AQMConverterDTA: public AQMConverter {
private:
public:
  AQMConverterDTA();
  virtual ~AQMConverterDTA();

  /**
   * Die DTA-Datei wird gelesen und konvertiert
   * Fehlerprfung:
   * - ungltige Satzarten (drfen eigentlich nicht vorkommen)
   * - Mischung von transfer und debitnote
   * Der Benutzer ist selbst verantwortlich, wie seine Quelldaten
   * aussehen.
   * Er kann ein Tool verwenden oder die DTA-Datei selbst herstel-
   * len. Sinnvoll ist allerdings eine Anwendung, die DTA-Dateien
   * standardmig herstellt, wie z.B. Quicken, Proficash, Gnucash,
   * Moneyplex oder andere.
   * Es drfen mehrere DTA-Dateien hintereinander gekettet werden,
   * Einzge und berweisungen (debitnote, transfer) drfen aber
   * nicht vermischt werden.
   * Achtung:
   * Bei Quicken gibt es eine Besonderheit:
   * Der Quicken-Export stellt keine fertigen Auftragsdaten
   * zur Verfgung, sondern zustzlich zur Buchungsdatei
   * wird die Adressdatei mit den Kontodaten bentigt.
   * Hier muss vor die Buchungsdatei die Adressdatei gehngt
   * werden:
   * cat <adressdat> <buchdat> | mon2aqmon > <aqmoney-Datei>
   *
   * @author Werner Partner
   */
  virtual Error readFromStream(HBCI::Pointer<Stream> s);
};


#endif

