// keybindings.h, -*-c++-*-
//
//  Copyright 1999,2000 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.

#ifndef KEYBINDINGS_H
#define KEYBINDINGS_H

#include <string>
#include <list>

#ifdef HAVE_CONFIG_H
#include "../../../config.h"
#endif

#ifdef HAVE_HASH_MAP
#include <hash_map>
#else
#ifdef HAVE_EXT_HASH_MAP
#include <ext/hash_map>
#else
// Fallback to the non-hashing map class
#include <map>
#define hash_map map
#endif
#endif

#include "../../generic/strhash.h"
#include "../curses++.h"

typedef std::list<chtype> keybinding;

class keybindings
{
  std::hash_map<std::string, keybinding> keymap;

  keybindings *parent;
public:
  keybindings(keybindings *_parent=NULL):parent(_parent) {}

  std::string keyname(std::string tag);

  keybinding get(std::string tag)
    // Returns the keybinding for the given string.  Almost never needed.
  {
    std::hash_map<std::string, keybinding>::iterator found=keymap.find(tag);

    if(found==keymap.end())
      return keybinding();
    else
      return found->second;
  }

  void set(std::string tag, keybinding strokes);
  // Adds a setting for the given binding, clobbering whatever was there
  // previously.

  void set(std::string tag, chtype stroke)
  {
    keybinding strokes;
    strokes.push_back(stroke);
    set(tag, strokes);
  }

  bool key_matches(chtype ch, std::string tag);
  // Tests whether the given keystroke matches the keybinding with the given
  // name.  If no keybinding by that name exists, the match fails.
};

chtype parse_key(std::string keystr);
// Parses a string to a keycode.  Returns ERR if the parse fails.

std::string keyname(chtype ch);
// Returns a string identifying the given keystroke.

extern keybindings global_bindings;
// For now, this is where the global bindings are stored (I might want to move
// it in the future, hmmm..)

// Stolen from pinfo.  I don't like the looks of it, but presumably it works
// (in some circumstances).  This is a FIXME, btw :)
/* adapted from Midnight Commander */
#define KEY_CTRL(x) ((x)&31)	/* macro to get CTRL+key sequence */
#define KEY_ALT(x) (0x200 | (x))	/* macro to get ALT+key sequence */


#endif
