
#ifndef _CON_H
#define _CON_H

#include "config.h"
#include "lockable.h"

#include <list>
#include <string>

#define RBUFLEN 16384

class dlcon;
class job;
class header;

class con;
typedef SHARED_PTR<con> tConPtr;

class con {
   public: 
      con(int fdId, const char *client);
      ~con();
      
      void WorkLoop();
      //void HelpLoop();
#ifdef KILLABLE
      //! Tell running threads to stop
      void SignalStop();
#endif
      
      void LogDataCounts(MYSTD::string & file, 
    		  const char *xff,
    		  off_t countIn, off_t countOut);
      
   private:
	   con& operator=(const con&);// { /* ASSERT(!"Don't copy con objects"); */ };
	   con(const con&);// { /* ASSERT(!"Don't copy con objects"); */ };

	      //! Terminate the connection descriptors gracefully
	      void ShutDown();



      int m_confd;
      
      MYSTD::list<job*> m_jobs2send;
      
#ifdef KILLABLE
      // to awake select with dummy data
      int wakepipe[2];
#endif
      
      bool m_bStopActivity;
      
      pthread_t m_dlerthr;
      
      // for jobs
      friend class job;
      bool SetupDownloader(const char *xff);
      dlcon * m_pDlClient;
      MYSTD::string m_sClientHost;
      header *m_pTmpHead;
      
      MYSTD::string m_sLoggedFile, m_sLoggedClient;
      off_t m_nLastIn, m_nLastOut;
      void _LogFlush();
};

#endif
