#ifndef CADDRINFO_H_
#define CADDRINFO_H_

#include "meta.h"
#include "rfc2553emu.h"
 
#ifndef HAVE_GETADDRINFO

#warning Not sure about gai_strerror, and this define check is stupid/incorrect too
#warning but most likely it is missing too -> fake it

#ifndef gai_strerror
#define gai_strerror(x) "Generic DNS error"
#endif

#endif


#if defined(__CYGWIN32__) || defined(__CYGWIN__)
#include <cygwin/in.h>
#endif

#ifndef AI_NUMERICSERV
#define AI_NUMERICSERV 0
#endif

#ifndef AI_ADDRCONFIG
#define AI_ADDRCONFIG 0
#endif

class CAddrInfo;

class CAddrInfo {
public:
	time_t m_nResTime;
	struct addrinfo * m_bestInfo;
	
	CAddrInfo();
	bool Resolve(const MYSTD::string & sHostname, const MYSTD::string &sPort, MYSTD::string & sErrorBuf);
	~CAddrInfo();

	typedef SHARED_PTR<CAddrInfo> SPtr;
	static SPtr CachedResolve(const MYSTD::string & sHostname, const MYSTD::string &sPort,
			MYSTD::string &sErrorMsgBuf);

protected:
	struct addrinfo * m_resolvedInfo; // getaddrinfo excrements, to cleanup

private:
	// not to be copied ever
	CAddrInfo(const CAddrInfo&);
	CAddrInfo operator=(const CAddrInfo&);

};


#endif /*CADDRINFO_H_*/
