

#define LOCAL_DEBUG
#include "debug.h"

#include "config.h"
#include "meta.h"
#include "acfg.h"
#include "expiration.h"
#include "conserver.h"

#include <iostream>
using namespace MYSTD;

#include <cstring>
#include <sys/time.h>
#include <signal.h>

static void usage();
static void _TestCacheDir();
void term_handler(int signum);
void log_handler(int signum);

int main(int argc, char **argv) {

	signal(SIGTERM, term_handler);
	signal(SIGINT, term_handler);
	signal(SIGQUIT, term_handler);
	signal(SIGUSR1, log_handler);
	signal(SIGUSR2, SIG_IGN);
	signal(SIGPIPE, SIG_IGN);
#ifdef SIGIO
	signal(SIGIO, SIG_IGN);
#endif
#ifdef SIGXFSZ
	signal(SIGXFSZ, SIG_IGN);
#endif
	
	bool bForceCleanup(false);
    for (int i=1; i<argc; i++) {

		if (!strncmp(argv[i], "-h", 2))
			usage();

		if (!strncmp(argv[i], "-v", 2))
		{
			acfg::debug=std::min(5, acfg::debug);
			*(argv[i])=0x0; // ignore if ever checked
		}

		if (!strncmp(argv[i], "-e", 2))
		{
			bForceCleanup=true;
			*(argv[i])=0x0; // ignore if ever checked
		}
		
    }
    
    for (int i=1; i<argc; i++) {
    	
        if(!strcmp(argv[i], "-c")) {
        	i++;
        	if(i<argc)
        		acfg::ReadConfigDirectory(argv[i]);
        	else
        		usage();
		}
		else if(! *(argv[i]))
			continue;
		else
		{
			if(!acfg::SetOption(argv[i], false))
				usage();
		}

	}
    
    if(!aclog::open()) {
        cerr << "Problem creating log files. Check permissions of the log directory, " << acfg::logdir<<endl;
        exit(1);
    }
    dbgline;
    
    _TestCacheDir();

	acfg::PostProcConfig();
	conserver::Setup();
	
	if (bForceCleanup) {
		expiration ex(fileno(stdout));
		ex.Run("");
	}

	if (acfg::foreground)
		return conserver::Run();

	daemon(0, 0);

	if (!acfg::pidfile.empty()) {
		mkbasedir(acfg::pidfile);
		FILE *PID_FILE = fopen(acfg::pidfile.c_str(), "w");
		if (PID_FILE != NULL) {
			fprintf(PID_FILE, "%d", getpid());
			fclose(PID_FILE);
		}
	}
	return conserver::Run();
	
}

static void usage() {
	cout <<"Usage: apt-cacher -h -c configdir <var=value ...>\n\n"
		"Options:\n"
		"-h: this help message\n"
		"-c configuration directory\n"
		"-e: run expiration on startup\n\n"
		"Most interesting variables:\n"
		"Daemon: 1 Daemonize program\n"
		"PidFile: /path/to/pidfile File to store daemon's PID\n"
		"FifoPath: /path/to/fifofile FIFO file, for control and local communication\n"
		"CacheDir: /directory/for/storage\n"
		"LogDir: /directory/for/logfiles\n"
		"\n"
		"See manpage for all directives.\n\n";
	exit(0);
}


static void _TestCacheDir() {       
	
	struct timeval tv;
	gettimeofday(&tv, NULL);
	
	vector<char> buf(acfg::cachedir.size()+30);
	snprintf(&buf[0], buf.size(), "%s"SZPATHSEP"testfile.%0lx",
			acfg::cachedir.c_str(), 42*tv.tv_usec*tv.tv_sec);
	
	mkbasedir(&buf[0]); // try or force its directory creation
	int t=open(&buf[0], O_WRONLY | O_CREAT | O_TRUNC, 00644);
	if (t<0) {
		cerr << "Cache directory not writable. Check the permissions of "
				<< acfg::cachedir << "!" <<endl;
		exit(1);
	}
	close(t);
	unlink(&buf[0]);
}

void log_handler(int)
{
	aclog::reopen();
}

void term_handler(int signum)
{
	switch (signum)
	{
	case (SIGTERM):
	case (SIGINT):
	case (SIGQUIT):
		aclog::close();
		// enough of the other crap, too unreliable behaviour WRT C++ cleanup and workarounds in code
		// would be lame. Just let the OS help with the suizide.
		signal(SIGINT, SIG_DFL);
		kill(getpid(), SIGINT);
	default:
		return;
	}
}


#ifdef PLAYGROUND

/* 
 * Let's be another md5sum tool...
 
	md5_state_s ctx;
	md5_init(&ctx);
	uint8_t buf[2000]; 
	while(!feof(stdin))
	{
		int n=fread(buf, sizeof(char), 2000, stdin);
		md5_append(&ctx, buf, n);
	}
	uint8_t sum[16];
	md5_finish(&ctx, sum);
	for(int i=0;i<16;i++)
		printf("%02x", sum[i]);
	printf("\n");
	exit(0);
*/
	/*
	uint8_t sum[16];
	string s(argv[1]);
	filereader::GetMd5Sum(s, sum);
	for(int i=0;i<16;i++)
			printf("%02x", sum[i]);
		printf("\n");
		if(CsEqual((unsigned char*) argv[2], sum))
			printf("Is OK\n");
		else
			printf("Differenz\n");
		exit(0);
	*/
	

// setup the signal handling as the every first thing
	
/*
 *     struct sigaction new_action, dummy_action;

    new_action.sa_handler = termination_handler;
    sigemptyset (&new_action.sa_mask);
    new_action.sa_flags = 0;

    //sigaction (SIGINT, NULL, &old_action);
    //if (old_action.sa_handler != SIG_IGN)
    sigaction (SIGINT, &new_action, NULL);
    sigaction (SIGKILL, &new_action, NULL);
    sigaction (SIGHUP, &new_action, NULL);
    sigaction (SIGTERM, &new_action, NULL);

    // FSCK LINUXTHREADS STOP KILLING MY APP EVEN IF LINKED STATICALY
    dummy_action.sa_handler = SIG_IGN;
    sigemptyset (&dummy_action.sa_mask);
    dummy_action.sa_flags = 0;
    sigaction(SIGRTMIN, &dummy_action, NULL);
    sigaction(SIGRTMIN+1, &dummy_action, NULL);
    sigaction(SIGRTMIN+2, &dummy_action, NULL);
    sigaction(SIGRTMIN+3, &dummy_action, NULL);

    int sigprocmask(int how, const sigset_t *set, sigset_t *oldset);
    
    // end signal setup
*/
#endif
