
//#define LOCAL_DEBUG
#include "debug.h"

#include "config.h"

#include "acbuf.h"
#include <errno.h>
#include <unistd.h>
#include <errno.h>
#include <sys/stat.h>

bool acbuf::init(unsigned int c) {
	if (m_buf && m_nCapacity==c)
	{
		ldbg("buffer allocated before");
	}
	else
	{
		m_nCapacity=c;
		if (m_buf)
		{
			delete [] m_buf;
			m_buf=NULL;
		}
		MYTRY
		{
			m_buf=new char[c+1];
		}
		MYCATCH(MYSTD::bad_alloc)
		{
			return false;
		}
		if(!m_buf)
			return false;
	}
    m_buf[c]=0; // terminate to make string operations safe
    r=w=0;
    return true;
}

bool acbuf::initFromFile(const char *szPath)
{
	struct stat statbuf;

	if (0!=stat(szPath, &statbuf))
		return false;

	int fd=open(szPath, O_RDONLY);
	if (fd<0)
		return false;

	if(!init(statbuf.st_size))
		return false;
	
	while (freecapa()>0)
	{
		if (sysread(fd) < 0)
		{
			close(fd);
			return false;
		}
	}
	close(fd);
	return true;
}

int acbuf::syswrite(int fd, unsigned int maxlen) {
    size_t todo(MYSTD::min(maxlen, size()));

	int n;
	do
	{
		n=::write(fd, rptr(), todo);
	} while(n<0 && errno==EINTR);
	
	if(n<0 && errno==EAGAIN)
		n=0;
    if(n<0)
        return -errno;
    drop(n);
    return n;
}

int acbuf::sysread(int fd) {
	int n;
	do {
		n=::read(fd, m_buf+w, m_nCapacity-w);
	} while(n<0 && errno==EINTR);
    //cerr << "sysread: " << free() <<endl;
    if(n<0)
    	return -errno;
    if(n>0)
        w+=n;
    return(n);
}
