#ifndef _META_H
#define _META_H

#include <string>
#include <map>
#include <set>
#include <vector>

#include <fcntl.h>
#include <pthread.h>
#include <strings.h>
#include <stdlib.h>
#include "aclogger.h"
//#include "acfg.h"

#define EXTREME_MEMORY_SAVING false


// some alternative versions of these flags

#ifndef O_NONBLOCK
#ifdef NOBLOCK
#define O_NONBLOCK NOBLOCK
#else
#ifdef O_NDELAY
#define O_NONBLOCK O_NDELAY
#endif
#endif
#endif

#ifndef O_NONBLOCK
#error "Unknown how to configure non-blocking mode (O_NONBLOCK) on this system"
#endif

#include <sys/socket.h>
#ifndef SO_MAXCONN
#define SO_MAXCONN 250
#endif
#if defined(__linux__)
#include <sys/socketvar.h>
#endif

#define PATHSEP "/"

void set_nb(int fd);

void mkbasedir(const MYSTD::string & path);

int getUUID();

struct ltstring
{
  bool operator()(const MYSTD::string &s1, const MYSTD::string &s2) const
  {
    return strcasecmp(s1.c_str(), s2.c_str()) < 0;
  }
};
/*
struct ltstr
{
  bool operator()(const char* s1, const char* s2) const
  {
    return strcasecmp(s1, s2) < 0;
  }
};
*/

#define SPACECHARS " \f\n\r\t\v"

typedef MYSTD::map<MYSTD::string, MYSTD::string, ltstring> NoCaseStringMap;
typedef MYSTD::map<MYSTD::string, MYSTD::string> tStringMap;

inline void trimFront(MYSTD::string &s, const char *junk=SPACECHARS)
{
	MYSTD::string::size_type pos = s.find_first_not_of(junk);
	if(pos != 0)
		s.erase(0, pos);
}

inline void trimBack(MYSTD::string &s, const char *junk=SPACECHARS)
{
	MYSTD::string::size_type pos = s.find_last_not_of(junk);
	s.erase(pos+1);
}

inline void trimString(MYSTD::string &s, const char *junk=SPACECHARS)
{
	trimBack(s, junk);
	trimFront(s, junk);
}

//MYSTD::string sbasename(const char *in);

void trimProto(MYSTD::string & sUri);
tStrPos findHostStart(const MYSTD::string & sUri);

#define _countof(x) sizeof(x)/sizeof(x[0])


/*
int getFiletype (const char *tstr);

bool isToxic(const char *taint);
*/

extern MYSTD::string sPathSep, sPathSepUnix, sCR, sCRLF;
extern const char *szPathSep;

const char cPathSep='/';


// there is memchr and strpbrk but nothing like the last one acting on specified RAW memory range
static inline char * mempbrk (char * membuf, char const * const needles, size_t len)
{
   for(char *pWhere=membuf ; pWhere<membuf+len ; pWhere++)
      for(const char *pWhat=needles; *pWhat ; pWhat++)
         if(*pWhat==*pWhere)
            return pWhere;
   return NULL;
}

typedef MYSTD::vector<MYSTD::string> tStrVec;
/*
template<class T>
bool VectorContains(const MYSTD::vector<T> haystack, const T needle)
{
	for(unsigned long i=0; i<haystack.size();i++)
	{
		if(needle==haystack[i])
			return true;
	}
	return false;
}
*/

// Sometimes I miss Perl...
tStrVec::size_type Tokenize(const MYSTD::string &in, const char *sep, tStrVec & out);
void Join(MYSTD::string &out, const MYSTD::string & sep, const tStrVec & tokens);

// TODO: __attribute__((externally_visible))
bool _ParseLine(const MYSTD::string & sIn, MYSTD::string & sOutKey, MYSTD::string & sOutVal);
#define keyEq(a, b) (0 == strcasecmp(a, b.c_str()))


class tHttpUrl {
public:
	bool SetHttpUrl(MYSTD::string uri);
	/*
	/// The specified url has a path which is a prefix of the one in *this 
	UINT HasPathPrefix(const tHttpUrl &another);
	*/
	MYSTD::string ToString() const;
	MYSTD::string sHost, sPort, sPath;
	//void *pMisc;
};

#define POKE(x) while( write(x, "", 1) <0);

typedef struct { const char *name; MYSTD::string *ptr; } MapNameToString;
typedef struct { const char *name; int *ptr; } MapNameToInt;

void appendLong(MYSTD::string &s, long val);

#define OFFT_MAX (std::numeric_limits<off_t>::max())

bool FileCopy(const MYSTD::string &from, const MYSTD::string to);

#endif


