#ifndef EXPIRATION_H_
#define EXPIRATION_H_

#include "config.h"
#include "meta.h"
#include "dirwalk.h"
#include "rechecks.h"
#include "maintenance.h"
#include "lockable.h"

class dlcon;

class expiration : public IFileHandler, public maintenance {

public:
	expiration(int);
	~expiration();
	
	virtual void Run(const MYSTD::string &cmd);
	virtual void Action(const MYSTD::string &);
	
	// FileHandler
	virtual void ProcessRegular(const MYSTD::string &sPath, const struct stat &);
	virtual void ProcessOthers(const MYSTD::string &sPath, const struct stat &);
	tStrVec m_volatileFiles;

protected:

	/// store a copy of the data in a file and then pass it to the base class
	virtual void SendMsg(const MYSTD::string &x);
	void DumpLog(time_t id);
	
	void _UpdateVolatileFiles();
	void _BusyDisplayLogs();
	void _Usermsg(MYSTD::string m);
	virtual void _HandlePkgEntry(const MYSTD::string & refererPath, const NoCaseStringMap &info);
	void _ParseVolatileFilesAndHandleEntries();
	bool _DownloadOne(dlcon &dl, const MYSTD::string & sFilePath, MYSTD::string &sErrOut);
	
	// File handler
	time_t m_nTimeNow;
	tStrPos m_nDropPrefLen;
	rechecks m_rex;

	bool m_bErrAbort;
	int m_nErrorCount;

private:
	
	// local file name, time when the file became unreferenced, path to its directory
	typedef MYSTD::multimap<MYSTD::string,MYSTD::pair<time_t,MYSTD::string> > trashmap_t;
	// defined as multimap since might have multiple locations (=folders) of the 
	// same file (identified by filename)
	trashmap_t m_trashCandidates;
	
	// t.h. with trees&Co., this is fast enough
	tStrVec m_seenList;
	
	void _RemoveAndStoreStatus(bool bPurgeNow);
	void _LoadTrashMapFromFile();
	void _PurgeMaintLogs();
	
	FILE *m_repFileStream;

	expiration(const expiration&);
	expiration& operator=(const expiration&);
};


#endif /*EXPIRATION_H_*/
