
#ifndef _DLCON_H
#define _DLCON_H

#include <string>
#include <list>
#include <map>

#include <netinet/in.h>
#include <netdb.h>

#include "lockable.h"
#include "fileitem.h"
#include "acfg.h"
#include "acbuf.h"

class tDlJob;

typedef enum {
	STATE_GETHEADER
	,STATE_GETDATA
	,STATE_GETDATA_CHUNKED
	,STATE_GETCHUNKHEAD
	,STATE_FINISHJOB
} tDlState;

class dlcon : public lockable
{ 
	
    public:
        dlcon();
        ~dlcon();
                
        void WorkLoop(bool bSingleRun=false);
        
        void SignalStop();

	    void AddJob(tFileItemPtr m_pItem, tHttpUrl hi);
        void AddJob(tFileItemPtr m_pItem, 
        		acfg::tHostiVec *pBackends, const MYSTD::string & sPatSuffix);
        //void Reset();
        
    private:
    	
    	inline void _AddJob(tDlJob*);

    	MYSTD::list<tDlJob*> m_qToReceive;
    	int m_wakepipe[2];
    	
    	int m_conFd;
    	MYSTD::string m_sConnectedHost; // used to remember to which host we are connected

    	MYSTD::string m_sSendBuf, m_sErrorMsgBuf;
    	MYSTD::string m_sReqBufForHost;
    	acbuf m_InBuf;
    	
    	// flags and local copies for input parsing
    	/// remember being attached to an fitem
    	bool m_bIsResponsibleDler:1;
    	bool m_bReconnectASAP:1;
    	// released by the creator, allowed to terminate ASAP
    	bool m_bOrphaned:1;
    	
    	off_t m_nRest;
    	tDlState m_DlState;
    	tHttpUrl * m_proxy;
    
    	void MakeRequest(tDlJob*);
    	
    	bool _CheckNoMoreUsers();
    	bool _Connect(const MYSTD::string & sHostname);
    	void _CleanupForFailedHost(const MYSTD::string & szErrorMsg);
    	bool _HandleIncoming(MYSTD::string & sErrorOut);
    	bool _HotDetach();
    	bool _CleanOneJob();
    	
    	//not to be copied
    	dlcon & operator=(const dlcon&);
    	dlcon(const dlcon&);
};

#endif


