
#ifndef __CONFIG_H_
#define __CONFIG_H_

// keep this consistently, for experiments with other STL implementations
#define MYSTD std
//#define MYSTD ustl
//#include <ustl.h>

#ifndef USE_BOOST
#include <tr1/memory>
#define SMARTPTR_SPACE MYSTD::tr1
#else
#include <boost/smart_ptr.hpp>
#define SMARTPTR_SPACE boost
#endif

#define SHARED_PTR SMARTPTR_SPACE::shared_ptr
#define INTRUSIVE_PTR SMARTPTR_SPACE::intrusive_ptr
#define WEAK_PTR SMARTPTR_SPACE::weak_ptr
#define SCOPED_PTR MYSTD::auto_ptr

#ifdef NO_EXCEPTIONS
#define MYTRY
#define MYCATCH(x) if(false)
#else
#define MYTRY try
#define MYCATCH catch
#endif

//#define atooff_t atoi
#define tStrPos MYSTD::string::size_type 
#define stmiss MYSTD::string::npos
#define UINT unsigned int
#define USHORT unsigned short

#define __STDC_FORMAT_MACROS
#include <inttypes.h>

#ifdef WINDOWS
#define WIN32
#define SZPATHSEP "\\"
#else
#define SZPATHSEP "/"
#endif

#define ENEMIESOFDOSFS "?[]\\=+<>:;#"

#ifndef _EMBED
#define HAS_WORDEXP 1
#define HAS_ADVISE 1
#define HAS_IPV6SOCKETS 1

#define HAS_ZLIB 1
#define HAS_BZ2LIB 1

#endif

#endif // __CONFIG_H

