#ifndef CADDRINFO_H_
#define CADDRINFO_H_

#include "meta.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>

class CAddrInfo {
public:
	time_t m_nResTime;
	struct addrinfo * m_bestInfo;
	
	CAddrInfo();
	bool Resolve(const MYSTD::string & sHostname, const MYSTD::string &sPort, MYSTD::string & sErrorBuf);
	~CAddrInfo();
protected:
	struct addrinfo * m_resolvedInfo; // getaddrinfo excrements, to cleanup
private:
	// not to be copied ever
	CAddrInfo(const CAddrInfo&);
	CAddrInfo operator=(const CAddrInfo&);
};

typedef SHARED_PTR<CAddrInfo> CAddrInfoPtr;
CAddrInfoPtr _Resolve(const MYSTD::string & sHostname, const MYSTD::string &sPort, 
		MYSTD::string &sErrorMsgBuf);

#endif /*CADDRINFO_H_*/
