#!/usr/bin/perl
#======================================================================
# ricercaseq2.pl <lemento-cercato> <valore>...
#======================================================================

#======================================================================
# &ricercaseq ( <lista>, <elemento>, <inizio>, <fine> )
#----------------------------------------------------------------------
sub ricercaseq {
    #------------------------------------------------------------------
    # Il primo argomento  un riferimento all'array, per cui
    # lo scalare $lista diventa il nuovo riferimento locale all'array.
    # Per leggerlo come array occorrer la forma @$lista, mentre
    # per leggerne un elemento occorrer la forma ${$lista}[n].
    #------------------------------------------------------------------
    local( $lista ) = @_[0];
    local( $x ) = @_[1];
    local( $a ) = @_[2];
    local( $z ) = @_[3];

    if ( $a > $z ) {
        return -1;
    } elsif ( $x == ${$lista}[$a] ) {
        return $a;
    } else {
        return &ricercaseq ( $lista, $x, $a+1, $z );
    };
};
#======================================================================

#======================================================================
# Inizio del programma.
#----------------------------------------------------------------------

$x = $ARGV[0];
@lista = @ARGV[1 .. $#ARGV];

$i = &ricercaseq (\@lista, $x, 0, $#lista);

print "L'elemento $x si trova nella posizione $i\n";

#======================================================================

